/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.baselines;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

@PipeBitInfo(name="Location of Annotator 3", description="Links each anatomical site with the closest entity of a type that's suitable for location_of, as long as there is no intervening anatomical site.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.LOCATION_RELATION})
public class Baseline3EntityMentionPairRelationExtractorAnnotator
extends RelationExtractorAnnotator {
    @Override
    public Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        List entityMentions = JCasUtil.selectCovered((JCas)identifiedAnnotationView, EntityMention.class, (AnnotationFS)sentence);
        List<EntityMention> anatomicalSites = Baseline3EntityMentionPairRelationExtractorAnnotator.getAnatomicalSites(entityMentions);
        List<EntityMention> entitiesSuitableForLocationOf = Baseline3EntityMentionPairRelationExtractorAnnotator.getEntitiesSuitableForLocationOf(entityMentions);
        if (anatomicalSites.size() < 1 || entitiesSuitableForLocationOf.size() < 1) {
            return new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        }
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> result = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        HashSet<EntityMention> alreadyLinked = new HashSet<EntityMention>();
        for (EntityMention anatomicalSite : anatomicalSites) {
            EntityMention nearestEntity;
            if (Baseline3EntityMentionPairRelationExtractorAnnotator.checkForAnatomicalSiteBetween(identifiedAnnotationView, anatomicalSite, nearestEntity = Baseline3EntityMentionPairRelationExtractorAnnotator.getNearestEntity(identifiedAnnotationView, anatomicalSite, entitiesSuitableForLocationOf)) || alreadyLinked.contains(nearestEntity)) continue;
            result.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)anatomicalSite, (IdentifiedAnnotation)nearestEntity));
            alreadyLinked.add(nearestEntity);
        }
        return result;
    }

    private static List<EntityMention> getAnatomicalSites(List<EntityMention> entityMentions) {
        ArrayList<EntityMention> anatomicalSites = new ArrayList<EntityMention>();
        for (EntityMention entityMention : entityMentions) {
            if (entityMention.getTypeID() != 6) continue;
            anatomicalSites.add(entityMention);
        }
        return anatomicalSites;
    }

    private static List<EntityMention> getEntitiesSuitableForLocationOf(List<EntityMention> entityMentions) {
        HashSet<Integer> okArg2Types = new HashSet<Integer>(Arrays.asList(2, 3, 5));
        ArrayList<EntityMention> suitableEntities = new ArrayList<EntityMention>();
        for (EntityMention entityMention : entityMentions) {
            if (!okArg2Types.contains(entityMention.getTypeID())) continue;
            suitableEntities.add(entityMention);
        }
        return suitableEntities;
    }

    private static EntityMention getNearestEntity(JCas jCas, EntityMention anatomicalSite, List<EntityMention> entityMentions) {
        HashMap<EntityMention, Integer> distanceToEntities = new HashMap<EntityMention, Integer>();
        for (EntityMention entityMention : entityMentions) {
            List baseTokens = JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)anatomicalSite, (AnnotationFS)entityMention);
            distanceToEntities.put(entityMention, baseTokens.size());
        }
        ArrayList sortedEntityMentions = new ArrayList(distanceToEntities.keySet());
        Function getValue = Functions.forMap(distanceToEntities);
        Collections.sort(sortedEntityMentions, Ordering.natural().onResultOf(getValue));
        return (EntityMention)sortedEntityMentions.get(0);
    }

    private static boolean checkForAnatomicalSiteBetween(JCas jCas, EntityMention entity1, EntityMention entity2) {
        for (EntityMention entityMention : JCasUtil.selectBetween((JCas)jCas, EntityMention.class, (AnnotationFS)entity1, (AnnotationFS)entity2)) {
            if (entityMention.getTypeID() != 6) continue;
            return true;
        }
        return false;
    }

    @Override
    public String classify(List<Feature> features) {
        return "location_of";
    }
}

