/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@PipeBitInfo(name="Identified Annotation Expander", description="Enlarges the text span of an identified annotation based upon part of speech.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class IdentifiedAnnotationExpander
extends JCasAnnotator_ImplBase {
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (EventMention eventMention : JCasUtil.select((JCas)jCas, EventMention.class)) {
            List<Integer> list = IdentifiedAnnotationExpander.expandToNP(jCas, (IdentifiedAnnotation)eventMention);
        }
    }

    public static List<Integer> expandToNP(JCas jCas, IdentifiedAnnotation identifiedAnnotation) {
        ArrayList originalSpan = Lists.newArrayList((Object[])new Integer[]{identifiedAnnotation.getBegin(), identifiedAnnotation.getEnd()});
        HashMap<TreebankNode, Integer> treebankNodeSizes = new HashMap<TreebankNode, Integer>();
        for (TreebankNode treebankNode : JCasUtil.selectCovering((JCas)jCas, TreebankNode.class, (int)identifiedAnnotation.getBegin(), (int)identifiedAnnotation.getEnd())) {
            if (treebankNode instanceof TerminalTreebankNode && !treebankNode.getNodeType().startsWith("N")) {
                return originalSpan;
            }
            if (!treebankNode.getNodeType().equals("NP")) continue;
            treebankNodeSizes.put(treebankNode, treebankNode.getCoveredText().length());
        }
        ArrayList sortedTreebankNodes = new ArrayList(treebankNodeSizes.keySet());
        Function getValue = Functions.forMap(treebankNodeSizes);
        Collections.sort(sortedTreebankNodes, Ordering.natural().onResultOf(getValue));
        if (sortedTreebankNodes.size() > 0) {
            identifiedAnnotation.setBegin(((TreebankNode)sortedTreebankNodes.get(0)).getBegin());
            identifiedAnnotation.setEnd(((TreebankNode)sortedTreebankNodes.get(0)).getEnd());
        }
        return originalSpan;
    }

    public static String getEnclosingNP(JCas jCas, IdentifiedAnnotation identifiedAnnotation) {
        HashMap<TreebankNode, Integer> treebankNodeSizes = new HashMap<TreebankNode, Integer>();
        for (TreebankNode treebankNode : JCasUtil.selectCovering((JCas)jCas, TreebankNode.class, (int)identifiedAnnotation.getBegin(), (int)identifiedAnnotation.getEnd())) {
            if (treebankNode instanceof TerminalTreebankNode && !treebankNode.getNodeType().startsWith("N")) {
                return identifiedAnnotation.getCoveredText();
            }
            if (!treebankNode.getNodeType().equals("NP")) continue;
            treebankNodeSizes.put(treebankNode, treebankNode.getCoveredText().length());
        }
        ArrayList sortedTreebankNodes = new ArrayList(treebankNodeSizes.keySet());
        Function getValue = Functions.forMap(treebankNodeSizes);
        Collections.sort(sortedTreebankNodes, Ordering.natural().onResultOf(getValue));
        if (sortedTreebankNodes.size() > 0) {
            return ((TreebankNode)sortedTreebankNodes.get(0)).getCoveredText();
        }
        return identifiedAnnotation.getCoveredText();
    }
}

