/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CausesBringsAboutTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="Causal Relation Annotator", description="Annotates Causal relations in sentences.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.GENERIC_RELATION})
public class CausesBringsAboutRelationExtractorAnnotator
extends RelationExtractorAnnotator {
    @Override
    protected Class<? extends BinaryTextRelation> getRelationClass() {
        return CausesBringsAboutTextRelation.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        List procedures = JCasUtil.selectCovered((JCas)identifiedAnnotationView, ProcedureMention.class, (AnnotationFS)sentence);
        List medications = JCasUtil.selectCovered((JCas)identifiedAnnotationView, MedicationMention.class, (AnnotationFS)sentence);
        List diseaseDisorders = JCasUtil.selectCovered((JCas)identifiedAnnotationView, DiseaseDisorderMention.class, (AnnotationFS)sentence);
        List signSymptoms = JCasUtil.selectCovered((JCas)identifiedAnnotationView, SignSymptomMention.class, (AnnotationFS)sentence);
        ArrayList arg1s = new ArrayList();
        arg1s.addAll(procedures);
        arg1s.addAll(medications);
        arg1s.addAll(diseaseDisorders);
        ArrayList arg2s = new ArrayList();
        arg2s.addAll(diseaseDisorders);
        arg2s.addAll(signSymptoms);
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        for (IdentifiedAnnotation arg1 : arg1s) {
            for (IdentifiedAnnotation arg2 : arg2s) {
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair(arg1, arg2));
            }
        }
        return pairs;
    }

    @Override
    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Argument");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Related_to");
        relArg2.addToIndexes();
        CausesBringsAboutTextRelation relation = new CausesBringsAboutTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
    }

    @Override
    protected Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }
}

