/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class Configuration {
    private static final String DEFAULT_FILE_REPOSITORY_PATH_NAME_FILTER = "org/apache/openejb";
    private static final String SYSTEM_PROPERTY_NAME_FOR_FILE_REPOSITORY_PATH_NAME_FILTER = "filter";
    private static final int ARGUMENT_INDEX_FOR_LOCAL_ROOT_DIRECTORY = 1;
    private static final int ARGUMENT_INDEX_FOR_URI_CONFIGURATION = 0;
    private static final int ARGUMENT_LENGTH_FOR_URI_CONFIGURATION_ONLY = 1;
    private final URI stagingRepositoryURI;
    private final String rootDirectoryForLocalOutput;
    private final String fileRepositoryPathNameFilter;

    private static URI toURI(String arg) throws URISyntaxException {
        URI uri = new URI(arg);
        if (arg.startsWith("file:")) {
            return new File(uri).getAbsoluteFile().toURI();
        }
        return uri;
    }

    public Configuration(String ... args) throws URISyntaxException {
        this.stagingRepositoryURI = Configuration.toURI(args[0]);
        this.rootDirectoryForLocalOutput = this.rootDirectoryForLocalOutput(args);
        this.fileRepositoryPathNameFilter = System.getProperty(SYSTEM_PROPERTY_NAME_FOR_FILE_REPOSITORY_PATH_NAME_FILTER, DEFAULT_FILE_REPOSITORY_PATH_NAME_FILTER);
    }

    public String getFileRepositoryPathNameFilter() {
        return this.fileRepositoryPathNameFilter;
    }

    public URI getStagingRepositoryURI() {
        return this.stagingRepositoryURI;
    }

    public String getRootDirectoryForLocalOutput() {
        return this.rootDirectoryForLocalOutput;
    }

    private String rootDirectoryForLocalOutput(String ... args) {
        String rootDirectoryForLocal = args.length > 1 ? args[1] : new File(this.stagingRepositoryURI.getPath()).getName();
        return rootDirectoryForLocal;
    }
}

