/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

@DefaultLocale(country="US", language="en")
public abstract class AbstractNumberValidatorTest {
    protected AbstractNumberValidator validator;
    protected AbstractNumberValidator strictValidator;
    protected Number max;
    protected Number maxPlusOne;
    protected Number min;
    protected Number minMinusOne;
    protected String[] invalid;
    protected String[] valid;
    protected Number[] validCompare;
    protected String[] invalidStrict;
    protected String[] validStrict;
    protected Number[] validStrictCompare;
    protected String testPattern;
    protected Number testNumber;
    protected Number testZero;
    protected String testStringUS;
    protected String testStringDE;
    protected String localeValue;
    protected String localePattern;
    protected Locale testLocale;
    protected Number localeExpected;

    @AfterEach
    protected void tearDown() {
        this.validator = null;
        this.strictValidator = null;
    }

    @Test
    void testFormat() {
        BigDecimal number = new BigDecimal("1234.5");
        Assertions.assertEquals((Object)"1,234.5", (Object)this.strictValidator.format((Object)number, Locale.US), (String)"US Locale, US Format");
        Assertions.assertEquals((Object)"1.234,5", (Object)this.strictValidator.format((Object)number, Locale.GERMAN), (String)"DE Locale, DE Format");
        Assertions.assertEquals((Object)"12,34.50", (Object)this.strictValidator.format((Object)number, "#,#0.00"), (String)"Pattern #,#0.00");
    }

    @Test
    void testFormatType() {
        Assertions.assertEquals((int)0, (int)this.validator.getFormatType(), (String)"Format Type A");
        Assertions.assertEquals((int)0, (int)this.validator.getFormatType(), (String)"Format Type B");
    }

    @Test
    void testInvalidNotStrict() {
        for (int i = 0; i < this.invalid.length; ++i) {
            String text = "idx=[" + i + "] value=[" + this.invalid[i] + "]";
            Assertions.assertNull((Object)this.validator.parse(this.invalid[i], null, Locale.US), (String)("(A) " + text));
            Assertions.assertFalse((boolean)this.validator.isValid(this.invalid[i], null, Locale.US), (String)("(B) " + text));
            Assertions.assertNull((Object)this.validator.parse(this.invalid[i], this.testPattern, null), (String)("(C) " + text));
            Assertions.assertFalse((boolean)this.validator.isValid(this.invalid[i], this.testPattern, null), (String)("(D) " + text));
        }
    }

    @Test
    void testInvalidStrict() {
        for (int i = 0; i < this.invalidStrict.length; ++i) {
            String text = "idx=[" + i + "] value=[" + this.invalidStrict[i] + "]";
            Assertions.assertNull((Object)this.strictValidator.parse(this.invalidStrict[i], null, Locale.US), (String)("(A) " + text));
            Assertions.assertFalse((boolean)this.strictValidator.isValid(this.invalidStrict[i], null, Locale.US), (String)("(B) " + text));
            Assertions.assertNull((Object)this.strictValidator.parse(this.invalidStrict[i], this.testPattern, null), (String)("(C) " + text));
            Assertions.assertFalse((boolean)this.strictValidator.isValid(this.invalidStrict[i], this.testPattern, null), (String)("(D) " + text));
        }
    }

    @Test
    void testRangeMinMax() {
        Integer number9 = 9;
        Integer number10 = 10;
        Integer number11 = 11;
        Integer number19 = 19;
        Integer number20 = 20;
        Integer number21 = 21;
        Assertions.assertFalse((boolean)this.strictValidator.isInRange((Number)number9, (Number)number10, (Number)number20), (String)"isInRange() < min");
        Assertions.assertTrue((boolean)this.strictValidator.isInRange((Number)number10, (Number)number10, (Number)number20), (String)"isInRange() = min");
        Assertions.assertTrue((boolean)this.strictValidator.isInRange((Number)number11, (Number)number10, (Number)number20), (String)"isInRange() in range");
        Assertions.assertTrue((boolean)this.strictValidator.isInRange((Number)number20, (Number)number10, (Number)number20), (String)"isInRange() = max");
        Assertions.assertFalse((boolean)this.strictValidator.isInRange((Number)number21, (Number)number10, (Number)number20), (String)"isInRange() > max");
        Assertions.assertFalse((boolean)this.strictValidator.minValue((Number)number9, (Number)number10), (String)"minValue() < min");
        Assertions.assertTrue((boolean)this.strictValidator.minValue((Number)number10, (Number)number10), (String)"minValue() = min");
        Assertions.assertTrue((boolean)this.strictValidator.minValue((Number)number11, (Number)number10), (String)"minValue() > min");
        Assertions.assertTrue((boolean)this.strictValidator.maxValue((Number)number19, (Number)number20), (String)"maxValue() < max");
        Assertions.assertTrue((boolean)this.strictValidator.maxValue((Number)number20, (Number)number20), (String)"maxValue() = max");
        Assertions.assertFalse((boolean)this.strictValidator.maxValue((Number)number21, (Number)number20), (String)"maxValue() > max");
    }

    @Test
    void testSerialization() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this.validator);
            oos.flush();
        }
        catch (Exception e) {
            Assertions.fail((String)(this.validator.getClass().getName() + " error during serialization: " + e));
        }
        Object result = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());){
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = ois.readObject();
        }
        catch (Exception e) {
            Assertions.fail((String)(this.validator.getClass().getName() + " error during deserialization: " + e));
        }
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void testValidateLocale() {
        Assertions.assertEquals((Object)this.testNumber, (Object)this.strictValidator.parse(this.testStringUS, null, Locale.US), (String)"US Locale, US Format");
        Assertions.assertNull((Object)this.strictValidator.parse(this.testStringDE, null, Locale.US), (String)"US Locale, DE Format");
        Assertions.assertEquals((Object)this.testNumber, (Object)this.strictValidator.parse(this.testStringDE, null, Locale.GERMAN), (String)"DE Locale, DE Format");
        Assertions.assertNull((Object)this.strictValidator.parse(this.testStringUS, null, Locale.GERMAN), (String)"DE Locale, US Format");
        Assertions.assertEquals((Object)this.testNumber, (Object)this.strictValidator.parse(this.testStringUS, null, null), (String)"Default Locale, US Format");
        Assertions.assertNull((Object)this.strictValidator.parse(this.testStringDE, null, null), (String)"Default Locale, DE Format");
    }

    @Test
    void testValidateMinMax() {
        DecimalFormat fmt = new DecimalFormat("#");
        if (this.max != null) {
            Assertions.assertEquals((Object)this.max, (Object)this.validator.parse(fmt.format(this.max), "#", null), (String)"Test Max");
            Assertions.assertNull((Object)this.validator.parse(fmt.format(this.maxPlusOne), "#", null), (String)"Test Max + 1");
            Assertions.assertEquals((Object)this.min, (Object)this.validator.parse(fmt.format(this.min), "#", null), (String)"Test Min");
            Assertions.assertNull((Object)this.validator.parse(fmt.format(this.minMinusOne), "#", null), (String)"Test min - 1");
        }
    }

    @Test
    void testValidNotStrict() {
        for (int i = 0; i < this.valid.length; ++i) {
            String text = "idx=[" + i + "] value=[" + this.validCompare[i] + "]";
            Assertions.assertEquals((Object)this.validCompare[i], (Object)this.validator.parse(this.valid[i], null, Locale.US), (String)("(A) " + text));
            Assertions.assertTrue((boolean)this.validator.isValid(this.valid[i], null, Locale.US), (String)("(B) " + text));
            Assertions.assertEquals((Object)this.validCompare[i], (Object)this.validator.parse(this.valid[i], this.testPattern, null), (String)("(C) " + text));
            Assertions.assertTrue((boolean)this.validator.isValid(this.valid[i], this.testPattern, null), (String)("(D) " + text));
        }
    }

    @Test
    void testValidStrict() {
        for (int i = 0; i < this.validStrict.length; ++i) {
            String text = "idx=[" + i + "] value=[" + this.validStrictCompare[i] + "]";
            Assertions.assertEquals((Object)this.validStrictCompare[i], (Object)this.strictValidator.parse(this.validStrict[i], null, Locale.US), (String)("(A) " + text));
            Assertions.assertTrue((boolean)this.strictValidator.isValid(this.validStrict[i], null, Locale.US), (String)("(B) " + text));
            Assertions.assertEquals((Object)this.validStrictCompare[i], (Object)this.strictValidator.parse(this.validStrict[i], this.testPattern, null), (String)("(C) " + text));
            Assertions.assertTrue((boolean)this.strictValidator.isValid(this.validStrict[i], this.testPattern, null), (String)("(D) " + text));
        }
    }
}

