/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.IterativeLegendreGaussIntegrator;
import org.apache.commons.math3.distribution.ConstantRealDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.random.RandomAdaptorTest;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class EmpiricalDistributionTest
extends RealDistributionAbstractTest {
    protected EmpiricalDistribution empiricalDistribution = null;
    protected EmpiricalDistribution empiricalDistribution2 = null;
    protected File file = null;
    protected URL url = null;
    protected double[] dataArray = null;
    protected final int n = 10000;
    private final double binMass = 9.99900009999E-4;
    private final double firstBinMass = 0.0010998900109989002;

    @Before
    public void setUp() {
        super.setUp();
        this.empiricalDistribution = new EmpiricalDistribution(100);
        this.url = this.getClass().getResource("testData.txt");
        ArrayList<Double> list = new ArrayList<Double>();
        try {
            this.empiricalDistribution2 = new EmpiricalDistribution(100);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.url.openStream()));
            String str = null;
            while ((str = in.readLine()) != null) {
                list.add(Double.valueOf(str));
            }
            in.close();
            in = null;
        }
        catch (IOException ex) {
            Assert.fail((String)("IOException " + ex));
        }
        this.dataArray = new double[list.size()];
        int i = 0;
        for (Double data : list) {
            this.dataArray[i] = data;
            ++i;
        }
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPrecondition1() {
        new EmpiricalDistribution(0);
    }

    @Test
    public void testLoad() throws Exception {
        this.empiricalDistribution.load(this.url);
        this.checkDistribution();
        File file = new File(this.url.toURI());
        this.empiricalDistribution.load(file);
        this.checkDistribution();
    }

    private void checkDistribution() {
        Assert.assertEquals((double)this.empiricalDistribution.getSampleStats().getN(), (double)1000.0, (double)1.0E-6);
        Assert.assertEquals((double)this.empiricalDistribution.getSampleStats().getMean(), (double)5.069831575018909, (double)1.0E-6);
        Assert.assertEquals((double)this.empiricalDistribution.getSampleStats().getStandardDeviation(), (double)1.0173699343977738, (double)1.0E-6);
    }

    @Test
    public void testDoubleLoad() throws Exception {
        this.empiricalDistribution2.load(this.dataArray);
        Assert.assertEquals((double)this.empiricalDistribution2.getSampleStats().getN(), (double)1000.0, (double)1.0E-6);
        Assert.assertEquals((double)this.empiricalDistribution2.getSampleStats().getMean(), (double)5.069831575018909, (double)1.0E-6);
        Assert.assertEquals((double)this.empiricalDistribution2.getSampleStats().getStandardDeviation(), (double)1.0173699343977738, (double)1.0E-6);
        double[] bounds = this.empiricalDistribution2.getGeneratorUpperBounds();
        Assert.assertEquals((long)bounds.length, (long)100L);
        Assert.assertEquals((double)bounds[99], (double)1.0, (double)1.0E-11);
    }

    @Test
    public void testNext() throws Exception {
        this.tstGen(0.1);
        this.tstDoubleGen(0.1);
    }

    @Test
    public void testNexFail() {
        try {
            this.empiricalDistribution.getNextValue();
            this.empiricalDistribution2.getNextValue();
            Assert.fail((String)"Expecting IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGridTooFine() throws Exception {
        this.empiricalDistribution = new EmpiricalDistribution(1001);
        this.tstGen(0.1);
        this.empiricalDistribution2 = new EmpiricalDistribution(1001);
        this.tstDoubleGen(0.1);
    }

    @Test
    public void testGridTooFat() throws Exception {
        this.empiricalDistribution = new EmpiricalDistribution(1);
        this.tstGen(5.0);
        this.empiricalDistribution2 = new EmpiricalDistribution(1);
        this.tstDoubleGen(5.0);
    }

    @Test
    public void testBinIndexOverflow() throws Exception {
        double[] x = new double[]{9474.94326071674, 2080107.8865462579};
        new EmpiricalDistribution().load(x);
    }

    @Test
    public void testSerialization() {
        EmpiricalDistribution dist = new EmpiricalDistribution();
        EmpiricalDistribution dist2 = (EmpiricalDistribution)TestUtils.serializeAndRecover(dist);
        this.verifySame(dist, dist2);
        this.empiricalDistribution2.load(this.dataArray);
        dist2 = (EmpiricalDistribution)TestUtils.serializeAndRecover(this.empiricalDistribution2);
        this.verifySame(this.empiricalDistribution2, dist2);
    }

    @Test(expected=NullArgumentException.class)
    public void testLoadNullDoubleArray() {
        new EmpiricalDistribution().load((double[])null);
    }

    @Test(expected=NullArgumentException.class)
    public void testLoadNullURL() throws Exception {
        new EmpiricalDistribution().load((URL)null);
    }

    @Test(expected=NullArgumentException.class)
    public void testLoadNullFile() throws Exception {
        new EmpiricalDistribution().load((File)null);
    }

    @Test
    public void testGetBinUpperBounds() {
        double[] testData = new double[]{0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        EmpiricalDistribution dist = new EmpiricalDistribution(5);
        dist.load(testData);
        double[] expectedBinUpperBounds = new double[]{2.0, 4.0, 6.0, 8.0, 10.0};
        double[] expectedGeneratorUpperBounds = new double[]{0.3076923076923077, 0.5384615384615384, 0.6923076923076923, 0.8461538461538461, 1.0};
        double tol = 1.0E-11;
        TestUtils.assertEquals(expectedBinUpperBounds, dist.getUpperBounds(), tol);
        TestUtils.assertEquals(expectedGeneratorUpperBounds, dist.getGeneratorUpperBounds(), tol);
    }

    @Test
    public void testGeneratorConfig() {
        double[] testData = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        RandomAdaptorTest.ConstantGenerator generator = new RandomAdaptorTest.ConstantGenerator(0.5);
        EmpiricalDistribution dist = new EmpiricalDistribution(5, (RandomGenerator)generator);
        dist.load(testData);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((double)2.0, (double)dist.getNextValue(), (double)0.0);
        }
        dist = new EmpiricalDistribution(5, (RandomGenerator)null);
        dist.load(testData);
        dist.getNextValue();
    }

    @Test
    public void testReSeed() throws Exception {
        int i;
        this.empiricalDistribution.load(this.url);
        this.empiricalDistribution.reSeed(100L);
        double[] values = new double[10];
        for (i = 0; i < 10; ++i) {
            values[i] = this.empiricalDistribution.getNextValue();
        }
        this.empiricalDistribution.reSeed(100L);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)values[i], (double)this.empiricalDistribution.getNextValue(), (double)0.0);
        }
    }

    private void verifySame(EmpiricalDistribution d1, EmpiricalDistribution d2) {
        Assert.assertEquals((Object)d1.isLoaded(), (Object)d2.isLoaded());
        Assert.assertEquals((long)d1.getBinCount(), (long)d2.getBinCount());
        Assert.assertEquals((Object)d1.getSampleStats(), (Object)d2.getSampleStats());
        if (d1.isLoaded()) {
            for (int i = 0; i < d1.getUpperBounds().length; ++i) {
                Assert.assertEquals((double)d1.getUpperBounds()[i], (double)d2.getUpperBounds()[i], (double)0.0);
            }
            Assert.assertEquals((Object)d1.getBinStats(), (Object)d2.getBinStats());
        }
    }

    private void tstGen(double tolerance) throws Exception {
        this.empiricalDistribution.load(this.url);
        this.empiricalDistribution.reSeed(1000L);
        SummaryStatistics stats = new SummaryStatistics();
        for (int i = 1; i < 1000; ++i) {
            stats.addValue(this.empiricalDistribution.getNextValue());
        }
        Assert.assertEquals((String)"mean", (double)5.069831575018909, (double)stats.getMean(), (double)tolerance);
        Assert.assertEquals((String)"std dev", (double)1.0173699343977738, (double)stats.getStandardDeviation(), (double)tolerance);
    }

    private void tstDoubleGen(double tolerance) throws Exception {
        this.empiricalDistribution2.load(this.dataArray);
        this.empiricalDistribution2.reSeed(1000L);
        SummaryStatistics stats = new SummaryStatistics();
        for (int i = 1; i < 1000; ++i) {
            stats.addValue(this.empiricalDistribution2.getNextValue());
        }
        Assert.assertEquals((String)"mean", (double)5.069831575018909, (double)stats.getMean(), (double)tolerance);
        Assert.assertEquals((String)"std dev", (double)1.0173699343977738, (double)stats.getStandardDeviation(), (double)tolerance);
    }

    public RealDistribution makeDistribution() {
        double[] sourceData = new double[10001];
        for (int i = 0; i < 10001; ++i) {
            sourceData[i] = i;
        }
        EmpiricalDistribution dist = new EmpiricalDistribution();
        dist.load(sourceData);
        return dist;
    }

    public double[] makeCumulativeTestPoints() {
        double[] testPoints = new double[]{9.0, 10.0, 15.0, 1000.0, 5004.0, 9999.0};
        return testPoints;
    }

    public double[] makeCumulativeTestValues() {
        double[] testPoints = this.getCumulativeTestPoints();
        double[] cumValues = new double[testPoints.length];
        EmpiricalDistribution empiricalDistribution = (EmpiricalDistribution)this.makeDistribution();
        double[] binBounds = empiricalDistribution.getUpperBounds();
        for (int i = 0; i < testPoints.length; ++i) {
            int bin = this.findBin(testPoints[i]);
            double lower = bin == 0 ? empiricalDistribution.getSupportLowerBound() : binBounds[bin - 1];
            double upper = binBounds[bin];
            double bMinus = bin == 0 ? 0.0 : (double)(bin - 1) * 9.99900009999E-4 + 0.0010998900109989002;
            RealDistribution kernel = this.findKernel(lower, upper);
            double withinBinKernelMass = kernel.cumulativeProbability(lower, upper);
            double kernelCum = kernel.cumulativeProbability(lower, testPoints[i]);
            cumValues[i] = bMinus + (bin == 0 ? 0.0010998900109989002 : 9.99900009999E-4) * kernelCum / withinBinKernelMass;
        }
        return cumValues;
    }

    public double[] makeDensityTestValues() {
        double[] testPoints = this.getCumulativeTestPoints();
        double[] densityValues = new double[testPoints.length];
        EmpiricalDistribution empiricalDistribution = (EmpiricalDistribution)this.makeDistribution();
        double[] binBounds = empiricalDistribution.getUpperBounds();
        for (int i = 0; i < testPoints.length; ++i) {
            int bin = this.findBin(testPoints[i]);
            double lower = bin == 0 ? empiricalDistribution.getSupportLowerBound() : binBounds[bin - 1];
            double upper = binBounds[bin];
            RealDistribution kernel = this.findKernel(lower, upper);
            double withinBinKernelMass = kernel.cumulativeProbability(lower, upper);
            double density = kernel.density(testPoints[i]);
            densityValues[i] = density * (bin == 0 ? 0.0010998900109989002 : 9.99900009999E-4) / withinBinKernelMass;
        }
        return densityValues;
    }

    @Test
    public void testDensityIntegrals() {
        final RealDistribution distribution = this.makeDistribution();
        double tol = 1.0E-9;
        IterativeLegendreGaussIntegrator integrator = new IterativeLegendreGaussIntegrator(5, 1.0E-12, 1.0E-10);
        UnivariateFunction d = new UnivariateFunction(){

            public double value(double x) {
                return distribution.density(x);
            }
        };
        double[] lower = new double[]{0.0, 5.0, 1000.0, 5001.0, 9995.0};
        double[] upper = new double[]{5.0, 12.0, 1030.0, 5010.0, 10000.0};
        for (int i = 1; i < 5; ++i) {
            Assert.assertEquals((double)distribution.cumulativeProbability(lower[i], upper[i]), (double)integrator.integrate(1000000, d, lower[i], upper[i]), (double)1.0E-9);
        }
    }

    @Test
    public void testSampleValuesRange() {
        int i;
        double[] data = new double[100];
        for (i = 0; i < 50; ++i) {
            data[i] = 1.0 / ((double)i + 1.0);
        }
        for (i = 51; i < 100; ++i) {
            data[i] = 1.0 - 1.0 / (100.0 - (double)i + 2.0);
        }
        EmpiricalDistribution dist = new EmpiricalDistribution(10);
        dist.load(data);
        dist.reseedRandomGenerator(1000L);
        for (int i2 = 0; i2 < 1000; ++i2) {
            double dev = dist.sample();
            Assert.assertTrue((dev < 1.0 ? 1 : 0) != 0);
            Assert.assertTrue((dev > 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNoBinVariance() {
        double[] data = new double[]{0.0, 0.0, 1.0, 1.0};
        EmpiricalDistribution dist = new EmpiricalDistribution(2);
        dist.load(data);
        dist.reseedRandomGenerator(1000L);
        for (int i = 0; i < 1000; ++i) {
            double dev = dist.sample();
            Assert.assertTrue((dev == 0.0 || dev == 1.0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((double)0.5, (double)dist.cumulativeProbability(0.0), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)dist.cumulativeProbability(1.0), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)0.5, (double)dist.cumulativeProbability(0.5), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)0.5, (double)dist.cumulativeProbability(0.7), (double)Double.MIN_VALUE);
    }

    private int findBin(double x) {
        double nMinus = FastMath.floor((double)(x / 10.0));
        int bin = (int)FastMath.round((double)nMinus);
        return FastMath.floor((double)(x / 10.0)) == x / 10.0 ? bin - 1 : bin;
    }

    private RealDistribution findKernel(double lower, double upper) {
        if (lower < 1.0) {
            return new NormalDistribution(5.0, 3.3166247903554);
        }
        return new NormalDistribution((upper + lower + 1.0) / 2.0, 3.0276503540974917);
    }

    @Test
    public void testKernelOverrideConstant() {
        ConstantKernelEmpiricalDistribution dist = new ConstantKernelEmpiricalDistribution(5);
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
        dist.load(data);
        double[] values = new double[]{2.0, 5.0, 8.0, 11.0, 14.0};
        for (int i = 0; i < 20; ++i) {
            Assert.assertTrue((Arrays.binarySearch(values, dist.sample()) >= 0 ? 1 : 0) != 0);
        }
        double tol = 1.0E-11;
        Assert.assertEquals((double)0.0, (double)dist.cumulativeProbability(1.0), (double)1.0E-11);
        Assert.assertEquals((double)0.2, (double)dist.cumulativeProbability(2.0), (double)1.0E-11);
        Assert.assertEquals((double)0.6, (double)dist.cumulativeProbability(10.0), (double)1.0E-11);
        Assert.assertEquals((double)0.8, (double)dist.cumulativeProbability(12.0), (double)1.0E-11);
        Assert.assertEquals((double)0.8, (double)dist.cumulativeProbability(13.0), (double)1.0E-11);
        Assert.assertEquals((double)1.0, (double)dist.cumulativeProbability(15.0), (double)1.0E-11);
        Assert.assertEquals((double)2.0, (double)dist.inverseCumulativeProbability(0.1), (double)1.0E-11);
        Assert.assertEquals((double)2.0, (double)dist.inverseCumulativeProbability(0.2), (double)1.0E-11);
        Assert.assertEquals((double)5.0, (double)dist.inverseCumulativeProbability(0.3), (double)1.0E-11);
        Assert.assertEquals((double)5.0, (double)dist.inverseCumulativeProbability(0.4), (double)1.0E-11);
        Assert.assertEquals((double)8.0, (double)dist.inverseCumulativeProbability(0.5), (double)1.0E-11);
        Assert.assertEquals((double)8.0, (double)dist.inverseCumulativeProbability(0.6), (double)1.0E-11);
    }

    @Test
    public void testKernelOverrideUniform() {
        UniformKernelEmpiricalDistribution dist = new UniformKernelEmpiricalDistribution(5);
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
        dist.load(data);
        double[] bounds = new double[]{3.0, 6.0, 9.0, 12.0};
        double tol = 1.0E-11;
        for (int i = 0; i < 20; ++i) {
            double v = dist.sample();
            for (int j = 0; j < bounds.length; ++j) {
                Assert.assertFalse((v > bounds[j] + 1.0E-11 && v < bounds[j] + 1.0 - 1.0E-11 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((double)0.0, (double)dist.cumulativeProbability(1.0), (double)1.0E-11);
        Assert.assertEquals((double)0.1, (double)dist.cumulativeProbability(2.0), (double)1.0E-11);
        Assert.assertEquals((double)0.6, (double)dist.cumulativeProbability(10.0), (double)1.0E-11);
        Assert.assertEquals((double)0.8, (double)dist.cumulativeProbability(12.0), (double)1.0E-11);
        Assert.assertEquals((double)0.8, (double)dist.cumulativeProbability(13.0), (double)1.0E-11);
        Assert.assertEquals((double)1.0, (double)dist.cumulativeProbability(15.0), (double)1.0E-11);
        Assert.assertEquals((double)2.0, (double)dist.inverseCumulativeProbability(0.1), (double)1.0E-11);
        Assert.assertEquals((double)3.0, (double)dist.inverseCumulativeProbability(0.2), (double)1.0E-11);
        Assert.assertEquals((double)5.0, (double)dist.inverseCumulativeProbability(0.3), (double)1.0E-11);
        Assert.assertEquals((double)6.0, (double)dist.inverseCumulativeProbability(0.4), (double)1.0E-11);
        Assert.assertEquals((double)8.0, (double)dist.inverseCumulativeProbability(0.5), (double)1.0E-11);
        Assert.assertEquals((double)9.0, (double)dist.inverseCumulativeProbability(0.6), (double)1.0E-11);
    }

    private class UniformKernelEmpiricalDistribution
    extends EmpiricalDistribution {
        private static final long serialVersionUID = 2963149194515159653L;

        public UniformKernelEmpiricalDistribution(int i) {
            super(i);
        }

        protected RealDistribution getKernel(SummaryStatistics bStats) {
            return new UniformRealDistribution(this.randomData.getRandomGenerator(), bStats.getMin(), bStats.getMax());
        }
    }

    private class ConstantKernelEmpiricalDistribution
    extends EmpiricalDistribution {
        private static final long serialVersionUID = 1L;

        public ConstantKernelEmpiricalDistribution(int i) {
            super(i);
        }

        protected RealDistribution getKernel(SummaryStatistics bStats) {
            return new ConstantRealDistribution(bStats.getMean());
        }
    }
}

