/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.function.Logistic;
import org.apache.commons.math3.analysis.function.Sigmoid;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class LogisticTest {
    private final double EPS = Math.ulp(1.0);

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions1() {
        new Logistic(1.0, 0.0, 1.0, 1.0, 0.0, -1.0);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions2() {
        new Logistic(1.0, 0.0, 1.0, 1.0, 0.0, 0.0);
    }

    @Test
    public void testCompareSigmoid() {
        Sigmoid sig = new Sigmoid();
        Logistic sigL = new Logistic(1.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        double min = -2.0;
        double max = 2.0;
        int n = 100;
        double delta = 0.04;
        for (int i = 0; i < 100; ++i) {
            double x = -2.0 + (double)i * 0.04;
            Assert.assertEquals((String)("x=" + x), (double)sig.value(x), (double)sigL.value(x), (double)this.EPS);
        }
    }

    @Test
    public void testSomeValues() {
        double k = 4.0;
        double m = 5.0;
        double b = 2.0;
        double q = 3.0;
        double a = -1.0;
        double n = 2.0;
        Logistic f = new Logistic(4.0, 5.0, 2.0, 3.0, -1.0, 2.0);
        double x = 5.0;
        Assert.assertEquals((String)("x=" + x), (double)(-1.0 + 5.0 / FastMath.sqrt((double)4.0)), (double)f.value(x), (double)this.EPS);
        x = Double.NEGATIVE_INFINITY;
        Assert.assertEquals((String)("x=" + x), (double)-1.0, (double)f.value(x), (double)this.EPS);
        x = Double.POSITIVE_INFINITY;
        Assert.assertEquals((String)("x=" + x), (double)4.0, (double)f.value(x), (double)this.EPS);
    }

    @Test
    public void testCompareDerivativeSigmoid() {
        double k = 3.0;
        double a = 2.0;
        Logistic f = new Logistic(3.0, 0.0, 1.0, 1.0, 2.0, 1.0);
        Sigmoid g = new Sigmoid(2.0, 3.0);
        double min = -10.0;
        double max = 10.0;
        double n = 20.0;
        double delta = 1.0;
        int i = 0;
        while ((double)i < 20.0) {
            DerivativeStructure x = new DerivativeStructure(1, 5, 0, -10.0 + (double)i * 1.0);
            int order = 0;
            while (order <= x.getOrder()) {
                Assert.assertEquals((String)("x=" + x.getValue()), (double)g.value(x).getPartialDerivative(new int[]{order}), (double)f.value(x).getPartialDerivative(new int[]{order++}), (double)3.0E-15);
            }
            ++i;
        }
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage1() {
        Logistic.Parametric g = new Logistic.Parametric();
        g.value(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage2() {
        Logistic.Parametric g = new Logistic.Parametric();
        g.value(0.0, new double[]{0.0});
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage3() {
        Logistic.Parametric g = new Logistic.Parametric();
        g.gradient(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage4() {
        Logistic.Parametric g = new Logistic.Parametric();
        g.gradient(0.0, new double[]{0.0});
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testParametricUsage5() {
        Logistic.Parametric g = new Logistic.Parametric();
        g.value(0.0, new double[]{1.0, 0.0, 1.0, 1.0, 0.0, 0.0});
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testParametricUsage6() {
        Logistic.Parametric g = new Logistic.Parametric();
        g.gradient(0.0, new double[]{1.0, 0.0, 1.0, 1.0, 0.0, 0.0});
    }

    @Test
    public void testGradientComponent0Component4() {
        double k = 3.0;
        double a = 2.0;
        Logistic.Parametric f = new Logistic.Parametric();
        Sigmoid.Parametric g = new Sigmoid.Parametric();
        double x = 0.12345;
        double[] gf = f.gradient(0.12345, new double[]{3.0, 0.0, 1.0, 1.0, 2.0, 1.0});
        double[] gg = g.gradient(0.12345, new double[]{2.0, 3.0});
        Assert.assertEquals((double)gg[0], (double)gf[4], (double)this.EPS);
        Assert.assertEquals((double)gg[1], (double)gf[0], (double)this.EPS);
    }

    @Test
    public void testGradientComponent5() {
        double m = 1.2;
        double k = 3.4;
        double a = 2.3;
        double q = 0.567;
        double b = -FastMath.log((double)0.567);
        double n = 3.4;
        Logistic.Parametric f = new Logistic.Parametric();
        double x = 0.19999999999999996;
        double qExp1 = 2.0;
        double[] gf = f.gradient(0.19999999999999996, new double[]{3.4, 1.2, b, 0.567, 2.3, 3.4});
        Assert.assertEquals((double)(1.1 * FastMath.log((double)2.0) / (11.559999999999999 * FastMath.pow((double)2.0, (double)0.29411764705882354))), (double)gf[5], (double)this.EPS);
    }

    @Test
    public void testGradientComponent1Component2Component3() {
        double m = 1.2;
        double k = 3.4;
        double a = 2.3;
        double b = 0.567;
        double q = 1.0 / FastMath.exp((double)0.6803999999999999);
        double n = 3.4;
        Logistic.Parametric f = new Logistic.Parametric();
        double x = 0.0;
        double qExp1 = 2.0;
        double[] gf = f.gradient(0.0, new double[]{3.4, 1.2, 0.567, q, 2.3, 3.4});
        double factor = -1.1 / (3.4 * FastMath.pow((double)2.0, (double)1.2941176470588236));
        Assert.assertEquals((double)(factor * 0.567), (double)gf[1], (double)this.EPS);
        Assert.assertEquals((double)(factor * 1.2), (double)gf[2], (double)this.EPS);
        Assert.assertEquals((double)(factor / q), (double)gf[3], (double)this.EPS);
    }
}

