/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.jdk14;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.Test;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.DummyException;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.jdk14.CustomConfigAPITestCase;
import org.apache.commons.logging.jdk14.DefaultConfigTestCase;
import org.apache.commons.logging.jdk14.TestHandler;

public class CustomConfigTestCase
extends DefaultConfigTestCase {
    protected static final String HANDLER_NAME = "org.apache.commons.logging.jdk14.TestHandler";
    protected TestHandler handler;
    protected Handler[] handlers;
    protected Logger logger;
    protected LogManager manager;
    protected Level[] testLevels = new Level[]{Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.SEVERE};
    protected String[] testMessages = new String[]{"debug", "info", "warn", "error", "fatal"};

    protected static void loadTestHandler(String className, ClassLoader targetCL) {
        try {
            targetCL.loadClass(className);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader srcCL = CustomConfigAPITestCase.class.getClassLoader();
                byte[] classData = CustomConfigTestCase.readClass(className, srcCL);
                Class[] params = new Class[]{String.class, classData.getClass(), Integer.TYPE, Integer.TYPE};
                Method m = ClassLoader.class.getDeclaredMethod("defineClass", params);
                Object[] args = new Object[]{className, classData, 0, classData.length};
                m.setAccessible(true);
                m.invoke((Object)targetCL, args);
            }
            catch (Exception e) {
                e.printStackTrace();
                CustomConfigTestCase.fail((String)("Unable to load class " + className));
            }
            return;
        }
    }

    protected static byte[] readClass(String name, ClassLoader srcCL) throws Exception {
        String resName = name.replace('.', '/') + ".class";
        System.err.println("Trying to load resource [" + resName + "]");
        try (InputStream is = srcCL.getResourceAsStream(resName);){
            System.err.println("Reading resource [" + resName + "]");
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    public static Test suite() throws Exception {
        PathableClassLoader cl = new PathableClassLoader(null);
        cl.useExplicitLoader("junit.", Test.class.getClassLoader());
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        CustomConfigTestCase.loadTestHandler(HANDLER_NAME, scl);
        cl.useExplicitLoader(HANDLER_NAME, scl);
        cl.addLogicalLib("commons-logging");
        cl.addLogicalLib("testclasses");
        Class<?> testClass = cl.loadClass(CustomConfigTestCase.class.getName());
        return new PathableTestSuite(testClass, cl);
    }

    public CustomConfigTestCase(String name) {
        super(name);
    }

    @Override
    protected void checkLog() {
        CustomConfigTestCase.assertNotNull((String)"Log exists", (Object)this.log);
        CustomConfigTestCase.assertEquals((String)"Log class", (String)"org.apache.commons.logging.impl.Jdk14Logger", (String)this.log.getClass().getName());
        CustomConfigTestCase.assertTrue((boolean)this.log.isFatalEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isErrorEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isWarnEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isInfoEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isDebugEnabled());
        CustomConfigTestCase.assertFalse((boolean)this.log.isTraceEnabled());
    }

    protected void checkLogRecords(boolean thrown) {
        Iterator<LogRecord> records = this.handler.records();
        for (int i = 0; i < this.testMessages.length; ++i) {
            CustomConfigTestCase.assertTrue((boolean)records.hasNext());
            LogRecord record = records.next();
            CustomConfigTestCase.assertEquals((String)"LogRecord level", (Object)this.testLevels[i], (Object)record.getLevel());
            CustomConfigTestCase.assertEquals((String)"LogRecord message", (String)this.testMessages[i], (String)record.getMessage());
            CustomConfigTestCase.assertTrue((String)"LogRecord class", (boolean)record.getSourceClassName().startsWith("org.apache.commons.logging.jdk14.CustomConfig"));
            if (thrown) {
                CustomConfigTestCase.assertEquals((String)"LogRecord method", (String)"logExceptionMessages", (String)record.getSourceMethodName());
            } else {
                CustomConfigTestCase.assertEquals((String)"LogRecord method", (String)"logPlainMessages", (String)record.getSourceMethodName());
            }
            if (thrown) {
                CustomConfigTestCase.assertNotNull((String)"LogRecord thrown", (Object)record.getThrown());
                CustomConfigTestCase.assertTrue((String)"LogRecord thrown type", (boolean)(record.getThrown() instanceof DummyException));
                continue;
            }
            CustomConfigTestCase.assertNull((String)"LogRecord thrown", (Object)record.getThrown());
        }
        CustomConfigTestCase.assertFalse((boolean)records.hasNext());
        this.handler.flush();
    }

    protected void logExceptionMessages() {
        DummyException t = new DummyException();
        this.log.trace((Object)"trace", (Throwable)t);
        this.log.debug((Object)"debug", (Throwable)t);
        this.log.info((Object)"info", (Throwable)t);
        this.log.warn((Object)"warn", (Throwable)t);
        this.log.error((Object)"error", (Throwable)t);
        this.log.fatal((Object)"fatal", (Throwable)t);
    }

    protected void logPlainMessages() {
        this.log.trace((Object)"trace");
        this.log.debug((Object)"debug");
        this.log.info((Object)"info");
        this.log.warn((Object)"warn");
        this.log.error((Object)"error");
        this.log.fatal((Object)"fatal");
    }

    @Override
    public void setUp() throws Exception {
        this.setUpManager("org/apache/commons/logging/jdk14/CustomConfig.properties");
        this.setUpLogger(((Object)((Object)this)).getClass().getName());
        this.setUpHandlers();
        this.setUpFactory();
        this.setUpLog(((Object)((Object)this)).getClass().getName());
    }

    protected void setUpHandlers() throws Exception {
        Logger parent = this.logger;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        this.handlers = parent.getHandlers();
        CustomConfigTestCase.assertNotNull((String)"No Handlers defined for JDK14 logging", (Object)this.handlers);
        CustomConfigTestCase.assertEquals((String)"Unexpected number of handlers for JDK14 logging", (int)1, (int)this.handlers.length);
        CustomConfigTestCase.assertNotNull((String)"Handler is null", (Object)this.handlers[0]);
        CustomConfigTestCase.assertTrue((String)"Handler not of expected type", (boolean)(this.handlers[0] instanceof TestHandler));
        this.handler = (TestHandler)this.handlers[0];
    }

    protected void setUpLogger(String name) throws Exception {
        this.logger = Logger.getLogger(name);
    }

    protected void setUpManager(String config) throws Exception {
        this.manager = LogManager.getLogManager();
        try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(config);){
            this.manager.readConfiguration(is);
        }
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.handlers = null;
        this.logger = null;
        this.manager = null;
    }

    public void testExceptionMessages() throws Exception {
        this.logExceptionMessages();
        this.checkLogRecords(true);
    }

    public void testPlainMessages() throws Exception {
        this.logPlainMessages();
        this.checkLogRecords(false);
    }

    public void testPristineHandlers() {
        CustomConfigTestCase.assertNotNull((Object)this.handlers);
        CustomConfigTestCase.assertEquals((int)1, (int)this.handlers.length);
        CustomConfigTestCase.assertTrue((boolean)(this.handlers[0] instanceof TestHandler));
        CustomConfigTestCase.assertNotNull((Object)this.handler);
    }

    public void testPristineLogger() {
        CustomConfigTestCase.assertNotNull((String)"Logger exists", (Object)this.logger);
        CustomConfigTestCase.assertEquals((String)"Logger name", (String)((Object)((Object)this)).getClass().getName(), (String)this.logger.getName());
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.SEVERE));
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.WARNING));
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.INFO));
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.CONFIG));
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.FINE));
        CustomConfigTestCase.assertFalse((boolean)this.logger.isLoggable(Level.FINER));
        CustomConfigTestCase.assertFalse((boolean)this.logger.isLoggable(Level.FINEST));
    }

    @Override
    public void testSerializable() throws Exception {
        super.testSerializable();
        this.testExceptionMessages();
    }
}

