/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jexl3.JexlArithmetic;

public class SynchronizedArithmetic
extends JexlArithmetic {
    private final Monitor monitor;

    protected SynchronizedArithmetic(Monitor monitor, boolean strict) {
        super(strict);
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object arrayGet(Map<?, ?> map, Object key) {
        this.monitor.monitorEnter(map);
        try {
            Object obj = map.get(key);
            return obj;
        }
        finally {
            this.monitor.monitorExit(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arraySet(Map<Object, Object> map, Object key, Object value) {
        this.monitor.monitorEnter(map);
        try {
            map.put(key, value);
        }
        finally {
            this.monitor.monitorExit(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object propertyGet(Map<?, ?> map, Object key) {
        this.monitor.monitorEnter(map);
        try {
            Object obj = map.get(key);
            return obj;
        }
        finally {
            this.monitor.monitorExit(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertySet(Map<Object, Object> map, Object key, Object value) {
        this.monitor.monitorEnter(map);
        try {
            map.put(key, value);
        }
        finally {
            this.monitor.monitorExit(map);
        }
    }

    public Iterator<Object> forEach(Map<Object, Object> map) {
        return new SynchronizedIterator(map, map.values().iterator());
    }

    public class SynchronizedIterator
    implements Iterator<Object> {
        private final Object monitored;
        private Iterator<Object> iterator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SynchronizedIterator(Object locked, Iterator<Object> ii) {
            this.monitored = locked;
            SynchronizedArithmetic.this.monitor.monitorEnter(this.monitored);
            try {
                this.iterator = ii;
            }
            finally {
                if (this.iterator == null) {
                    SynchronizedArithmetic.this.monitor.monitorExit(this.monitored);
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        public void close() {
            if (this.iterator != null) {
                SynchronizedArithmetic.this.monitor.monitorExit(this.monitored);
                this.iterator = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            boolean n = this.iterator.hasNext();
            if (!n) {
                this.close();
            }
            return n;
        }

        @Override
        public Object next() {
            if (this.iterator == null) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            if (this.iterator != null) {
                this.iterator.remove();
            }
        }
    }

    static class SafeMonitor
    extends Monitor {
        private final Map<Object, Object> monitored = new IdentityHashMap<Object, Object>();

        SafeMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void monitorEnter(Object o) {
            try {
                while (true) {
                    Object guard;
                    Object object = this.monitored;
                    synchronized (object) {
                        guard = this.monitored.get(o);
                        if (guard == null) {
                            guard = new Object();
                            this.monitored.put(o, guard);
                            super.monitorEnter(o);
                            return;
                        }
                    }
                    object = guard;
                    synchronized (object) {
                        guard.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void monitorExit(Object o) {
            Object guard;
            Object object = this.monitored;
            synchronized (object) {
                guard = this.monitored.remove(o);
            }
            if (guard != null) {
                object = guard;
                synchronized (object) {
                    guard.notifyAll();
                }
                super.monitorExit(o);
            }
        }
    }

    public static abstract class Monitor {
        private final AtomicInteger enters = new AtomicInteger(0);
        private final AtomicInteger exits = new AtomicInteger(0);

        protected void monitorEnter(Object o) {
            this.enters.incrementAndGet();
        }

        protected void monitorExit(Object o) {
            this.exits.incrementAndGet();
        }

        public boolean isBalanced() {
            return this.enters.get() == this.exits.get();
        }

        public int getCount() {
            return this.enters.get();
        }
    }
}

