/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.examples.tiff;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.AbstractPhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PhotometricInterpreterFloat;
import org.apache.commons.lang3.StringUtils;

public class ReadAndRenderFloatingPoint {
    private static final String[] USAGE = new String[]{"Usage ReadAndRendserFloatingPoint <input file>  [output file]", "   input file:  Mandatory file to be read", "   output file: Optional output path for file to be written.", "                This name should not include a file extension.", "                Output data will be written using the JPEG format."};

    public static void main(String[] args) throws ImagingException, IOException {
        if (args.length == 0) {
            for (String s : USAGE) {
                System.err.println(s);
            }
            System.exit(0);
        }
        File target = new File(args[0]);
        String outputPath = null;
        if (args.length == 2) {
            outputPath = args[1];
        }
        boolean optionalImageWritingEnabled = StringUtils.isNotEmpty(outputPath);
        ByteSource byteSource = ByteSource.file((File)target);
        TiffReader tiffReader = new TiffReader(true);
        TiffContents contents = tiffReader.readDirectories(byteSource, true, FormatCompliance.getDefault());
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        if (!directory.hasTiffImageData()) {
            System.err.println("First directory in file does not have image");
            System.exit(-1);
        }
        short[] sampleFormat = directory.getFieldValue(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, true);
        int samplesPerPixel = directory.getFieldValue(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL);
        short[] bitsPerPixel = directory.getFieldValue(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE, true);
        if (sampleFormat[0] != 3) {
            System.err.println("This example requires a data source with a floating-point format");
            System.exit(-1);
        }
        System.out.print("Bits per pixel: ");
        for (int i = 0; i < samplesPerPixel; ++i) {
            System.out.format("%s%d", i > 0 ? ", " : "", bitsPerPixel[i]);
        }
        System.out.println("");
        PhotometricInterpreterFloat pi = new PhotometricInterpreterFloat(0.0f, 1.0f);
        TiffImagingParameters params = new TiffImagingParameters();
        params.setCustomPhotometricInterpreter((AbstractPhotometricInterpreter)pi);
        BufferedImage bImage = directory.getTiffImage(params);
        float maxValue = pi.getMaxFound();
        float minValue = pi.getMinFound();
        if (optionalImageWritingEnabled) {
            File output = new File(outputPath);
            PhotometricInterpreterFloat grayScale = new PhotometricInterpreterFloat(minValue, maxValue);
            params = new TiffImagingParameters();
            params.setCustomPhotometricInterpreter((AbstractPhotometricInterpreter)grayScale);
            bImage = directory.getTiffImage(params);
            ImageIO.write((RenderedImage)bImage, "JPEG", output);
        }
    }
}

