/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.apache.commons.dbcp2.AbandonedTrace;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolingConnection;
import org.apache.commons.dbcp2.SQLExceptionList;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterResultSet;
import org.apache.commons.dbcp2.TesterStatement;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDelegatingConnection {
    private DelegatingConnection<? extends Connection> delegatingConnection;
    private Connection connection;
    private Connection connection2;
    private DelegatingConnection<? extends Connection> h2DConnection;
    private TesterStatement testerStatement;
    private TesterResultSet testerResultSet;

    @AfterEach
    public void afterEach() throws SQLException {
        this.h2DConnection.close();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.connection = new TesterConnection("test", "test");
        this.connection2 = new TesterConnection("test", "test");
        this.delegatingConnection = new DelegatingConnection(this.connection);
        this.testerStatement = new TesterStatement((Connection)this.delegatingConnection);
        this.testerResultSet = new TesterResultSet(this.testerStatement);
        this.h2DConnection = new DelegatingConnection(DriverManager.getConnection("jdbc:h2:mem:test"));
    }

    @Test
    public void testAbort() throws Exception {
        this.h2DConnection.abort(r -> {});
    }

    @Test
    public void testAutoCommitCaching() throws SQLException {
        NoReadOnlyOrAutoCommitConnection con = new NoReadOnlyOrAutoCommitConnection();
        DelegatingConnection delCon = new DelegatingConnection((Connection)con);
        delCon.setAutoCommit(true);
        Assertions.assertFalse((boolean)con.getAutoCommit());
        Assertions.assertFalse((boolean)delCon.getAutoCommit());
    }

    @Test
    public void testCheckOpen() throws Exception {
        this.delegatingConnection.checkOpen();
        this.delegatingConnection.close();
        try {
            this.delegatingConnection.checkOpen();
            Assertions.fail((String)"Expecting SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckOpenNull() throws Exception {
        try {
            this.delegatingConnection.close();
            this.delegatingConnection.checkOpen();
            Assertions.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().endsWith("is closed."));
        }
        try {
            this.delegatingConnection = new DelegatingConnection(null);
            this.delegatingConnection.setClosedInternal(true);
            this.delegatingConnection.checkOpen();
            Assertions.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().endsWith("is null."));
        }
        try {
            PoolingConnection pc = new PoolingConnection(this.connection2);
            pc.setStatementPool((KeyedObjectPool)new GenericKeyedObjectPool((KeyedPooledObjectFactory)pc));
            this.delegatingConnection = new DelegatingConnection((Connection)pc);
            pc.close();
            this.delegatingConnection.close();
            PreparedStatement ps = this.delegatingConnection.prepareStatement("");
            if (ps != null) {
                ps.close();
            }
            Assertions.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().endsWith("is closed."));
        }
        try {
            this.delegatingConnection = new DelegatingConnection((Connection)new RTEGeneratingConnection());
            this.delegatingConnection.close();
            this.delegatingConnection.checkOpen();
            Assertions.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().endsWith("is closed."));
        }
    }

    @Test
    public void testCommit() throws Exception {
        this.h2DConnection.commit();
    }

    @Test
    public void testConnectionToString() throws Exception {
        String s = this.delegatingConnection.toString();
        Assertions.assertNotNull((Object)s);
        Assertions.assertFalse((boolean)s.isEmpty());
    }

    @Test
    public void testCreateArrayOf() throws Exception {
        Assertions.assertNotNull((Object)this.h2DConnection.createArrayOf("CHARACTER", new Object[]{"A", "B"}));
    }

    @Test
    public void testCreateBlob() throws Exception {
        Assertions.assertNotNull((Object)this.h2DConnection.createBlob());
    }

    @Test
    public void testCreateClob() throws Exception {
        Assertions.assertNotNull((Object)this.h2DConnection.createClob());
    }

    @Test
    public void testCreateNClob() throws Exception {
        Assertions.assertNotNull((Object)this.h2DConnection.createNClob());
    }

    @Test
    public void testCreateSQLXML() throws Exception {
        Assertions.assertNotNull((Object)this.h2DConnection.createSQLXML());
    }

    @Test
    public void testCreateStruct() throws Exception {
        Assertions.assertThrows(SQLException.class, () -> this.h2DConnection.createStruct("CHARACTER", new Object[]{"A", "B"}));
    }

    @Test
    public void testGetCacheState() throws Exception {
        Assertions.assertTrue((boolean)this.h2DConnection.getCacheState());
    }

    @Test
    public void testGetClientInfo() throws Exception {
        Assertions.assertNotNull((Object)this.h2DConnection.getClientInfo());
    }

    @Test
    public void testGetClientInfoString() throws Exception {
        Assertions.assertNull((Object)this.h2DConnection.getClientInfo("xyz"));
    }

    @Test
    public void testGetDefaultQueryTimeout() throws Exception {
        Assertions.assertNull((Object)this.h2DConnection.getDefaultQueryTimeout());
    }

    @Test
    public void testGetDefaultQueryTimeoutDuration() throws Exception {
        Assertions.assertNull((Object)this.h2DConnection.getDefaultQueryTimeoutDuration());
    }

    @Test
    public void testGetDelegate() throws Exception {
        Assertions.assertEquals((Object)this.connection, (Object)this.delegatingConnection.getDelegate());
    }

    @Test
    public void testGetHoldability() throws Exception {
        Assertions.assertEquals((int)1, (int)this.h2DConnection.getHoldability());
    }

    @Test
    public void testGetNetworkTimeout() throws Exception {
        Assertions.assertEquals((int)0, (int)this.h2DConnection.getNetworkTimeout());
    }

    @Test
    public void testGetTypeMap() throws Exception {
        Assertions.assertNull((Object)this.h2DConnection.getTypeMap());
    }

    @Test
    public void testIsClosed() throws Exception {
        this.delegatingConnection.checkOpen();
        Assertions.assertFalse((boolean)this.delegatingConnection.isClosed());
        this.delegatingConnection.close();
        Assertions.assertTrue((boolean)this.delegatingConnection.isClosed());
    }

    @Test
    public void testIsClosedNullDelegate() throws Exception {
        this.delegatingConnection.checkOpen();
        Assertions.assertFalse((boolean)this.delegatingConnection.isClosed());
        this.delegatingConnection.setDelegate(null);
        Assertions.assertTrue((boolean)this.delegatingConnection.isClosed());
    }

    @Test
    public void testIsWrapperFor() throws Exception {
        Assertions.assertTrue((boolean)this.delegatingConnection.isWrapperFor(this.delegatingConnection.getClass()));
        Assertions.assertTrue((boolean)this.delegatingConnection.isWrapperFor(this.delegatingConnection.getDelegate().getClass()));
        Assertions.assertThrows(SQLException.class, () -> this.delegatingConnection.isWrapperFor(Integer.class));
    }

    @Test
    public void testNativeSQL() throws Exception {
        Assertions.assertNotNull((Object)this.h2DConnection.nativeSQL("select 1"));
    }

    @Test
    public void testPassivateWithResultSetCloseException() {
        try {
            this.testerResultSet.setSqlExceptionOnClose(true);
            this.delegatingConnection.addTrace((AbandonedTrace)this.testerResultSet);
            this.delegatingConnection.passivate();
            Assertions.fail((String)"Expected SQLExceptionList");
        }
        catch (SQLException e) {
            Assertions.assertInstanceOf(SQLExceptionList.class, (Object)e);
            Assertions.assertEquals((int)1, (int)((SQLExceptionList)e).getCauseList().size());
        }
        finally {
            this.testerResultSet.setSqlExceptionOnClose(false);
        }
    }

    @Test
    public void testPassivateWithResultSetCloseExceptionAndStatementCloseException() {
        try {
            this.testerStatement.setSqlExceptionOnClose(true);
            this.testerResultSet.setSqlExceptionOnClose(true);
            this.delegatingConnection.addTrace((AbandonedTrace)this.testerStatement);
            this.delegatingConnection.addTrace((AbandonedTrace)this.testerResultSet);
            this.delegatingConnection.passivate();
            Assertions.fail((String)"Expected SQLExceptionList");
        }
        catch (SQLException e) {
            Assertions.assertInstanceOf(SQLExceptionList.class, (Object)e);
            Assertions.assertEquals((int)2, (int)((SQLExceptionList)e).getCauseList().size());
        }
        finally {
            this.testerStatement.setSqlExceptionOnClose(false);
            this.testerResultSet.setSqlExceptionOnClose(false);
        }
    }

    @Test
    public void testPassivateWithStatementCloseException() {
        try {
            this.testerStatement.setSqlExceptionOnClose(true);
            this.delegatingConnection.addTrace((AbandonedTrace)this.testerStatement);
            this.delegatingConnection.passivate();
            Assertions.fail((String)"Expected SQLExceptionList");
        }
        catch (SQLException e) {
            Assertions.assertInstanceOf(SQLExceptionList.class, (Object)e);
            Assertions.assertEquals((int)1, (int)((SQLExceptionList)e).getCauseList().size());
        }
        finally {
            this.testerStatement.setSqlExceptionOnClose(false);
        }
    }

    @Test
    public void testReadOnlyCaching() throws SQLException {
        NoReadOnlyOrAutoCommitConnection con = new NoReadOnlyOrAutoCommitConnection();
        DelegatingConnection delCon = new DelegatingConnection((Connection)con);
        delCon.setReadOnly(true);
        Assertions.assertFalse((boolean)con.isReadOnly());
        Assertions.assertFalse((boolean)delCon.isReadOnly());
    }

    @Test
    public void testReleaseSavepoint() throws Exception {
        Savepoint s = this.h2DConnection.setSavepoint();
        this.h2DConnection.releaseSavepoint(s);
    }

    @Test
    public void testRollback() throws Exception {
        this.h2DConnection.rollback();
    }

    @Test
    public void testRollbackSavepoint() throws Exception {
        this.h2DConnection.setAutoCommit(false);
        try {
            this.h2DConnection.rollback(this.h2DConnection.setSavepoint());
        }
        finally {
            this.h2DConnection.setAutoCommit(true);
        }
    }

    @Test
    public void testSetClientInfo() throws Exception {
    }

    @Test
    public void testSetDefaultQueryTimeout() throws Exception {
        boolean expected = true;
        this.delegatingConnection.setDefaultQueryTimeout(Integer.valueOf(1));
        Assertions.assertEquals((int)1, (Integer)this.delegatingConnection.getDefaultQueryTimeout());
    }

    @Test
    public void testSetHoldability() throws Exception {
        boolean expected = true;
        this.h2DConnection.setHoldability(1);
        Assertions.assertEquals((int)1, (int)this.h2DConnection.getHoldability());
    }

    @Test
    public void testSetNetworkTimeout() throws Exception {
        this.h2DConnection.setNetworkTimeout(r -> {}, 1);
        Assertions.assertEquals((int)0, (int)this.h2DConnection.getNetworkTimeout());
    }

    @Test
    public void testSetSavepoint() throws Exception {
        this.h2DConnection.setSavepoint();
    }

    @Test
    public void testUnwrap() throws Exception {
        Assertions.assertNotNull((Object)this.delegatingConnection.unwrap(this.delegatingConnection.getClass()));
        Assertions.assertNotNull((Object)this.delegatingConnection.unwrap(this.delegatingConnection.getDelegate().getClass()));
        Assertions.assertThrows(SQLException.class, () -> this.delegatingConnection.unwrap(Integer.class));
    }

    static class NoReadOnlyOrAutoCommitConnection
    extends TesterConnection {
        private final boolean readOnly = false;
        private final boolean autoCommit = false;

        public NoReadOnlyOrAutoCommitConnection() {
            super("", "");
        }

        @Override
        public boolean getAutoCommit() {
            return false;
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return false;
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
        }

        @Override
        public void setReadOnly(boolean readOnly) {
        }
    }

    static class RTEGeneratingConnection
    extends TesterConnection {
        public RTEGeneratingConnection() {
            super("", "");
        }

        public String toString() {
            throw new RuntimeException("bang!");
        }
    }
}

