/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import org.apache.commons.crypto.jna.OpenSslInterfaceNativeJna;
import org.apache.commons.crypto.jna.OpenSslJna;
import org.apache.commons.crypto.jna.OpenSslNativeJna;

final class OpenSsl11XNativeJna
implements OpenSslInterfaceNativeJna {
    static final boolean INIT_OK;
    static final Throwable INIT_ERROR;

    static {
        boolean ok = false;
        Throwable thrown = null;
        try {
            try {
                String libName = System.getProperty("commons.crypto." + OpenSslNativeJna.class.getSimpleName(), "crypto");
                OpenSslJna.debug("Native.register('%s')", libName);
                Native.register((String)libName);
                ok = true;
            }
            catch (Exception | UnsatisfiedLinkError e) {
                thrown = e;
                INIT_OK = ok;
                INIT_ERROR = thrown;
            }
        }
        finally {
            INIT_OK = ok;
            INIT_ERROR = thrown;
        }
    }

    OpenSsl11XNativeJna() {
    }

    public static native PointerByReference ENGINE_by_id(String var0);

    public static native int ENGINE_finish(PointerByReference var0);

    public static native int ENGINE_free(PointerByReference var0);

    public static native int ENGINE_init(PointerByReference var0);

    public static native int ENGINE_set_default(PointerByReference var0, int var1);

    public static native String ERR_error_string(NativeLong var0, char[] var1);

    public static native NativeLong ERR_peek_error();

    public static native PointerByReference EVP_aes_128_cbc();

    public static native PointerByReference EVP_aes_128_ctr();

    public static native PointerByReference EVP_aes_192_cbc();

    public static native PointerByReference EVP_aes_192_ctr();

    public static native PointerByReference EVP_aes_256_cbc();

    public static native PointerByReference EVP_aes_256_ctr();

    public static native void EVP_CIPHER_CTX_free(PointerByReference var0);

    public static native PointerByReference EVP_CIPHER_CTX_new();

    public static native int EVP_CIPHER_CTX_set_padding(PointerByReference var0, int var1);

    public static native int EVP_CipherFinal_ex(PointerByReference var0, ByteBuffer var1, int[] var2);

    public static native int EVP_CipherInit_ex(PointerByReference var0, PointerByReference var1, PointerByReference var2, byte[] var3, byte[] var4, int var5);

    public static native int EVP_CipherUpdate(PointerByReference var0, ByteBuffer var1, int[] var2, ByteBuffer var3, int var4);

    public static native String OpenSSL_version(int var0);

    public static native int RAND_bytes(ByteBuffer var0, int var1);

    public static native PointerByReference RAND_get_rand_method();

    @Override
    public PointerByReference _ENGINE_by_id(String string) {
        return OpenSsl11XNativeJna.ENGINE_by_id(string);
    }

    @Override
    public int _ENGINE_cleanup() {
        return 0;
    }

    @Override
    public int _ENGINE_finish(PointerByReference rdrandEngine) {
        return OpenSsl11XNativeJna.ENGINE_finish(rdrandEngine);
    }

    @Override
    public int _ENGINE_free(PointerByReference rdrandEngine) {
        return OpenSsl11XNativeJna.ENGINE_free(rdrandEngine);
    }

    @Override
    public int _ENGINE_init(PointerByReference rdrandEngine) {
        return OpenSsl11XNativeJna.ENGINE_init(rdrandEngine);
    }

    @Override
    public void _ENGINE_load_rdrand() {
    }

    @Override
    public int _ENGINE_set_default(PointerByReference rdrandEngine, int flags) {
        return OpenSsl11XNativeJna.ENGINE_set_default(rdrandEngine, flags);
    }

    @Override
    public String _ERR_error_string(NativeLong err, char[] buff) {
        return OpenSsl11XNativeJna.ERR_error_string(err, buff);
    }

    @Override
    public NativeLong _ERR_peek_error() {
        return OpenSsl11XNativeJna.ERR_peek_error();
    }

    @Override
    public PointerByReference _EVP_aes_128_cbc() {
        return OpenSsl11XNativeJna.EVP_aes_128_cbc();
    }

    @Override
    public PointerByReference _EVP_aes_128_ctr() {
        return OpenSsl11XNativeJna.EVP_aes_128_ctr();
    }

    @Override
    public PointerByReference _EVP_aes_192_cbc() {
        return OpenSsl11XNativeJna.EVP_aes_192_cbc();
    }

    @Override
    public PointerByReference _EVP_aes_192_ctr() {
        return OpenSsl11XNativeJna.EVP_aes_192_ctr();
    }

    @Override
    public PointerByReference _EVP_aes_256_cbc() {
        return OpenSsl11XNativeJna.EVP_aes_256_cbc();
    }

    @Override
    public PointerByReference _EVP_aes_256_ctr() {
        return OpenSsl11XNativeJna.EVP_aes_256_ctr();
    }

    @Override
    public void _EVP_CIPHER_CTX_cleanup(PointerByReference context) {
    }

    @Override
    public void _EVP_CIPHER_CTX_free(PointerByReference context) {
        OpenSsl11XNativeJna.EVP_CIPHER_CTX_free(context);
    }

    @Override
    public PointerByReference _EVP_CIPHER_CTX_new() {
        return OpenSsl11XNativeJna.EVP_CIPHER_CTX_new();
    }

    @Override
    public int _EVP_CIPHER_CTX_set_padding(PointerByReference context, int padding) {
        return OpenSsl11XNativeJna.EVP_CIPHER_CTX_set_padding(context, padding);
    }

    @Override
    public int _EVP_CipherFinal_ex(PointerByReference context, ByteBuffer outBuffer, int[] outlen) {
        return OpenSsl11XNativeJna.EVP_CipherFinal_ex(context, outBuffer, outlen);
    }

    @Override
    public int _EVP_CipherInit_ex(PointerByReference context, PointerByReference algo, PointerByReference impl, byte[] encoded, byte[] iv, int cipherMode) {
        return OpenSsl11XNativeJna.EVP_CipherInit_ex(context, algo, impl, encoded, iv, cipherMode);
    }

    @Override
    public int _EVP_CipherUpdate(PointerByReference context, ByteBuffer outBuffer, int[] outlen, ByteBuffer inBuffer, int remaining) {
        return OpenSsl11XNativeJna.EVP_CipherUpdate(context, outBuffer, outlen, inBuffer, remaining);
    }

    @Override
    public Throwable _INIT_ERROR() {
        return INIT_ERROR;
    }

    @Override
    public boolean _INIT_OK() {
        return INIT_OK;
    }

    @Override
    public String _OpenSSL_version(int i) {
        return OpenSsl11XNativeJna.OpenSSL_version(i);
    }

    @Override
    public int _RAND_bytes(ByteBuffer buf, int length) {
        return OpenSsl11XNativeJna.RAND_bytes(buf, length);
    }

    @Override
    public PointerByReference _RAND_get_rand_method() {
        return OpenSsl11XNativeJna.RAND_get_rand_method();
    }

    @Override
    public PointerByReference _RAND_SSLeay() {
        return null;
    }
}

