/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.crypto.OsInfo;
import org.apache.commons.crypto.utils.Utils;

final class NativeCodeLoader {
    private static final String SIMPLE_NAME = NativeCodeLoader.class.getSimpleName();
    private static final String NATIVE_LIBNAME = "commons-crypto";
    private static final String NATIVE_LIBNAME_ALT = "libcommons-crypto.jnilib";
    private static final int EOF = -1;
    private static final Throwable libraryLoadingError;
    private static final boolean libraryLoaded;

    static {
        NativeCodeLoader.debug("%s static init start", SIMPLE_NAME);
        libraryLoadingError = NativeCodeLoader.loadLibrary();
        libraryLoaded = libraryLoadingError == null;
        NativeCodeLoader.debug("%s libraryLoaded = %s, libraryLoadingError = %s", SIMPLE_NAME, libraryLoaded, libraryLoadingError);
        NativeCodeLoader.debug("%s static init end", SIMPLE_NAME);
    }

    private static BufferedInputStream buffer(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    private static boolean contentsEquals(InputStream input1, InputStream input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null ^ input2 == null) {
            return false;
        }
        BufferedInputStream bufferedInput1 = NativeCodeLoader.buffer(input1);
        BufferedInputStream bufferedInput2 = NativeCodeLoader.buffer(input2);
        int ch = bufferedInput1.read();
        while (-1 != ch) {
            int ch2 = bufferedInput2.read();
            if (ch != ch2) {
                return false;
            }
            ch = bufferedInput1.read();
        }
        return bufferedInput2.read() == -1;
    }

    private static void debug(String format, Object ... args) {
        if (NativeCodeLoader.isDebug()) {
            System.out.println(String.format(format, args));
            if (args != null && args.length > 0 && args[0] instanceof Throwable) {
                ((Throwable)args[0]).printStackTrace(System.out);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File extractLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        String nativeLibraryFilePath = String.valueOf(libFolderForCurrentOS) + File.separator + libraryFileName;
        UUID uuid = UUID.randomUUID();
        String extractedLibFileName = String.format("commons-crypto-%s-%s", uuid, libraryFileName);
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        NativeCodeLoader.debug("Extracting '%s' to '%s'...", nativeLibraryFilePath, extractedLibFile);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (InputStream inputStream = NativeCodeLoader.class.getResourceAsStream(nativeLibraryFilePath);){
                Path path;
                block29: {
                    if (inputStream == null) {
                        NativeCodeLoader.debug("Resource not found: %s", nativeLibraryFilePath);
                        return null;
                    }
                    try {
                        path = extractedLibFile.toPath();
                        long byteCount = Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                        if (!NativeCodeLoader.isDebug()) break block29;
                        NativeCodeLoader.debug("Extracted '%s' to '%s': %,d bytes [%s]", nativeLibraryFilePath, extractedLibFile, byteCount, Files.isExecutable(path) ? "X+" : "X-");
                        PosixFileAttributes attributes = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
                        if (attributes != null) {
                            NativeCodeLoader.debug("Attributes '%s': %s %s %s", extractedLibFile, attributes.permissions(), attributes.owner(), attributes.group());
                        }
                    }
                    catch (Throwable throwable2) {
                        NativeCodeLoader.debug("Delete on exit: %s", extractedLibFile);
                        extractedLibFile.deleteOnExit();
                        throw throwable2;
                    }
                }
                NativeCodeLoader.debug("Delete on exit: %s", extractedLibFile);
                extractedLibFile.deleteOnExit();
                if (!extractedLibFile.setReadable(true)) throw new IllegalStateException("Invalid path for library path " + extractedLibFile);
                if (!extractedLibFile.setExecutable(true)) throw new IllegalStateException("Invalid path for library path " + extractedLibFile);
                if (!extractedLibFile.setWritable(true, true)) {
                    throw new IllegalStateException("Invalid path for library path " + extractedLibFile);
                }
                Throwable throwable3 = null;
                Object var12_21 = null;
                try (InputStream nativeInputStream = NativeCodeLoader.class.getResourceAsStream(nativeLibraryFilePath);){
                    Throwable throwable4 = null;
                    Object var15_23 = null;
                    try (InputStream extractedLibIn = Files.newInputStream(path, new OpenOption[0]);){
                        NativeCodeLoader.debug("Validating '%s'...", extractedLibFile);
                        if (NativeCodeLoader.contentsEquals(nativeInputStream, extractedLibIn)) return extractedLibFile;
                        throw new IllegalStateException(String.format("Failed to write a native library file %s to %s", nativeLibraryFilePath, extractedLibFile));
                    }
                    catch (Throwable throwable5) {
                        if (throwable4 == null) {
                            throwable4 = throwable5;
                            throw throwable4;
                        }
                        if (throwable4 == throwable5) throw throwable4;
                        throwable4.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable3 == null) {
                        throwable3 = throwable6;
                        throw throwable3;
                    }
                    if (throwable3 == throwable6) throw throwable3;
                    throwable3.addSuppressed(throwable6);
                    throw throwable3;
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (IOException e) {
            NativeCodeLoader.debug("Ignoring %s", e);
            return null;
        }
    }

    private static File findNativeLibrary() {
        Properties props = Utils.getDefaultProperties();
        String nativeLibraryPath = props.getProperty("commons.crypto.lib.path");
        String nativeLibraryName = props.getProperty("commons.crypto.lib.name", System.mapLibraryName(NATIVE_LIBNAME));
        NativeCodeLoader.debug("%s nativeLibraryPath %s = %s", SIMPLE_NAME, "commons.crypto.lib.path", nativeLibraryPath);
        NativeCodeLoader.debug("%s nativeLibraryName %s = %s", SIMPLE_NAME, "commons.crypto.lib.name", nativeLibraryName);
        if (nativeLibraryPath != null) {
            File nativeLib = new File(nativeLibraryPath, nativeLibraryName);
            boolean exists = nativeLib.exists();
            NativeCodeLoader.debug("%s nativeLib %s exists = %s", SIMPLE_NAME, nativeLib, exists);
            if (exists) {
                return nativeLib;
            }
        }
        nativeLibraryPath = "/org/apache/commons/crypto/native/" + OsInfo.getNativeLibFolderPathForCurrentOS();
        NativeCodeLoader.debug("%s nativeLibraryPath = %s", SIMPLE_NAME, nativeLibraryPath);
        String resource = String.valueOf(nativeLibraryPath) + File.separator + nativeLibraryName;
        boolean hasNativeLib = NativeCodeLoader.hasResource(resource);
        NativeCodeLoader.debug("%s resource %s exists = %s", SIMPLE_NAME, resource, hasNativeLib);
        if (!hasNativeLib) {
            String altName = NATIVE_LIBNAME_ALT;
            if (OsInfo.getOSName().equals("Mac") && NativeCodeLoader.hasResource(String.valueOf(nativeLibraryPath) + File.separator + NATIVE_LIBNAME_ALT)) {
                nativeLibraryName = NATIVE_LIBNAME_ALT;
                hasNativeLib = true;
            }
        }
        if (!hasNativeLib) {
            String errorMessage = String.format("No native library is found for os.name=%s and os.arch=%s", OsInfo.getOSName(), OsInfo.getArchName());
            throw new IllegalStateException(errorMessage);
        }
        String tempFolder = new File(props.getProperty("commons.crypto.lib.tempdir", System.getProperty("java.io.tmpdir"))).getAbsolutePath();
        return NativeCodeLoader.extractLibraryFile(nativeLibraryPath, nativeLibraryName, tempFolder);
    }

    static Throwable getLoadingError() {
        return libraryLoadingError;
    }

    private static boolean hasResource(String path) {
        return NativeCodeLoader.class.getResource(path) != null;
    }

    private static boolean isDebug() {
        return Boolean.getBoolean("commons.crypto.debug");
    }

    static boolean isNativeCodeLoaded() {
        return libraryLoaded;
    }

    static Throwable loadLibrary() {
        try {
            File nativeLibFile = NativeCodeLoader.findNativeLibrary();
            if (nativeLibFile != null) {
                String absolutePath = nativeLibFile.getAbsolutePath();
                NativeCodeLoader.debug("%s System.load('%s')", SIMPLE_NAME, absolutePath);
                System.load(absolutePath);
            } else {
                String libname = NATIVE_LIBNAME;
                NativeCodeLoader.debug("%s System.loadLibrary('%s')", SIMPLE_NAME, NATIVE_LIBNAME);
                System.loadLibrary(NATIVE_LIBNAME);
            }
            return null;
        }
        catch (Exception | UnsatisfiedLinkError t) {
            return t;
        }
    }

    private NativeCodeLoader() {
    }
}

