/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationErrorListenerImpl;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.DynamicCombinedConfiguration;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.FileSystemBased;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.TestDefaultConfigurationBuilder;
import org.apache.commons.configuration.VFSFileSystem;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.XMLPropertiesConfiguration;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanHelper;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVFSConfigurationBuilder {
    private static final File TEST_FILE = ConfigurationAssert.getTestFile("testDigesterConfiguration.xml");
    private static final File ADDITIONAL_FILE = ConfigurationAssert.getTestFile("testDigesterConfiguration2.xml");
    private static final File OPTIONAL_FILE = ConfigurationAssert.getTestFile("testDigesterOptionalConfiguration.xml");
    private static final File OPTIONALEX_FILE = ConfigurationAssert.getTestFile("testDigesterOptionalConfigurationEx.xml");
    private static final File MULTI_FILE = ConfigurationAssert.getTestFile("testDigesterConfiguration3.xml");
    private static final File INIT_FILE = ConfigurationAssert.getTestFile("testComplexInitialization.xml");
    private static final File CLASS_FILE = ConfigurationAssert.getTestFile("testExtendedClass.xml");
    private static final File PROVIDER_FILE = ConfigurationAssert.getTestFile("testConfigurationProvider.xml");
    private static final File EXTENDED_PROVIDER_FILE = ConfigurationAssert.getTestFile("testExtendedXMLConfigurationProvider.xml");
    private static final File GLOBAL_LOOKUP_FILE = ConfigurationAssert.getTestFile("testGlobalLookup.xml");
    private static final File SYSTEM_PROPS_FILE = ConfigurationAssert.getTestFile("testSystemProperties.xml");
    private static final File VALIDATION_FILE = ConfigurationAssert.getTestFile("testValidation.xml");
    private static final File VALIDATION2_FILE = ConfigurationAssert.getTestFile("testValidation2.xml");
    private static final File MULTI_TENENT_FILE = ConfigurationAssert.getTestFile("testMultiTenentConfigurationBuilder.xml");
    private static final File FILESYSTEM_FILE = ConfigurationAssert.getTestFile("testFileSystem.xml");
    private static final File FILERELOAD_FILE = ConfigurationAssert.getTestFile("testFileReloadConfigurationBuilder.xml");
    private static final File MULTI_RELOAD_FILE1 = ConfigurationAssert.getTestFile("testVFSMultiTenentConfigurationBuilder1.xml");
    private static final File MULTI_RELOAD_FILE2 = ConfigurationAssert.getTestFile("testVFSMultiTenentConfigurationBuilder2.xml");
    private static final String OPTIONAL_NAME = "optionalConfig";
    DefaultConfigurationBuilder factory;

    @Before
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", "org.apache.commons.configuration.MockInitialContextFactory");
        System.setProperty("test_file_xml", "test.xml");
        System.setProperty("test_file_combine", "testcombine1.xml");
        System.setProperty("basePath", "file://" + System.getProperty("user.dir") + "/target/test-classes");
        FileSystem.setDefaultFileSystem((FileSystem)new VFSFileSystem());
        this.factory = new DefaultConfigurationBuilder();
        this.factory.clearErrorListeners();
    }

    @After
    public void tearDown() throws Exception {
        FileSystem.resetDefaultFileSystem();
    }

    @Test
    public void testConfigurationDeclarationIsReserved() {
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory);
        DefaultConfigurationNode parent = new DefaultConfigurationNode();
        DefaultConfigurationNode nd = new DefaultConfigurationNode("at");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Attribute at not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("optional");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Attribute optional not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("config-class");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)"Inherited attribute not recognized", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("different");
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertFalse((String)"Wrong reserved attribute", (boolean)decl.isReservedNode((ConfigurationNode)nd));
        nd = new DefaultConfigurationNode("at");
        parent.addChild((ConfigurationNode)nd);
        Assert.assertFalse((String)"Node type not evaluated", (boolean)decl.isReservedNode((ConfigurationNode)nd));
    }

    @Test
    public void testConfigurationDeclarationIsReservedAt() {
        this.checkOldReservedAttribute("at");
    }

    @Test
    public void testConfigurationDeclarationIsReservedOptional() {
        this.checkOldReservedAttribute("optional");
    }

    private void checkOldReservedAttribute(String name) {
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory);
        DefaultConfigurationNode parent = new DefaultConfigurationNode();
        DefaultConfigurationNode nd = new DefaultConfigurationNode("config-" + name);
        parent.addAttribute((ConfigurationNode)nd);
        Assert.assertTrue((String)("config-" + name + " attribute not recognized"), (boolean)decl.isReservedNode((ConfigurationNode)nd));
        DefaultConfigurationNode nd2 = new DefaultConfigurationNode(name);
        parent.addAttribute((ConfigurationNode)nd2);
        Assert.assertFalse((String)(name + " is reserved though config- exists"), (boolean)decl.isReservedNode((ConfigurationNode)nd2));
        Assert.assertTrue((String)("config- attribute not recognized when " + name + " exists"), (boolean)decl.isReservedNode((ConfigurationNode)nd));
    }

    @Test
    public void testConfigurationDeclarationGetAttributes() {
        this.factory.addProperty("xml.fileName", (Object)"test.xml");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("xml"));
        Assert.assertNull((String)"Found an at attribute", (Object)decl.getAt());
        Assert.assertFalse((String)"Found an optional attribute", (boolean)decl.isOptional());
        this.factory.addProperty("xml[@config-at]", (Object)"test1");
        Assert.assertEquals((String)"Wrong value of at attribute", (Object)"test1", (Object)decl.getAt());
        this.factory.addProperty("xml[@at]", (Object)"test2");
        Assert.assertEquals((String)"Wrong value of config-at attribute", (Object)"test1", (Object)decl.getAt());
        this.factory.clearProperty("xml[@config-at]");
        Assert.assertEquals((String)"Old at attribute not detected", (Object)"test2", (Object)decl.getAt());
        this.factory.addProperty("xml[@config-optional]", (Object)"true");
        Assert.assertTrue((String)"Wrong value of optional attribute", (boolean)decl.isOptional());
        this.factory.addProperty("xml[@optional]", (Object)"false");
        Assert.assertTrue((String)"Wrong value of config-optional attribute", (boolean)decl.isOptional());
        this.factory.clearProperty("xml[@config-optional]");
        this.factory.setProperty("xml[@optional]", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"Old optional attribute not detected", (boolean)decl.isOptional());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationDeclarationOptionalAttributeInvalid() {
        this.factory.addProperty("xml.fileName", (Object)"test.xml");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("xml"));
        this.factory.setProperty("xml[@optional]", (Object)"invalid value");
        decl.isOptional();
    }

    @Test
    public void testAddConfigurationProvider() {
        DefaultConfigurationBuilder.ConfigurationProvider provider = new DefaultConfigurationBuilder.ConfigurationProvider();
        Assert.assertNull((String)"Provider already registered", (Object)this.factory.providerForTag("test"));
        this.factory.addConfigurationProvider("test", provider);
        Assert.assertSame((String)"Provider not registered", (Object)provider, (Object)this.factory.providerForTag("test"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConfigurationProviderNull() {
        this.factory.addConfigurationProvider("test", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConfigurationProviderNullTag() {
        this.factory.addConfigurationProvider(null, new DefaultConfigurationBuilder.ConfigurationProvider());
    }

    @Test
    public void testRemoveConfigurationProvider() {
        Assert.assertNull((String)"Removing unknown provider", (Object)this.factory.removeConfigurationProvider("test"));
        Assert.assertNull((String)"Removing provider for null tag", (Object)this.factory.removeConfigurationProvider(null));
        DefaultConfigurationBuilder.ConfigurationProvider provider = new DefaultConfigurationBuilder.ConfigurationProvider();
        this.factory.addConfigurationProvider("test", provider);
        Assert.assertSame((String)"Failed to remove provider", (Object)provider, (Object)this.factory.removeConfigurationProvider("test"));
        Assert.assertNull((String)"Provider still registered", (Object)this.factory.providerForTag("test"));
    }

    @Test
    public void testConfigurationBeanFactoryCreateBean() {
        this.factory.addConfigurationProvider("test", new DefaultConfigurationBuilder.ConfigurationProvider(PropertiesConfiguration.class));
        this.factory.addProperty("test[@throwExceptionOnMissing]", (Object)"true");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("test"));
        PropertiesConfiguration conf = (PropertiesConfiguration)BeanHelper.createBean((BeanDeclaration)decl);
        Assert.assertTrue((String)"Property was not initialized", (boolean)conf.isThrowExceptionOnMissing());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationBeanFactoryCreateUnknownTag() {
        this.factory.addProperty("test[@throwExceptionOnMissing]", (Object)"true");
        DefaultConfigurationBuilder.ConfigurationDeclaration decl = new DefaultConfigurationBuilder.ConfigurationDeclaration(this.factory, (HierarchicalConfiguration)this.factory.configurationAt("test"));
        BeanHelper.createBean((BeanDeclaration)decl);
    }

    @Test
    public void testLoadConfiguration() throws ConfigurationException {
        this.factory.setFile(TEST_FILE);
        this.checkConfiguration();
    }

    @Test
    public void testLoadConfigurationFromFile() throws ConfigurationException {
        this.factory = new DefaultConfigurationBuilder(TEST_FILE);
        this.checkConfiguration();
    }

    @Test
    public void testLoadConfigurationFromFileName() throws ConfigurationException {
        this.factory = new DefaultConfigurationBuilder(TEST_FILE.getAbsolutePath());
        this.checkConfiguration();
    }

    @Test
    public void testLoadConfigurationFromURL() throws Exception {
        this.factory = new DefaultConfigurationBuilder(TEST_FILE.toURI().toURL());
        this.checkConfiguration();
    }

    private void checkConfiguration() throws ConfigurationException {
        CombinedConfiguration compositeConfiguration = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Number of configurations", (long)3L, (long)compositeConfiguration.getNumberOfConfigurations());
        Assert.assertEquals(PropertiesConfiguration.class, compositeConfiguration.getConfiguration(0).getClass());
        Assert.assertEquals(XMLPropertiesConfiguration.class, compositeConfiguration.getConfiguration(1).getClass());
        Assert.assertEquals(XMLConfiguration.class, compositeConfiguration.getConfiguration(2).getClass());
        PropertiesConfiguration pc = (PropertiesConfiguration)compositeConfiguration.getConfiguration(0);
        Assert.assertNotNull((String)("Make sure we have a fileName: " + pc.getFileName()), (Object)pc.getFileName());
        this.checkProperties((Configuration)compositeConfiguration);
    }

    private void checkProperties(Configuration compositeConfiguration) {
        Assert.assertTrue((String)"Make sure we have loaded our key", (boolean)compositeConfiguration.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"I'm complex!", (Object)compositeConfiguration.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((String)"property in the XMLPropertiesConfiguration", (Object)"value1", (Object)compositeConfiguration.getProperty("key1"));
    }

    @Test
    public void testLoadAdditional() throws ConfigurationException {
        this.factory.setFile(ADDITIONAL_FILE);
        CombinedConfiguration compositeConfiguration = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"Verify how many configs", (long)2L, (long)compositeConfiguration.getNumberOfConfigurations());
        Object prop = compositeConfiguration.getProperty("tables.table.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)3L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"users", (Object)compositeConfiguration.getProperty("tables.table(0).name"));
        Assert.assertEquals((Object)"documents", (Object)compositeConfiguration.getProperty("tables.table(1).name"));
        Assert.assertEquals((Object)"tasks", (Object)compositeConfiguration.getProperty("tables.table(2).name"));
        prop = compositeConfiguration.getProperty("tables.table.fields.field.name");
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)17L, (long)((Collection)prop).size());
        Assert.assertEquals((Object)"smtp.mydomain.org", (Object)compositeConfiguration.getString("mail.host.smtp"));
        Assert.assertEquals((Object)"pop3.mydomain.org", (Object)compositeConfiguration.getString("mail.host.pop"));
        Assert.assertEquals((Object)"masterOfPost", (Object)compositeConfiguration.getString("mail.account.user"));
        Assert.assertEquals((Object)"topsecret", (Object)compositeConfiguration.getString("mail.account.psswd"));
        Assert.assertEquals((Object)"enhanced factory", (Object)compositeConfiguration.getString("test.configuration"));
    }

    @Test
    public void testLogErrorListener() {
        Assert.assertEquals((String)"No default error listener registered", (long)1L, (long)new DefaultConfigurationBuilder().getErrorListeners().size());
    }

    @Test
    public void testLoadOptional() throws Exception {
        this.factory.setURL(OPTIONAL_FILE.toURI().toURL());
        Configuration config = this.factory.getConfiguration();
        Assert.assertTrue((boolean)config.getBoolean("test.boolean"));
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element"));
    }

    @Test
    public void testLoadOptionalErrorEvent() throws Exception {
        this.factory.clearErrorListeners();
        ConfigurationErrorListenerImpl listener = new ConfigurationErrorListenerImpl();
        this.factory.addErrorListener((ConfigurationErrorListener)listener);
        this.prepareOptionalTest("configuration", false);
        listener.verify(51, OPTIONAL_NAME, null);
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadOptionalWithException() throws ConfigurationException {
        this.factory.setFile(OPTIONALEX_FILE);
        this.factory.getConfiguration();
    }

    @Test
    public void testLoadOptionalNonFileBased() throws ConfigurationException {
        CombinedConfiguration config = this.prepareOptionalTest("configuration", false);
        Assert.assertTrue((String)"Configuration not empty", (boolean)config.isEmpty());
        Assert.assertEquals((String)"Wrong number of configurations", (long)0L, (long)config.getNumberOfConfigurations());
    }

    @Test
    public void testLoadOptionalForceCreate() throws ConfigurationException {
        this.factory.setBasePath(TEST_FILE.getParent());
        CombinedConfiguration config = this.prepareOptionalTest("xml", true);
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)config.getNumberOfConfigurations());
        FileConfiguration fc = (FileConfiguration)config.getConfiguration(OPTIONAL_NAME);
        Assert.assertNotNull((String)"Optional config not found", (Object)fc);
        Assert.assertEquals((String)"File name was not set", (Object)"nonExisting.xml", (Object)fc.getFileName());
        Assert.assertNotNull((String)"Base path was not set", (Object)fc.getBasePath());
    }

    @Test
    public void testLoadOptionalBuilderForceCreate() throws ConfigurationException {
        CombinedConfiguration config = this.prepareOptionalTest("configuration", true);
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)config.getNumberOfConfigurations());
        Assert.assertTrue((String)"Wrong optional configuration type", (boolean)(config.getConfiguration(OPTIONAL_NAME) instanceof CombinedConfiguration));
    }

    @Test
    public void testLoadOptionalForceCreateWithException() throws ConfigurationException {
        this.factory.addConfigurationProvider("test", (DefaultConfigurationBuilder.ConfigurationProvider)new DefaultConfigurationBuilder.ConfigurationBuilderProvider(){

            public AbstractConfiguration getEmptyConfiguration(DefaultConfigurationBuilder.ConfigurationDeclaration decl) throws Exception {
                throw new Exception("Unable to create configuration!");
            }
        });
        CombinedConfiguration config = this.prepareOptionalTest("test", true);
        Assert.assertEquals((String)"Optional configuration could be created", (long)0L, (long)config.getNumberOfConfigurations());
    }

    private CombinedConfiguration prepareOptionalTest(String tag, boolean force) throws ConfigurationException {
        String prefix = "override." + tag;
        this.factory.addProperty(prefix + "[@fileName]", (Object)"nonExisting.xml");
        this.factory.addProperty(prefix + "[@config-optional]", (Object)Boolean.TRUE);
        this.factory.addProperty(prefix + "[@config-name]", (Object)OPTIONAL_NAME);
        if (force) {
            this.factory.addProperty(prefix + "[@config-forceCreate]", (Object)Boolean.TRUE);
        }
        return this.factory.getConfiguration(false);
    }

    @Test
    public void testLoadDifferentSources() throws ConfigurationException {
        this.factory.setFile(MULTI_FILE);
        Configuration config = this.factory.getConfiguration();
        Assert.assertFalse((boolean)config.isEmpty());
        Assert.assertTrue((boolean)(config instanceof CombinedConfiguration));
        CombinedConfiguration cc = (CombinedConfiguration)config;
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)cc.getNumberOfConfigurations());
        Assert.assertNotNull((Object)config.getProperty("tables.table(0).fields.field(2).name"));
        Assert.assertNotNull((Object)config.getProperty("element2.subelement.subsubelement"));
        Assert.assertEquals((Object)"value", (Object)config.getProperty("element3"));
        Assert.assertEquals((Object)"foo", (Object)config.getProperty("element3[@name]"));
        Assert.assertNotNull((Object)config.getProperty("mail.account.user"));
        Assert.assertNotNull((Object)config.getProperty("test.onlyinjndi"));
        Assert.assertTrue((boolean)config.getBoolean("test.onlyinjndi"));
        Configuration subset = config.subset("test");
        Assert.assertNotNull((Object)subset.getProperty("onlyinjndi"));
        Assert.assertTrue((boolean)subset.getBoolean("onlyinjndi"));
        Assert.assertNotNull((Object)config.getProperty("java.version"));
        Assert.assertEquals((Object)System.getProperty("java.version"), (Object)config.getString("java.version"));
    }

    @Test
    public void testSetConfigurationBasePath() throws ConfigurationException {
        this.factory.addProperty("properties[@fileName]", (Object)"test.properties");
        File deepDir = new File(ConfigurationAssert.TEST_DIR, "config/deep");
        this.factory.setConfigurationBasePath(deepDir.getAbsolutePath());
        CombinedConfiguration config = this.factory.getConfiguration(false);
        Assert.assertEquals((String)"Wrong property value", (Object)"somevalue", (Object)config.getString("somekey"));
    }

    @Test
    public void testComplexInitialization() throws ConfigurationException {
        this.factory.setFile(INIT_FILE);
        CombinedConfiguration cc = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertEquals((String)"System property not found", (Object)"test.xml", (Object)cc.getString("test_file_xml"));
        PropertiesConfiguration c1 = (PropertiesConfiguration)cc.getConfiguration(1);
        Assert.assertTrue((String)"Reloading strategy was not set", (boolean)(c1.getReloadingStrategy() instanceof FileChangedReloadingStrategy));
        Assert.assertEquals((String)"Refresh delay was not set", (long)10000L, (long)((FileChangedReloadingStrategy)c1.getReloadingStrategy()).getRefreshDelay());
        Configuration xmlConf = cc.getConfiguration("xml");
        Assert.assertEquals((String)"Property not found", (Object)"I'm complex!", (Object)xmlConf.getString("element2/subelement/subsubelement"));
        Assert.assertEquals((String)"List index not found", (Object)"two", (Object)xmlConf.getString("list[0]/item[1]"));
        Assert.assertEquals((String)"Property in combiner file not found", (Object)"yellow", (Object)cc.getString("/gui/selcolor"));
        Assert.assertTrue((String)"Delimiter flag was not set", (boolean)cc.isDelimiterParsingDisabled());
        Assert.assertTrue((String)"Expression engine was not set", (boolean)(cc.getExpressionEngine() instanceof XPathExpressionEngine));
    }

    @Test
    public void testCombinedConfiguration() throws ConfigurationException {
        this.factory.setFile(INIT_FILE);
        CombinedConfiguration cc = (CombinedConfiguration)this.factory.getConfiguration();
        Assert.assertNotNull((String)"Properties configuration not found", (Object)cc.getConfiguration("properties"));
        Assert.assertNotNull((String)"XML configuration not found", (Object)cc.getConfiguration("xml"));
        Assert.assertEquals((String)"Wrong number of contained configs", (long)4L, (long)cc.getNumberOfConfigurations());
        CombinedConfiguration cc2 = (CombinedConfiguration)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME);
        Assert.assertNotNull((String)"No additional configuration found", (Object)cc2);
        Set names = cc2.getConfigurationNames();
        Assert.assertEquals((String)"Wrong number of contained additional configs", (long)2L, (long)names.size());
        Assert.assertTrue((String)"Config 1 not contained", (boolean)names.contains("combiner1"));
        Assert.assertTrue((String)"Config 2 not contained", (boolean)names.contains("combiner2"));
    }

    @Test
    public void testCombinedConfigurationNoAdditional() throws ConfigurationException {
        this.factory.setFile(TEST_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        Assert.assertNull((String)"Additional configuration was found", (Object)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME));
    }

    @Test
    public void testCombinedConfigurationListNodes() throws ConfigurationException {
        this.factory.setFile(INIT_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        Set listNodes = cc.getNodeCombiner().getListNodes();
        Assert.assertEquals((String)"Wrong number of list nodes", (long)2L, (long)listNodes.size());
        Assert.assertTrue((String)"table node not a list node", (boolean)listNodes.contains("table"));
        Assert.assertTrue((String)"list node not a list node", (boolean)listNodes.contains("list"));
        CombinedConfiguration cca = (CombinedConfiguration)cc.getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME);
        listNodes = cca.getNodeCombiner().getListNodes();
        Assert.assertTrue((String)"Found list nodes for additional combiner", (boolean)listNodes.isEmpty());
    }

    @Test
    public void testConfigurationBuilderProvider() throws ConfigurationException {
        this.factory.addProperty("override.configuration[@fileName]", (Object)TEST_FILE.getAbsolutePath());
        CombinedConfiguration cc = this.factory.getConfiguration(false);
        Assert.assertEquals((String)"Wrong number of configurations", (long)1L, (long)cc.getNumberOfConfigurations());
        this.checkProperties((Configuration)cc);
    }

    @Test
    public void testLoadXMLWithSettings() throws Exception {
        File confDir = new File("conf");
        File targetDir = new File("target");
        File testXMLValidationSource = new File(confDir, "testValidateInvalid.xml");
        File testSavedXML = new File(targetDir, "testSave.xml");
        File testSavedFactory = new File(targetDir, "testSaveFactory.xml");
        URL dtdFile = this.getClass().getResource("/properties.dtd");
        String publicId = "http://commons.apache.org/test.dtd";
        XMLConfiguration config = new XMLConfiguration("testDtd.xml");
        config.setPublicID("http://commons.apache.org/test.dtd");
        config.save(testSavedXML);
        this.factory.addProperty("xml[@fileName]", (Object)testSavedXML.getAbsolutePath());
        this.factory.addProperty("xml(0)[@validating]", (Object)"true");
        this.factory.addProperty("xml(-1)[@fileName]", (Object)testXMLValidationSource.getAbsolutePath());
        this.factory.addProperty("xml(1)[@config-optional]", (Object)"true");
        this.factory.addProperty("xml(1)[@validating]", (Object)"true");
        this.factory.save(testSavedFactory);
        this.factory = new DefaultConfigurationBuilder();
        this.factory.setFile(testSavedFactory);
        this.factory.registerEntityId("http://commons.apache.org/test.dtd", dtdFile);
        this.factory.clearErrorListeners();
        Configuration c = this.factory.getConfiguration();
        Assert.assertEquals((String)"Wrong property value", (Object)"value1", (Object)c.getString("entry(0)"));
        Assert.assertFalse((String)"Invalid XML source was loaded", (boolean)c.containsKey("table.name"));
        testSavedXML.delete();
        testSavedFactory.delete();
    }

    @Test
    public void testExtendedClass() throws ConfigurationException {
        this.factory.setFile(CLASS_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        String prop = (String)cc.getProperty("test");
        Assert.assertEquals((String)("Expected 'Extended', actual '" + prop + "'"), (Object)"Extended", (Object)prop);
        Assert.assertTrue((String)("Wrong result class: " + cc.getClass()), (boolean)(cc instanceof TestDefaultConfigurationBuilder.ExtendedCombinedConfiguration));
    }

    @Test
    public void testConfigurationProvider() throws ConfigurationException {
        this.factory.setFile(PROVIDER_FILE);
        this.factory.getConfiguration(true);
        DefaultConfigurationBuilder.ConfigurationProvider provider = this.factory.providerForTag("test");
        Assert.assertNotNull((String)"Provider 'test' not registered", (Object)provider);
    }

    @Test
    public void testExtendedXMLConfigurationProvider() throws ConfigurationException {
        this.factory.setFile(EXTENDED_PROVIDER_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        DefaultConfigurationBuilder.ConfigurationProvider provider = this.factory.providerForTag("test");
        Assert.assertNotNull((String)"Provider 'test' not registered", (Object)provider);
        Configuration config = cc.getConfiguration("xml");
        Assert.assertNotNull((String)"Test configuration not present", (Object)config);
        Assert.assertTrue((String)("Configuration is not ExtendedXMLConfiguration, is " + config.getClass().getName()), (boolean)(config instanceof TestDefaultConfigurationBuilder.ExtendedXMLConfiguration));
    }

    @Test
    public void testGlobalLookup() throws Exception {
        this.factory.setFile(GLOBAL_LOOKUP_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        String value = cc.getInterpolator().lookup("test:test_key");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"test.value", (Object)value);
    }

    @Test
    public void testSystemProperties() throws Exception {
        this.factory.setFile(SYSTEM_PROPS_FILE);
        this.factory.getConfiguration(true);
        String value = System.getProperty("key1");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"value1", (Object)value);
    }

    @Test
    public void testValidation() throws Exception {
        this.factory.setFile(VALIDATION_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        String value = cc.getString("key1");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"value1", (Object)value);
    }

    @Test
    public void testValidation2() throws Exception {
        this.factory.setFile(VALIDATION2_FILE);
        CombinedConfiguration cc = this.factory.getConfiguration(true);
        String value = cc.getString("key1");
        Assert.assertNotNull((String)"The test key was not located", (Object)value);
        Assert.assertEquals((String)"Incorrect value retrieved", (Object)"value1", (Object)value);
    }

    @Test
    public void testMultiTenentConfiguration() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify(null, config, 50);
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testMultiTenentConfiguration2() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        System.setProperty("Id", "1004");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testMultiTenentConfiguration3() throws Exception {
        this.factory.setFile(MULTI_TENENT_FILE);
        System.setProperty("Id", "1005");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertTrue((String)"Incorrect configuration", (boolean)(config instanceof DynamicCombinedConfiguration));
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        this.verify("1005", config, 50);
    }

    @Test
    public void testSetFileSystem() throws Exception {
        this.factory.setFile(PROVIDER_FILE);
        VFSFileSystem fs = new VFSFileSystem();
        this.factory.setFileSystem((FileSystem)fs);
        FileSystem.resetDefaultFileSystem();
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        List list = config.getConfigurations();
        Assert.assertTrue((String)("Incorrect number of configurations - " + list.size()), (list.size() == 4 ? 1 : 0) != 0);
        for (Configuration conf2 : list) {
            if (conf2 instanceof FileSystemBased) {
                Assert.assertTrue((String)("Incorrect file system for Configuration " + conf2), (((FileSystemBased)conf2).getFileSystem() == fs ? 1 : 0) != 0);
                continue;
            }
            if (!(conf2 instanceof CombinedConfiguration)) continue;
            for (Configuration conf2 : ((CombinedConfiguration)conf2).getConfigurations()) {
                if (!(conf2 instanceof FileSystemBased)) continue;
                Assert.assertTrue((String)("Incorrect file system for Configuration " + conf2), (((FileSystemBased)conf2).getFileSystem() == fs ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testConfiguredFileSystem() throws Exception {
        this.factory.setFile(FILESYSTEM_FILE);
        FileSystem.resetDefaultFileSystem();
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        FileSystem fs = this.factory.getFileSystem();
        Assert.assertNotNull((String)"No File System", (Object)fs);
        Assert.assertTrue((String)"Incorrect File System", (boolean)(fs instanceof VFSFileSystem));
        List list = config.getConfigurations();
        Assert.assertTrue((String)("Incorrect number of configurations - " + list.size()), (list.size() == 4 ? 1 : 0) != 0);
        for (Configuration conf2 : list) {
            if (conf2 instanceof FileSystemBased) {
                Assert.assertTrue((String)("Incorrect file system for Configuration " + conf2), (((FileSystemBased)conf2).getFileSystem() == fs ? 1 : 0) != 0);
                continue;
            }
            if (!(conf2 instanceof CombinedConfiguration)) continue;
            for (Configuration conf2 : ((CombinedConfiguration)conf2).getConfigurations()) {
                if (!(conf2 instanceof FileSystemBased)) continue;
                Assert.assertTrue((String)("Incorrect file system for Configuration " + conf2), (((FileSystemBased)conf2).getFileSystem() == fs ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testFileReload1() throws Exception {
        File input = new File("target/test-classes/testMultiConfiguration_1001.xml");
        File output = new File("target/test-classes/testwrite/testMultiConfiguration_1001.xml");
        output.delete();
        output.getParentFile().mkdir();
        this.copyFile(input, output);
        Thread.sleep(1100L);
        this.factory.setFile(FILERELOAD_FILE);
        FileSystem.resetDefaultFileSystem();
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        this.verify("1001", config, 15);
        Thread.sleep(1100L);
        XMLConfiguration x = new XMLConfiguration(output);
        x.setProperty("rowsPerPage", (Object)"50");
        x.save();
        this.verify("1001", config, 50);
        output.delete();
    }

    @Test
    public void testFileReload2() throws Exception {
        File input = new File("target/test-classes/testMultiConfiguration_1002.xml");
        File output = new File("target/test-classes/testwrite/testMultiConfiguration_1002.xml");
        output.delete();
        this.factory.setFile(FILERELOAD_FILE);
        FileSystem.resetDefaultFileSystem();
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        this.verify("1002", config, 50);
        Thread.sleep(1100L);
        output.getParentFile().mkdir();
        this.copyFile(input, output);
        this.verify("1002", config, 25);
        output.delete();
    }

    @Test
    public void testFileReload3() throws Exception {
        File input = new File("target/test-classes/testMultiConfiguration_1001.xml");
        File output = new File("target/test-classes/testwrite/testMultiConfiguration_1001.xml");
        output.delete();
        output.getParentFile().mkdir();
        this.factory.setFile(FILERELOAD_FILE);
        FileSystem.resetDefaultFileSystem();
        System.getProperties().remove("Id");
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        this.verify("1001", config, 50);
        this.copyFile(input, output);
        Thread.sleep(1100L);
        this.verify("1001", config, 15);
        XMLConfiguration x = new XMLConfiguration(output);
        x.setProperty("rowsPerPage", (Object)"25");
        x.save();
        Thread.sleep(1100L);
        this.verify("1001", config, 25);
        output.delete();
    }

    @Test
    public void testReloadDefault() throws Exception {
        String defaultName = "target/test-classes/testMultiConfiguration_default.xml";
        File input = new File(defaultName);
        System.getProperties().remove("Id");
        this.factory.setFile(MULTI_RELOAD_FILE1);
        CombinedConfiguration config = this.factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        this.verify("3001", config, 15);
        this.verify("3002", config, 25);
        System.setProperty("Id", "3002");
        config.addProperty("/ TestProp", (Object)"Test");
        Assert.assertTrue((String)"Property not added", (boolean)"Test".equals(config.getString("TestProp")));
        System.getProperties().remove("Id");
        Thread.sleep(600L);
        long time = System.currentTimeMillis();
        long original = input.lastModified();
        input.setLastModified(time);
        File defaultFile = new File(defaultName);
        long newTime = defaultFile.lastModified();
        Assert.assertTrue((String)"time mismatch", (original != newTime ? 1 : 0) != 0);
        Thread.sleep(600L);
        this.verify("3001", config, 15);
        this.verify("3002", config, 25);
        System.setProperty("Id", "3002");
        String test = config.getString("TestProp");
        Assert.assertNull((String)"Property was not cleared by reload", (Object)test);
    }

    @Test
    public void testFileReloadSchemaValidationError() throws Exception {
        System.getProperties().remove("Id");
        this.factory.setFile(MULTI_RELOAD_FILE2);
        CombinedConfiguration config = this.factory.getConfiguration(true);
        File input = new File("target/test-classes/testMultiConfiguration_3001.xml");
        File output = new File("target/test-classes/testwrite/testMultiConfiguration_3001.xml");
        output.delete();
        output.getParentFile().mkdir();
        this.copyFile(input, output);
        Assert.assertNotNull((Object)config);
        this.verify("3001", config, 15);
        Thread.sleep(1100L);
        XMLConfiguration x = new XMLConfiguration();
        x.setFile(output);
        x.setAttributeSplittingDisabled(true);
        x.setDelimiterParsingDisabled(true);
        x.load();
        x.setProperty("rowsPerPage", (Object)"test");
        Thread.sleep(1100L);
        x.save();
        System.setProperty("Id", "3001");
        try {
            config.getInt("rowsPerPage");
            Assert.fail((String)"No exception was thrown");
        }
        catch (Exception ex) {
            // empty catch block
        }
        output.delete();
    }

    private void copyFile(File input, File output) throws IOException {
        FileReader reader = new FileReader(input);
        FileWriter writer = new FileWriter(output);
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = reader.read(buffer))) {
            ((Writer)writer).write(buffer, 0, n);
        }
        ((Reader)reader).close();
        ((Writer)writer).close();
    }

    private void verify(String key, CombinedConfiguration config, int rows) {
        if (key == null) {
            System.getProperties().remove("Id");
        } else {
            System.setProperty("Id", key);
        }
        int actual = config.getInt("rowsPerPage");
        Assert.assertTrue((String)("expected: " + rows + " actual: " + actual), (actual == rows ? 1 : 0) != 0);
    }
}

