/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.MultiFileHierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class TestMultiFileHierarchicalConfiguration {
    private static String PATTERN1 = "target/test-classes/testMultiConfiguration_${sys:Id}.xml";
    private static final File MULTI_TENENT_FILE = new File("conf/testMultiTenentConfigurationBuilder2.xml");
    private static final File MULTI_TENENT_FILE2 = new File("target/test-classes/testMultiTenentConfigurationBuilder2.xml");
    private static final File MULTI_RELOAD_FILE = new File("conf/testMultiTenentConfigurationBuilder3.xml");

    @Test
    public void testMultiConfiguration() {
        FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
        strategy.setRefreshDelay(10000L);
        MultiFileHierarchicalConfiguration config = new MultiFileHierarchicalConfiguration(PATTERN1);
        config.setReloadingStrategy((ReloadingStrategy)strategy);
        System.setProperty("Id", "1001");
        Assert.assertTrue((config.getInt("rowsPerPage") == 15 ? 1 : 0) != 0);
        System.setProperty("Id", "1002");
        Assert.assertTrue((config.getInt("rowsPerPage") == 25 ? 1 : 0) != 0);
        System.setProperty("Id", "1003");
        Assert.assertTrue((config.getInt("rowsPerPage") == 35 ? 1 : 0) != 0);
    }

    @Test
    public void testSchemaValidationError() throws Exception {
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_TENENT_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        try {
            System.setProperty("Id", "2001");
            config.getInt("rowsPerPage");
            Assert.fail((String)"No exception thrown");
        }
        catch (Exception ex) {
            Throwable cause;
            for (cause = ex.getCause(); cause != null && !(cause instanceof SAXParseException); cause = cause.getCause()) {
            }
            Assert.assertTrue((String)"SAXParseException was not thrown", (boolean)(cause instanceof SAXParseException));
        }
    }

    @Test
    public void testSchemaValidation() throws Exception {
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_TENENT_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        System.setProperty("Id", "2002");
        int rows = config.getInt("rowsPerPage");
        Assert.assertTrue((String)("expected: " + rows + " actual: " + "25"), (25 == rows ? 1 : 0) != 0);
    }

    @Test
    public void testMissingFile() throws Exception {
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_TENENT_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        System.setProperty("Id", "3099");
        int rows = config.getInt("rowsPerPage");
        Assert.assertTrue((String)("expected: " + rows + " actual: " + "50"), (50 == rows ? 1 : 0) != 0);
    }

    @Test
    public void testFileReload1() throws Exception {
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_RELOAD_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        File input = new File("target/test-classes/testMultiConfiguration_3001.xml");
        File output = new File("target/test-classes/testwrite/testMultiConfiguration_3001.xml");
        output.delete();
        output.getParentFile().mkdir();
        this.copyFile(input, output);
        Assert.assertNotNull((Object)config);
        this.verify("3001", config, 15);
        Thread.sleep(1100L);
        XMLConfiguration x = new XMLConfiguration();
        x.setFile(output);
        x.setAttributeSplittingDisabled(true);
        x.setDelimiterParsingDisabled(true);
        x.load();
        x.setProperty("rowsPerPage", (Object)"35");
        Thread.sleep(1100L);
        x.save();
        this.verify("3001", config, 35);
        output.delete();
    }

    @Test
    public void testFileReload2() throws Exception {
        File input = new File("target/test-classes/testMultiConfiguration_3002.xml");
        File output = new File("target/test-classes/testwrite/testMultiConfiguration_3002.xml");
        output.delete();
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_RELOAD_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        this.verify("3002", config, 50);
        output.getParentFile().mkdir();
        this.copyFile(input, output);
        Thread.sleep(600L);
        this.verify("3002", config, 25);
        output.delete();
    }

    @Test
    public void testFileReload3() throws Exception {
        File input = new File("target/test-classes/testMultiConfiguration_3001.xml");
        File output = new File("target/test-classes/testwrite/testMultiConfiguration_3001.xml");
        output.delete();
        output.getParentFile().mkdir();
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_RELOAD_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        this.verify("3001", config, 50);
        this.copyFile(input, output);
        Thread.sleep(600L);
        this.verify("3001", config, 15);
        Thread.sleep(500L);
        XMLConfiguration x = new XMLConfiguration();
        x.setFile(output);
        x.setAttributeSplittingDisabled(true);
        x.setDelimiterParsingDisabled(true);
        x.load();
        x.setProperty("rowsPerPage", (Object)"35");
        Thread.sleep(1100L);
        x.save();
        this.verify("3001", config, 35);
        output.delete();
    }

    @Test
    public void testReloadDefault() throws Exception {
        String defaultName = "target/test-classes/testMultiConfiguration_default.xml";
        File input = new File(defaultName);
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_TENENT_FILE2);
        CombinedConfiguration config = factory.getConfiguration(true);
        Assert.assertNotNull((Object)config);
        this.verify("3001", config, 15);
        this.verify("3002", config, 25);
        System.setProperty("Id", "3002");
        config.addProperty("/ TestProp", (Object)"Test");
        Assert.assertTrue((String)"Property not added", (boolean)"Test".equals(config.getString("TestProp")));
        System.getProperties().remove("Id");
        Thread.sleep(600L);
        long time = System.currentTimeMillis();
        long original = input.lastModified();
        input.setLastModified(time);
        File defaultFile = new File(defaultName);
        long newTime = defaultFile.lastModified();
        Assert.assertTrue((String)"time mismatch", (original != newTime ? 1 : 0) != 0);
        Thread.sleep(600L);
        this.verify("3001", config, 15);
        this.verify("3002", config, 25);
        System.setProperty("Id", "3002");
        String test = config.getString("TestProp");
        Assert.assertNull((String)"Property was not cleared by reload", (Object)test);
    }

    @Test
    public void testFileReloadSchemaValidationError() throws Exception {
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_RELOAD_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        File input = new File("target/test-classes/testMultiConfiguration_3001.xml");
        File output = new File("target/test-classes/testwrite/testMultiConfiguration_3001.xml");
        output.delete();
        output.getParentFile().mkdir();
        this.copyFile(input, output);
        Assert.assertNotNull((Object)config);
        this.verify("3001", config, 15);
        Thread.sleep(1100L);
        XMLConfiguration x = new XMLConfiguration();
        x.setFile(output);
        x.setAttributeSplittingDisabled(true);
        x.setDelimiterParsingDisabled(true);
        x.load();
        x.setProperty("rowsPerPage", (Object)"test");
        Thread.sleep(1100L);
        x.save();
        System.setProperty("Id", "3001");
        try {
            config.getInt("rowsPerPage");
            Assert.fail((String)"No exception was thrown");
        }
        catch (Exception ex) {
            // empty catch block
        }
        output.delete();
    }

    private void copyFile(File input, File output) throws IOException {
        FileReader reader = new FileReader(input);
        FileWriter writer = new FileWriter(output);
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = reader.read(buffer))) {
            ((Writer)writer).write(buffer, 0, n);
        }
        ((Reader)reader).close();
        ((Writer)writer).close();
    }

    private void verify(String key, CombinedConfiguration config, int rows) {
        if (key == null) {
            System.getProperties().remove("Id");
        } else {
            System.setProperty("Id", key);
        }
        int actual = config.getInt("rowsPerPage");
        Assert.assertTrue((String)("expected: " + rows + " actual: " + actual), (actual == rows ? 1 : 0) != 0);
    }
}

