/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.beanutils.TestBean;

public class BeanToPropertyValueTransformerTestCase
extends TestCase {
    private static final Integer expectedIntegerValue = 123;
    private static final Long expectedLongValue = 123L;
    private static final Float expectedFloatValue = Float.valueOf(123.123f);
    private static final Double expectedDoubleValue = 567879.12344;
    private static final Boolean expectedBooleanValue = Boolean.TRUE;
    private static final Byte expectedByteValue = Byte.valueOf("12");

    public BeanToPropertyValueTransformerTestCase(String name) {
        super(name);
    }

    public void testTransformWithIndexedProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("intIndexed[0]");
        TestBean testBean = new TestBean();
        testBean.setIntIndexed(0, expectedIntegerValue);
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)expectedIntegerValue, (Object)transformer.transform((Object)testBean));
        transformer = new BeanToPropertyValueTransformer("intIndexed[9999]");
        try {
            transformer.transform((Object)testBean);
            BeanToPropertyValueTransformerTestCase.fail((String)"Should have thrown an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testTransformWithInvalidProperty() {
        try {
            new BeanToPropertyValueTransformer("bogusProperty").transform((Object)new TestBean());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTransformWithMappedProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("mappedProperty(test-key)");
        TestBean testBean = new TestBean();
        testBean.setMappedProperty("test-key", "test-value");
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)"test-value", (Object)transformer.transform((Object)testBean));
        transformer = new BeanToPropertyValueTransformer("mappedProperty(bogus-key)");
        BeanToPropertyValueTransformerTestCase.assertEquals(null, (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithNestedIndexedProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("anotherNested.intIndexed[0]");
        TestBean testBean = new TestBean();
        TestBean nestedBean = new TestBean();
        nestedBean.setIntIndexed(0, expectedIntegerValue);
        testBean.setAnotherNested(nestedBean);
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)expectedIntegerValue, (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithNestedProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("anotherNested.stringProperty");
        TestBean testBean = new TestBean();
        TestBean nestedBean = new TestBean("foo");
        testBean.setAnotherNested(nestedBean);
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)"foo", (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithNullInPath() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("anotherNested.stringProperty");
        try {
            transformer.transform((Object)new TestBean());
            BeanToPropertyValueTransformerTestCase.fail((String)"Should have throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTransformWithNullInPathAndIgnoreTrue() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("anotherNested.stringProperty", true);
        BeanToPropertyValueTransformerTestCase.assertEquals(null, (Object)transformer.transform((Object)new TestBean()));
    }

    public void testTransformWithReadOnlyProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("readOnlyProperty");
        TestBean testBean = new TestBean();
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)testBean.getReadOnlyProperty(), (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithSimpleBooleanProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("booleanProperty");
        TestBean testBean = new TestBean((boolean)expectedBooleanValue);
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)expectedBooleanValue, (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithSimpleByteProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("byteProperty");
        TestBean testBean = new TestBean();
        testBean.setByteProperty(expectedByteValue);
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)expectedByteValue, (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithSimpleDoubleProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("doubleProperty");
        TestBean testBean = new TestBean(expectedDoubleValue);
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)expectedDoubleValue, (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithSimpleFloatProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("floatProperty");
        TestBean testBean = new TestBean(expectedFloatValue.floatValue());
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)expectedFloatValue, (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithSimpleIntProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("intProperty");
        TestBean testBean = new TestBean((int)expectedIntegerValue);
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)expectedIntegerValue, (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithSimpleLongProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("longProperty");
        TestBean testBean = new TestBean();
        testBean.setLongProperty(expectedLongValue);
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)expectedLongValue, (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithSimpleStringProperty() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("stringProperty");
        TestBean testBean = new TestBean("foo");
        BeanToPropertyValueTransformerTestCase.assertEquals((Object)"foo", (Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithSimpleStringPropertyAndNullValue() {
        BeanToPropertyValueTransformer transformer = new BeanToPropertyValueTransformer("stringProperty");
        TestBean testBean = new TestBean((String)null);
        BeanToPropertyValueTransformerTestCase.assertNull((Object)transformer.transform((Object)testBean));
    }

    public void testTransformWithWriteOnlyProperty() {
        try {
            new BeanToPropertyValueTransformer("writeOnlyProperty").transform((Object)new TestBean());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

