/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.template.directive.Directive;

public class Context {
    private final StringBuilder builder;
    private final Map<String, ?> objects;
    private final Map<String, String> parameterAliases;
    private final Map<String, Directive> directives;
    private List<ParameterBinding> parameterBindings;
    private List<ColumnDescriptor> columnDescriptors;
    private int counter;

    public Context(Map<String, Directive> directives, Map<String, ?> parameters, boolean positionalMode) {
        this.directives = directives;
        this.objects = parameters;
        this.builder = new StringBuilder();
        this.parameterAliases = positionalMode ? new HashMap<String, String>() : null;
    }

    public Directive getDirective(String name) {
        return this.directives.get(name);
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    public String buildTemplate() {
        if (this.parameterAliases != null && this.counter < this.objects.size() - 1) {
            throw new CayenneRuntimeException("Too many parameters to bind template: " + (this.objects.size() - 1), new Object[0]);
        }
        return this.builder.toString();
    }

    public boolean haveObject(String name) {
        return this.objects.containsKey(name);
    }

    public Object getObject(String name) {
        Object object = this.objects.get(name);
        if (object != null) {
            return object;
        }
        if (this.parameterAliases != null) {
            String alias = this.parameterAliases.get(name);
            if (alias == null) {
                if (this.counter > this.objects.size() - 2) {
                    throw new CayenneRuntimeException("Too few parameters to bind template: " + (this.objects.size() - 1), new Object[0]);
                }
                alias = String.valueOf(this.counter++);
                this.parameterAliases.put(name, alias);
            }
            return this.objects.get(alias);
        }
        return null;
    }

    public void addParameterBinding(ParameterBinding binding) {
        if (this.parameterBindings == null) {
            this.parameterBindings = new ArrayList<ParameterBinding>();
        }
        this.parameterBindings.add(binding);
    }

    public void addColumnDescriptor(ColumnDescriptor descriptor) {
        if (this.columnDescriptors == null) {
            this.columnDescriptors = new ArrayList<ColumnDescriptor>();
        }
        this.columnDescriptors.add(descriptor);
    }

    public ColumnDescriptor[] getColumnDescriptors() {
        if (this.columnDescriptors == null) {
            return new ColumnDescriptor[0];
        }
        return this.columnDescriptors.toArray(new ColumnDescriptor[this.columnDescriptors.size()]);
    }

    public ParameterBinding[] getParameterBindings() {
        if (this.parameterBindings == null) {
            return new ParameterBinding[0];
        }
        return this.parameterBindings.toArray(new ParameterBinding[this.parameterBindings.size()]);
    }
}

