/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.validation.extension;

import java.util.EnumSet;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.xml.sax.Attributes;

public class ValidationConfigHandler
extends NamespaceAwareNestedTagHandler {
    static final String CONFIG_TAG = "validation";
    static final String EXCLUDE_TAG = "exclude";
    private final DataChannelMetaData metaData;
    private final EnumSet<Inspection> disabledInspections;

    ValidationConfigHandler(NamespaceAwareNestedTagHandler parentHandler, DataChannelMetaData metaData) {
        super(parentHandler);
        this.metaData = metaData;
        this.targetNamespace = "http://cayenne.apache.org/schema/11/validation";
        this.disabledInspections = EnumSet.noneOf(Inspection.class);
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) {
        if (CONFIG_TAG.equals(localName)) {
            this.disabledInspections.clear();
            return true;
        }
        return false;
    }

    @Override
    protected boolean processCharData(String localName, String data) {
        if (localName.equals(EXCLUDE_TAG)) {
            this.disabledInspections.add(Inspection.valueOf(data));
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (CONFIG_TAG.equals(localName)) {
            this.createConfig();
        }
    }

    private void createConfig() {
        EnumSet<Inspection> enabledInspections = EnumSet.complementOf(this.disabledInspections);
        this.loaderContext.addDataChannelListener(dataChannel -> this.metaData.add(dataChannel, new ValidationConfig(enabledInspections)));
    }
}

