/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.gen.CgenConfigList;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClassGenerationActionFactory;
import org.apache.cayenne.gen.internal.Utils;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EmbeddableListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.editor.DbImportController;
import org.apache.cayenne.modeler.editor.cgen.CgenArtefactSelectorController;
import org.apache.cayenne.modeler.editor.cgen.CgenConfigController;
import org.apache.cayenne.modeler.editor.cgen.CgenPane;
import org.apache.cayenne.modeler.editor.cgen.SelectionModel;
import org.apache.cayenne.modeler.event.ProjectSavedEvent;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.tools.ToolsInjectorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgenController
extends CayenneController
implements ObjEntityListener,
EmbeddableListener,
DataMapListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorDebugDialog.class);
    protected final ProjectController projectController;
    protected final Set<ConfigurationNode> classes;
    protected final SelectionModel selectionModel;
    protected final CgenPane view;
    protected CgenArtefactSelectorController classesSelector;
    private final CgenConfigController cgenConfigController;
    private CgenConfigList cgenConfigList;
    private Object currentClass;
    private CgenConfiguration cgenConfiguration;
    private DataMap dataMap;
    private boolean initFromModel;
    private final Predicate<ConfigurationNode> defaultPredicate = o -> o.acceptVisitor(new BaseConfigurationNodeVisitor<Boolean>(){

        @Override
        public Boolean visitDataMap(DataMap dataMap) {
            return false;
        }

        @Override
        public Boolean visitObjEntity(ObjEntity entity) {
            return CgenController.this.classesSelector.getProblem(entity.getName()) == null;
        }

        @Override
        public Boolean visitEmbeddable(Embeddable embeddable) {
            return CgenController.this.classesSelector.getProblem(embeddable.getClassName()) == null;
        }
    });
    private static final ConfigurationNodeVisitor<Integer> TYPE_GETTER = new BaseConfigurationNodeVisitor<Integer>(){

        @Override
        public Integer visitDataMap(DataMap dataMap) {
            return 10;
        }

        @Override
        public Integer visitObjEntity(ObjEntity entity) {
            return 20;
        }

        @Override
        public Integer visitEmbeddable(Embeddable embeddable) {
            return 30;
        }
    };
    private static final ConfigurationNodeVisitor<String> NAME_GETTER = new BaseConfigurationNodeVisitor<String>(){

        @Override
        public String visitDataMap(DataMap dataMap) {
            return dataMap.getName();
        }

        @Override
        public String visitEmbeddable(Embeddable embeddable) {
            return embeddable.getClassName();
        }

        @Override
        public String visitObjEntity(ObjEntity entity) {
            return entity.getName();
        }
    };

    public CgenController(ProjectController projectController) {
        super(projectController);
        this.cgenConfigController = new CgenConfigController(this);
        this.classesSelector = new CgenArtefactSelectorController(this);
        this.view = new CgenPane(this.cgenConfigController.getView(), this.classesSelector.getView());
        this.projectController = projectController;
        this.classes = new TreeSet<ConfigurationNode>(Comparator.comparing(o -> o.acceptVisitor(TYPE_GETTER)).thenComparing(o -> o.acceptVisitor(NAME_GETTER)));
        this.selectionModel = new SelectionModel();
        this.initBindings();
        this.initListeners();
    }

    private void initConfigurationsComboBox() {
        this.view.getConfigurationsComboBox().removeAllItems();
        this.cgenConfigList.getNames().forEach(n -> this.view.getConfigurationsComboBox().addItem((String)n));
    }

    public void initFromModel() {
        this.initFromModel = true;
        this.dataMap = this.projectController.getCurrentDataMap();
        this.prepareClasses(this.dataMap);
        this.initCgenConfigurations();
        this.initConfigurationsComboBox();
        this.setConfiguration((String)this.view.getConfigurationsComboBox().getSelectedItem());
        this.cgenConfigController.initForm(this.cgenConfiguration);
        this.addConfigurationComboBoxListener();
        this.classesSelector.startup();
        this.initFromModel = false;
        this.classesSelector.validate(this.classes);
    }

    private void addConfigurationComboBoxListener() {
        this.view.getConfigurationsComboBox().addActionListener(e -> {
            this.selectionModel.clearAll();
            this.setConfiguration((String)this.view.getConfigurationsComboBox().getSelectedItem());
            this.cgenConfigController.initForm(this.cgenConfiguration);
            this.classesSelector.initBindings();
            this.classesSelector.validate(this.classes);
        });
    }

    private void initCgenConfigurations() {
        this.cgenConfigList = this.projectController.getApplication().getMetaData().get(this.dataMap, CgenConfigList.class);
        if (this.cgenConfigList == null) {
            this.cgenConfigList = new CgenConfigList();
            this.cgenConfigList.add(this.createDefaultCgenConfiguration(this.dataMap));
            this.projectController.getApplication().getMetaData().add(this.dataMap, this.cgenConfigList);
        }
    }

    private void initListeners() {
        this.projectController.addObjEntityListener(this);
        this.projectController.addEmbeddableListener(this);
        this.projectController.addDataMapListener(this);
        this.projectController.addProjectSavedListener(this::onProjectSaved);
    }

    @Override
    public CgenPane getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getGenerateButton(), "generateAction()");
        builder.bindToAction(this.view.getAddConfigBtn(), "addConfigAction()");
        builder.bindToAction(this.view.getEditConfigBtn(), "editConfigAction()");
        builder.bindToAction(this.view.getRemoveConfigBtn(), "removeConfigAction()");
        this.generatorSelectedAction();
    }

    public void generatorSelectedAction() {
        this.classesSelector.validate(this.classes);
        this.updateSelection(this.defaultPredicate);
        this.classesSelector.classSelectedAction();
    }

    public void generateAction() {
        ClassGenerationAction generator = new ToolsInjectorBuilder().addModule(binder -> binder.bind(DataChannelMetaData.class).toInstance(this.projectController.getApplication().getMetaData())).create().getInstance(ClassGenerationActionFactory.class).createAction(this.cgenConfiguration);
        try {
            generator.prepareArtifacts();
            generator.execute();
            JOptionPane.showMessageDialog(this.getView(), "Class generation finished");
        }
        catch (CayenneRuntimeException e) {
            LOGGER.error("Error generating classes", e);
            JOptionPane.showMessageDialog(this.getView(), "Error generating classes - " + e.getUnlabeledMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error generating classes", e);
            JOptionPane.showMessageDialog(this.getView(), "Error generating classes - " + e.getMessage());
        }
    }

    public void addConfigAction() {
        String name = JOptionPane.showInputDialog(this.view, "Type the name for new cgenConfiguration", this.view.getConfigurationsComboBox().getSelectedItem());
        CgenConfiguration configuration = this.createDefaultCgenConfiguration(this.dataMap);
        if (name != null) {
            if (configuration != null && !this.cgenConfigList.isExist(name) && !name.isEmpty()) {
                configuration.setName(name);
                this.cgenConfigList.add(configuration);
                this.view.getConfigurationsComboBox().addItem(name);
                this.view.getConfigurationsComboBox().setSelectedItem(name);
            } else {
                JOptionPane.showMessageDialog(this.getView(), "Can't create new configuration, same name is already exist or empty");
            }
        }
    }

    public void editConfigAction() {
        String name = JOptionPane.showInputDialog(this.view, "Type the new name for cgenConfiguration", this.view.getConfigurationsComboBox().getSelectedItem());
        if (name != null) {
            if (!this.cgenConfigList.isExist(name) && !name.isEmpty()) {
                this.cgenConfiguration.setName(name);
                this.view.getConfigurationsComboBox().removeItem(this.view.getConfigurationsComboBox().getSelectedItem());
                this.view.getConfigurationsComboBox().addItem(name);
                this.view.getConfigurationsComboBox().setSelectedItem(name);
            } else {
                JOptionPane.showMessageDialog(this.getView(), "Can't rename configuration, name is already exist or empty");
            }
        }
    }

    public void removeConfigAction() {
        int result = JOptionPane.showConfirmDialog(this.view, "Configuration will be remove\n               Are you sure?", "Delete cgenConfiguration", 0);
        if (result == 0) {
            if (this.view.getConfigurationsComboBox().getItemCount() > 1) {
                this.cgenConfigList.removeByName(this.cgenConfiguration.getName());
                this.view.getConfigurationsComboBox().removeItem(this.view.getConfigurationsComboBox().getSelectedItem());
                this.view.getConfigurationsComboBox().setSelectedIndex(0);
            } else {
                JOptionPane.showMessageDialog(this.getView(), "At least one configuration must exist");
            }
        }
    }

    public void updateGenerateButton() {
        boolean isOutputPathValid = this.cgenConfigController.getView().isDataValid();
        this.view.getGenerateButton().setEnabled(!this.selectionModel.isModelEmpty() && isOutputPathValid);
    }

    private void prepareClasses(DataMap dataMap) {
        this.classes.clear();
        this.classes.add(dataMap);
        this.classes.addAll(dataMap.getObjEntities());
        this.classes.addAll(dataMap.getEmbeddables());
        this.selectionModel.initCollectionsForSelection(dataMap);
    }

    public void setConfiguration(String selectedConfig) {
        this.cgenConfiguration = this.cgenConfigList.getByName(selectedConfig);
        if (this.cgenConfiguration != null) {
            this.addToSelectedEntities(this.cgenConfiguration.getEntities());
            this.addToSelectedEmbeddables(this.cgenConfiguration.getEmbeddables());
            this.cgenConfiguration.setForce(true);
            return;
        }
        this.cgenConfiguration = this.createDefaultCgenConfiguration(this.dataMap);
        this.addToSelectedEntities(this.dataMap.getObjEntities().stream().map(Entity::getName).collect(Collectors.toList()));
        this.addToSelectedEmbeddables(this.dataMap.getEmbeddables().stream().map(Embeddable::getClassName).collect(Collectors.toList()));
    }

    private CgenConfiguration createDefaultCgenConfiguration(DataMap map) {
        Preferences preferences;
        CgenConfiguration configuration = new CgenConfiguration();
        configuration.setName("Default");
        configuration.setForce(true);
        configuration.setDataMap(map);
        map.getObjEntities().forEach(configuration::loadEntity);
        map.getEmbeddables().forEach(configuration::loadEmbeddable);
        if (map.getLocation() != null) {
            Path basePath = Paths.get(ModelerUtil.initOutputFolder(), new String[0]);
            configuration.setRootPath(Utils.getRootPathForDataMap(this.dataMap));
            configuration.updateOutputPath(basePath);
        }
        if ((preferences = this.application.getPreferencesNode(GeneralPreferences.class, "")) != null) {
            configuration.setEncoding(preferences.get("encoding", null));
        }
        return configuration;
    }

    public Set<?> getClasses() {
        return this.classes;
    }

    public boolean updateSelection(Predicate<ConfigurationNode> predicate) {
        boolean modified = this.selectionModel.updateSelection(predicate, this.classes);
        for (ConfigurationNode classObj : this.classes) {
            if (!(classObj instanceof DataMap)) continue;
            boolean selected = predicate.test(classObj);
            this.updateArtifactGenerationMode(selected);
        }
        return modified;
    }

    private void updateArtifactGenerationMode(boolean selected) {
        if (selected) {
            this.cgenConfiguration.setArtifactsGenerationMode("all");
        } else {
            this.cgenConfiguration.setArtifactsGenerationMode("entity");
        }
        this.checkCgenConfigDirty();
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected(this.currentClass);
    }

    public void setSelected(boolean selectedFlag) {
        if (this.currentClass instanceof DataMap) {
            this.updateArtifactGenerationMode(selectedFlag);
        }
        this.selectionModel.setSelected(this.currentClass, selectedFlag);
    }

    public void setCurrentClass(Object currentClass) {
        this.currentClass = currentClass;
    }

    public void updateSelectedEntities() {
        this.updateEntities();
        this.updateEmbeddables();
    }

    public void checkCgenConfigDirty() {
        if (this.initFromModel || this.cgenConfiguration == null) {
            return;
        }
        DataMap map = this.projectController.getCurrentDataMap();
        CgenConfigList existingConfigurations = this.projectController.getApplication().getMetaData().get(map, CgenConfigList.class);
        if (existingConfigurations == null) {
            this.cgenConfigList.add(this.cgenConfiguration);
            this.getApplication().getMetaData().add(map, this.cgenConfigList);
        }
        this.projectController.setDirty(true);
    }

    private void updateEntities() {
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.getEntities().clear();
            for (ObjEntity entity : this.selectionModel.getSelectedEntities(this.classes)) {
                this.cgenConfiguration.loadEntity(entity);
            }
        }
        this.checkCgenConfigDirty();
    }

    private void updateEmbeddables() {
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.getEmbeddables().clear();
            for (Embeddable embeddable : this.selectionModel.getSelectedEmbeddables(this.classes)) {
                this.cgenConfiguration.loadEmbeddable(embeddable);
            }
        }
        this.checkCgenConfigDirty();
    }

    private void addToSelectedEntities(Collection<String> entities) {
        this.selectionModel.addSelectedEntities(entities);
        this.updateEntities();
    }

    void addEntity(DataMap dataMap, ObjEntity objEntity) {
        this.prepareClasses(dataMap);
        this.selectionModel.addSelectedEntity(objEntity.getName());
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.loadEntity(objEntity);
        }
        this.checkCgenConfigDirty();
    }

    private void addToSelectedEmbeddables(Collection<String> embeddables) {
        this.selectionModel.addSelectedEmbeddables(embeddables);
        this.updateEmbeddables();
    }

    public int getSelectedEntitiesSize() {
        return this.selectionModel.getSelectedEntitiesCount();
    }

    public boolean isEntitiesSelected() {
        return this.selectionModel.getSelectedEntitiesCount() > 0;
    }

    public boolean isEmbeddableSelected() {
        return this.selectionModel.getSelecetedEmbeddablesCount() > 0;
    }

    public int getSelectedEmbeddablesSize() {
        return this.selectionModel.getSelecetedEmbeddablesCount();
    }

    public boolean isDataMapSelected() {
        return this.selectionModel.getSelectedDataMapsCount() > 0;
    }

    public ProjectController getProjectController() {
        return this.projectController;
    }

    public boolean isInitFromModel() {
        return this.initFromModel;
    }

    public void setInitFromModel(boolean initFromModel) {
        this.initFromModel = initFromModel;
    }

    public CgenConfigController getStandardModeController() {
        return this.cgenConfigController;
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
        this.addEntity(e.getEntity().getDataMap(), (ObjEntity)e.getEntity());
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
        this.selectionModel.removeFromSelectedEntities((ObjEntity)e.getEntity());
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.getEntities().remove(e.getEntity().getName());
        }
        this.checkCgenConfigDirty();
    }

    @Override
    public void embeddableChanged(EmbeddableEvent e, DataMap map) {
    }

    @Override
    public void embeddableAdded(EmbeddableEvent e, DataMap map) {
        this.prepareClasses(map);
        Embeddable embeddable = e.getEmbeddable();
        this.selectionModel.addSelectedEmbeddable(embeddable.getClassName());
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.loadEmbeddable(embeddable);
        }
        this.checkCgenConfigDirty();
    }

    @Override
    public void embeddableRemoved(EmbeddableEvent e, DataMap map) {
        this.selectionModel.removeFromSelectedEmbeddables(e.getEmbeddable());
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.getEmbeddables().remove(e.getEmbeddable().getClassName());
        }
        this.checkCgenConfigDirty();
    }

    @Override
    public void dataMapChanged(DataMapEvent e) {
        if (e.getSource() instanceof DbImportController) {
            if (this.cgenConfiguration != null) {
                for (ObjEntity objEntity : e.getDataMap().getObjEntities()) {
                    if (this.cgenConfiguration.getExcludedEntityArtifacts().contains(objEntity.getName())) continue;
                    this.addEntity(this.cgenConfiguration.getDataMap(), objEntity);
                }
            }
            this.checkCgenConfigDirty();
        }
    }

    @Override
    public void dataMapAdded(DataMapEvent e) {
    }

    @Override
    public void dataMapRemoved(DataMapEvent e) {
    }

    public CgenConfiguration getCgenConfiguration() {
        return this.cgenConfiguration;
    }

    public void onProjectSaved(ProjectSavedEvent e) {
        if (this.getStandardModeController() != null && this.getStandardModeController().getView() != null && this.cgenConfiguration != null) {
            this.getStandardModeController().getView().getOutputFolder().setText(this.cgenConfiguration.buildOutputPath().toString());
        }
    }
}

