/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DeleteRule;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.util.Util;

public class ObjRelationshipTableModel
extends CayenneTableModel<ObjRelationship> {
    public static final int REL_NAME = 0;
    public static final int REL_TARGET = 1;
    public static final int REL_TARGET_PATH = 2;
    public static final int REL_SEMANTICS = 3;
    public static final int REL_DELETE_RULE = 4;
    public static final int REL_LOCKING = 5;
    public static final int REL_COMMENT = 6;
    public static final int COLUMN_COUNT = 7;
    private final ObjEntity entity;

    public ObjRelationshipTableModel(ObjEntity entity, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, new ArrayList<ObjRelationship>(entity.getRelationships()));
        this.entity = entity;
        this.objectList.sort(new RelationshipComparator());
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    @Override
    public Class<ObjRelationship> getElementsClass() {
        return ObjRelationship.class;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Target";
            }
            case 5: {
                return "Used for Locking";
            }
            case 3: {
                return "Semantics";
            }
            case 4: {
                return "Delete Rule";
            }
            case 2: {
                return "DbRelationship Path";
            }
            case 6: {
                return "Comment";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 1: {
                return ObjEntity.class;
            }
            case 5: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public ObjRelationship getRelationship(int row) {
        return row >= 0 && row < this.objectList.size() ? (ObjRelationship)this.objectList.get(row) : null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        ObjRelationship relationship = this.getRelationship(row);
        switch (column) {
            case 0: {
                return relationship.getName();
            }
            case 1: {
                return relationship.getTargetEntity();
            }
            case 5: {
                return relationship.isUsedForLocking() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return ObjRelationshipTableModel.getSemantics(relationship);
            }
            case 4: {
                return DeleteRule.deleteRuleName(relationship.getDeleteRule());
            }
            case 2: {
                return relationship.getDbRelationshipPath();
            }
            case 6: {
                return this.getComment(relationship);
            }
        }
        return null;
    }

    private static String getSemantics(ObjRelationship relationship) {
        StringBuilder semantics = new StringBuilder(20);
        semantics.append(relationship.isToMany() ? "to many" : "to one");
        if (relationship.isReadOnly()) {
            semantics.append(", read-only");
        }
        if (relationship.isToMany()) {
            String collection = "list";
            if (relationship.getCollectionType() != null) {
                int dot = relationship.getCollectionType().lastIndexOf(46);
                collection = relationship.getCollectionType().substring(dot + 1).toLowerCase();
            }
            semantics.append(", ").append(collection);
        }
        return semantics.toString();
    }

    @Override
    public void setUpdatedValueAt(Object value, int row, int column) {
        ObjRelationship relationship = this.getRelationship(row);
        RelationshipEvent event = new RelationshipEvent(this.eventSource, relationship, this.entity);
        switch (column) {
            case 0: {
                String text = (String)value;
                event.setOldName(relationship.getName());
                ProjectUtil.setRelationshipName(this.entity, relationship, text);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 1: {
                ObjEntity target = (ObjEntity)value;
                relationship.setTargetEntityName(target);
                relationship.clearDbRelationships();
                if (target != null) {
                    DbRelationship anyConnector;
                    DbEntity srcDB = relationship.getSourceEntity().getDbEntity();
                    DbEntity targetDB = target.getDbEntity();
                    if (srcDB != null && targetDB != null && (anyConnector = (DbRelationship)srcDB.getAnyRelationship(targetDB)) != null) {
                        relationship.addDbRelationship(anyConnector);
                    }
                }
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 4: {
                relationship.setDeleteRule(DeleteRule.deleteRuleForName((String)value));
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 5: {
                relationship.setUsedForLocking(value instanceof Boolean && (Boolean)value != false);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 2: {
                relationship.setDbRelationshipPath((String)value);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 6: {
                this.setComment((String)value, relationship);
                this.fireTableRowsUpdated(row, row);
            }
        }
        this.mediator.fireObjRelationshipEvent(event);
    }

    @Override
    public void removeRow(int row) {
        if (row < 0) {
            return;
        }
        ObjRelationship rel = this.getRelationship(row);
        RelationshipEvent e = new RelationshipEvent(this.eventSource, rel, this.entity, 3);
        this.mediator.fireObjRelationshipEvent(e);
        this.objectList.remove(row);
        this.entity.removeRelationship(rel.getName());
        this.fireTableRowsDeleted(row, row);
    }

    private boolean isInherited(int row) {
        ObjRelationship relationship = this.getRelationship(row);
        return relationship != null && relationship.getSourceEntity() != this.entity;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return !this.isInherited(row) && col != 3 && col != 1;
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return true;
    }

    @Override
    public void sortByColumn(int sortCol, boolean isAscent) {
        switch (sortCol) {
            case 0: {
                this.sortByElementProperty("name", isAscent);
                break;
            }
            case 1: {
                this.sortByElementProperty("targetEntityName", isAscent);
                break;
            }
            case 5: {
                this.sortByElementProperty("usedForLocking", isAscent);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.objectList.sort(new ObjRelationshipTableComparator(sortCol));
                if (isAscent) break;
                Collections.reverse(this.objectList);
                break;
            }
        }
    }

    private static int compareColumnsData(String value1, String value2) {
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        return value1.compareTo(value2);
    }

    private String getComment(ObjRelationship rel) {
        return ObjectInfo.getFromMetaData(this.mediator.getApplication().getMetaData(), rel, "comment");
    }

    private void setComment(String newVal, ObjRelationship rel) {
        ObjectInfo.putToMetaData(this.mediator.getApplication().getMetaData(), rel, "comment", newVal);
    }

    final class RelationshipComparator
    implements Comparator<ObjRelationship> {
        RelationshipComparator() {
        }

        @Override
        public int compare(ObjRelationship o1, ObjRelationship o2) {
            int delta = this.getWeight(o1) - this.getWeight(o2);
            return delta != 0 ? delta : Util.nullSafeCompare(true, o1.getName(), o2.getName());
        }

        private int getWeight(ObjRelationship r) {
            return r.getSourceEntity() == ObjRelationshipTableModel.this.entity ? 1 : -1;
        }
    }

    private static class ObjRelationshipTableComparator
    implements Comparator<ObjRelationship> {
        private final int sortCol;

        ObjRelationshipTableComparator(int sortCol) {
            this.sortCol = sortCol;
        }

        @Override
        public int compare(ObjRelationship o1, ObjRelationship o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            switch (this.sortCol) {
                case 3: {
                    return ObjRelationshipTableModel.compareColumnsData(ObjRelationshipTableModel.getSemantics(o1), ObjRelationshipTableModel.getSemantics(o2));
                }
                case 4: {
                    return ObjRelationshipTableModel.compareColumnsData(DeleteRule.deleteRuleName(o1.getDeleteRule()), DeleteRule.deleteRuleName(o2.getDeleteRule()));
                }
                case 2: {
                    return ObjRelationshipTableModel.compareColumnsData(o1.getDbRelationshipPath().value(), o2.getDbRelationshipPath().value());
                }
            }
            return ObjRelationshipTableModel.compareColumnsData("", "");
        }
    }
}

