/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.components.TopBorder;

public class LogConsoleView
extends JPanel {
    private static final Icon DOCK_ICON = ModelerUtil.buildIcon("icon-down.png");
    private static final Icon UNDOCK_ICON = ModelerUtil.buildIcon("icon-up.png");
    private JTextComponent logView;
    private JButton clearItem;
    private JButton copyItem;
    private JButton dockItem;
    private JToolBar buttonsBar;

    public LogConsoleView() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.buttonsBar = new JToolBar();
        this.buttonsBar.setBorder(BorderFactory.createEmptyBorder());
        this.buttonsBar.setFloatable(false);
        this.copyItem = new CayenneAction.CayenneToolbarButton(null, 0);
        this.copyItem.setIcon(ModelerUtil.buildIcon("icon-copy.png"));
        this.copyItem.setText("Copy");
        this.buttonsBar.add(this.copyItem);
        this.clearItem = new CayenneAction.CayenneToolbarButton(null, 0);
        this.clearItem.setIcon(ModelerUtil.buildIcon("icon-trash.png"));
        this.clearItem.setText("Clear");
        this.buttonsBar.add(this.clearItem);
        this.dockItem = new CayenneAction.CayenneToolbarButton(null, 0);
        this.setDocked(false);
        this.buttonsBar.add(this.dockItem);
        this.add((Component)this.buttonsBar, "North");
        this.logView = new JEditorPane("text/html", "");
        this.logView.setFont(new JLabel().getFont().deriveFont(12.0f));
        this.logView.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.logView);
        scrollPane.setBorder(TopBorder.create());
        this.add((Component)scrollPane, "Center");
        this.setLocation(100, 100);
    }

    JTextComponent getLogView() {
        return this.logView;
    }

    JButton getCopyItem() {
        return this.copyItem;
    }

    JButton getClearItem() {
        return this.clearItem;
    }

    JButton getDockItem() {
        return this.dockItem;
    }

    void setDocked(boolean isDocked) {
        if (isDocked) {
            this.dockItem.setIcon(UNDOCK_ICON);
            this.dockItem.setText("Undock");
            this.buttonsBar.setBorder(TopBorder.create());
        } else {
            this.dockItem.setIcon(DOCK_ICON);
            this.dockItem.setText("Dock");
            this.buttonsBar.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

