/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.TreeDropTarget;

public class TreeDragSource
implements DragSourceListener,
DragGestureListener {
    private DragSource source;
    private JTree sourceTree;
    private ProjectController eventController;
    private DragGestureRecognizer recognizer;
    private TreeDropTarget dt;

    public TreeDragSource(JTree tree, int actions, ProjectController eventController) {
        this.sourceTree = tree;
        this.eventController = eventController;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return;
        }
        this.dt = new TreeDropTarget(this.sourceTree, this.eventController, path);
        this.source.startDrag(dge, DragSource.DefaultLinkDrop, this.dt, this);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        TreePath sourcePath = this.sourceTree.getSelectionPath();
        DefaultMutableTreeNode sourceParent = (DefaultMutableTreeNode)sourcePath.getLastPathComponent();
        TreePath path = this.dt.getPath();
        if (path == null) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultLinkNoDrop);
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (sourceParent.getUserObject() instanceof DataMap && parent.getUserObject() instanceof DataNodeDescriptor) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultLinkDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultLinkNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }
}

