/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.gen.Artifact;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.CgenTemplate;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.cayenne.validation.ValidationException;

public class CgenConfiguration
implements Serializable,
XMLSerializable {
    private Path rootProjectPath;
    private Path cgenOutputPath;
    private Collection<Artifact> artifacts;
    private Set<String> entityArtifacts;
    private Collection<String> excludedEntityArtifacts;
    private Set<String> embeddableArtifacts;
    private Collection<String> excludedEmbeddableArtifacts;
    private String name = "Default";
    private String superPkg;
    private DataMap dataMap;
    private ArtifactsGenerationMode artifactsGenerationMode = ArtifactsGenerationMode.ENTITY;
    private boolean makePairs = true;
    private boolean overwrite;
    private boolean usePkgPath = true;
    private CgenTemplate template;
    private CgenTemplate superTemplate;
    private CgenTemplate embeddableTemplate;
    private CgenTemplate embeddableSuperTemplate;
    private CgenTemplate dataMapTemplate;
    private CgenTemplate dataMapSuperTemplate;
    private long timestamp = 0L;
    private String outputPattern = "*.java";
    private String encoding;
    private boolean createPropertyNames;
    private boolean force;
    private boolean createPKProperties = true;
    private String externalToolConfig;

    public CgenConfiguration() {
        this.artifacts = new ArrayList<Artifact>();
        this.entityArtifacts = new HashSet<String>();
        this.excludedEntityArtifacts = new ArrayList<String>();
        this.embeddableArtifacts = new HashSet<String>();
        this.excludedEmbeddableArtifacts = new ArrayList<String>();
        this.template = TemplateType.ENTITY_SUBCLASS.defaultTemplate();
        this.superTemplate = TemplateType.ENTITY_SUPERCLASS.defaultTemplate();
        this.dataMapTemplate = TemplateType.DATAMAP_SUBCLASS.defaultTemplate();
        this.dataMapSuperTemplate = TemplateType.DATAMAP_SUPERCLASS.defaultTemplate();
        this.embeddableTemplate = TemplateType.EMBEDDABLE_SUBCLASS.defaultTemplate();
        this.embeddableSuperTemplate = TemplateType.EMBEDDABLE_SUPERCLASS.defaultTemplate();
    }

    public void resetCollections() {
        this.embeddableArtifacts.clear();
        this.entityArtifacts.clear();
    }

    public String getSuperPkg() {
        return this.superPkg;
    }

    public void setSuperPkg(String superPkg) {
        this.superPkg = superPkg;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public void setArtifactsGenerationMode(String mode) {
        this.artifactsGenerationMode = ArtifactsGenerationMode.ENTITY.getLabel().equalsIgnoreCase(mode) ? ArtifactsGenerationMode.ENTITY : ArtifactsGenerationMode.ALL;
    }

    public String getArtifactsGenerationMode() {
        return this.artifactsGenerationMode.getLabel();
    }

    public boolean isMakePairs() {
        return this.makePairs;
    }

    public void setMakePairs(boolean makePairs) {
        this.makePairs = makePairs;
    }

    public Path getRootPath() {
        return this.rootProjectPath;
    }

    public void setRootPath(Path rootProjectPath) {
        if (!Objects.requireNonNull(rootProjectPath).isAbsolute()) {
            throw new ValidationException("Project root path '%s' should be absolute.", rootProjectPath);
        }
        this.rootProjectPath = rootProjectPath;
    }

    public Path getRawOutputPath() {
        return this.cgenOutputPath;
    }

    public void updateOutputPath(Path path) {
        if (this.rootProjectPath != null && path.isAbsolute() && this.rootProjectPath.getRoot().equals(path.getRoot())) {
            this.cgenOutputPath = this.rootProjectPath.relativize(path);
            return;
        }
        this.cgenOutputPath = path;
    }

    String getNormalizedOutputPath() {
        if (this.cgenOutputPath == null || this.cgenOutputPath.toString().isEmpty()) {
            return ".";
        }
        return this.cgenOutputPath.toString();
    }

    public Path buildOutputPath() {
        if (this.rootProjectPath == null) {
            return this.cgenOutputPath;
        }
        if (this.cgenOutputPath == null) {
            return null;
        }
        if (this.cgenOutputPath.isAbsolute()) {
            return this.cgenOutputPath.normalize();
        }
        return this.rootProjectPath.resolve(this.cgenOutputPath).toAbsolutePath().normalize();
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isUsePkgPath() {
        return this.usePkgPath;
    }

    public void setUsePkgPath(boolean usePkgPath) {
        this.usePkgPath = usePkgPath;
    }

    public CgenTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(CgenTemplate template) {
        this.template = template;
    }

    public CgenTemplate getSuperTemplate() {
        return this.superTemplate;
    }

    public void setSuperTemplate(CgenTemplate superTemplate) {
        this.superTemplate = superTemplate;
    }

    public CgenTemplate getEmbeddableTemplate() {
        return this.embeddableTemplate;
    }

    public void setEmbeddableTemplate(CgenTemplate embeddableTemplate) {
        this.embeddableTemplate = embeddableTemplate;
    }

    public CgenTemplate getEmbeddableSuperTemplate() {
        return this.embeddableSuperTemplate;
    }

    public void setEmbeddableSuperTemplate(CgenTemplate embeddableSuperTemplate) {
        this.embeddableSuperTemplate = embeddableSuperTemplate;
    }

    public CgenTemplate getDataMapTemplate() {
        return this.dataMapTemplate;
    }

    public void setDataMapTemplate(CgenTemplate dataMapTemplate) {
        this.dataMapTemplate = dataMapTemplate;
    }

    public CgenTemplate getDataMapSuperTemplate() {
        return this.dataMapSuperTemplate;
    }

    public void setDataMapSuperTemplate(CgenTemplate dataMapSuperTemplate) {
        this.dataMapSuperTemplate = dataMapSuperTemplate;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isCreatePropertyNames() {
        return this.createPropertyNames;
    }

    public void setCreatePropertyNames(boolean createPropertyNames) {
        this.createPropertyNames = createPropertyNames;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isCreatePKProperties() {
        return this.createPKProperties;
    }

    public void setCreatePKProperties(boolean createPKProperties) {
        this.createPKProperties = createPKProperties;
    }

    Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public Set<String> getEntities() {
        return this.entityArtifacts;
    }

    public Set<String> getEmbeddables() {
        return this.embeddableArtifacts;
    }

    public String getExternalToolConfig() {
        return this.externalToolConfig;
    }

    public void setExternalToolConfig(String config) {
        this.externalToolConfig = config;
    }

    void addArtifact(Artifact artifact) {
        this.artifacts.add(artifact);
    }

    public void loadEntity(ObjEntity entity) {
        if (!entity.isGeneric()) {
            this.entityArtifacts.add(entity.getName());
        }
    }

    public void loadEmbeddable(Embeddable embeddable) {
        this.embeddableArtifacts.add(embeddable.getClassName());
    }

    public void parseExcludedEntities(String entities) {
        this.excludedEntityArtifacts.addAll(Arrays.asList(entities.split(",")));
    }

    private String getExcludedEntities() {
        return this.dataMap.getObjEntities().stream().map(Entity::getName).filter(name -> !this.entityArtifacts.contains(name)).collect(Collectors.joining(","));
    }

    public void parseExcludedEmbeddables(String embeddables) {
        this.excludedEmbeddableArtifacts.addAll(Arrays.asList(embeddables.split(",")));
    }

    private String getExcludedEmbeddables() {
        return this.dataMap.getEmbeddables().stream().map(Embeddable::getClassName).filter(className -> !this.embeddableArtifacts.contains(className)).collect(Collectors.joining(","));
    }

    public void resolveExcludedEntities() {
        this.entityArtifacts = this.dataMap.getObjEntities().stream().map(Entity::getName).filter(name -> !this.excludedEntityArtifacts.contains(name)).collect(Collectors.toSet());
    }

    public void resolveExcludedEmbeddables() {
        this.embeddableArtifacts = this.dataMap.getEmbeddables().stream().map(Embeddable::getClassName).filter(className -> !this.excludedEmbeddableArtifacts.contains(className)).collect(Collectors.toSet());
    }

    public Collection<String> getExcludedEntityArtifacts() {
        return this.excludedEntityArtifacts;
    }

    public Collection<String> getExcludedEmbeddableArtifacts() {
        return this.excludedEmbeddableArtifacts;
    }

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("cgen").attribute("xmlns", "http://cayenne.apache.org/schema/11/cgen").simpleTag("name", this.name).simpleTag("excludeEntities", this.getExcludedEntities()).simpleTag("excludeEmbeddables", this.getExcludedEmbeddables()).simpleTag("destDir", this.separatorsToUnix(this.getNormalizedOutputPath())).simpleTag("mode", this.artifactsGenerationMode.getLabel()).start("template").cdata(this.template.getData(), !this.template.isFile()).end().start("superTemplate").cdata(this.superTemplate.getData(), !this.superTemplate.isFile()).end().start("embeddableTemplate").cdata(this.embeddableTemplate.getData(), !this.embeddableTemplate.isFile()).end().start("embeddableSuperTemplate").cdata(this.embeddableSuperTemplate.getData(), !this.embeddableSuperTemplate.isFile()).end().start("dataMapTemplate").cdata(this.dataMapTemplate.getData(), !this.dataMapTemplate.isFile()).end().start("dataMapSuperTemplate").cdata(this.dataMapSuperTemplate.getData(), !this.dataMapSuperTemplate.isFile()).end().simpleTag("outputPattern", this.outputPattern).simpleTag("makePairs", Boolean.toString(this.makePairs)).simpleTag("usePkgPath", Boolean.toString(this.usePkgPath)).simpleTag("overwrite", Boolean.toString(this.overwrite)).simpleTag("createPropertyNames", Boolean.toString(this.createPropertyNames)).simpleTag("superPkg", this.separatorsToUnix(this.superPkg)).simpleTag("createPKProperties", Boolean.toString(this.createPKProperties)).simpleTag("externalToolConfig", this.externalToolConfig).end();
    }

    public boolean isDefault() {
        return !(!this.makePairs || !this.usePkgPath || this.overwrite || !this.createPKProperties || this.createPropertyNames || !"*.java".equals(this.outputPattern) || !this.template.equals(TemplateType.ENTITY_SUBCLASS.defaultTemplate()) || !this.superTemplate.equals(TemplateType.ENTITY_SUPERCLASS.defaultTemplate()) || this.superPkg != null && !this.superPkg.isEmpty() || this.externalToolConfig != null && !this.externalToolConfig.isEmpty());
    }

    private String separatorsToUnix(String path) {
        if (path != null) {
            return path.replace('\\', '/');
        }
        return null;
    }

    public CgenTemplate getTemplateByType(TemplateType type) {
        switch (type) {
            case ENTITY_SINGLE_CLASS: 
            case ENTITY_SUBCLASS: {
                return this.getTemplate();
            }
            case ENTITY_SUPERCLASS: {
                return this.getSuperTemplate();
            }
            case EMBEDDABLE_SINGLE_CLASS: 
            case EMBEDDABLE_SUBCLASS: {
                return this.getEmbeddableTemplate();
            }
            case EMBEDDABLE_SUPERCLASS: {
                return this.getEmbeddableSuperTemplate();
            }
            case DATAMAP_SINGLE_CLASS: 
            case DATAMAP_SUBCLASS: {
                return this.getDataMapTemplate();
            }
            case DATAMAP_SUPERCLASS: {
                return this.getDataMapSuperTemplate();
            }
        }
        return null;
    }
}

