/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.Binding;
import org.apache.cayenne.di.spi.DICollectionBuilder;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.ListProvider;

class DefaultListBuilder<T>
extends DICollectionBuilder<List<T>, T>
implements ListBuilder<T> {
    protected static AtomicLong incrementer = new AtomicLong();

    DefaultListBuilder(Key<List<T>> bindingKey, DefaultInjector injector) {
        super(bindingKey, injector);
        this.findOrCreateListProvider();
    }

    @Override
    public ListBuilder<T> add(Class<? extends T> interfaceType) {
        Provider<? extends T> provider = this.createTypeProvider(interfaceType);
        this.findOrCreateListProvider().add(Key.get(interfaceType), provider);
        return this;
    }

    @Override
    public ListBuilder<T> addAfter(Class<? extends T> interfaceType, Class<? extends T> afterType) {
        Provider<? extends T> provider = this.createTypeProvider(interfaceType);
        this.findOrCreateListProvider().addAfter(Key.get(interfaceType), provider, Key.get(afterType));
        return this;
    }

    @Override
    public ListBuilder<T> insertBefore(Class<? extends T> interfaceType, Class<? extends T> beforeType) {
        Provider<? extends T> provider = this.createTypeProvider(interfaceType);
        this.findOrCreateListProvider().insertBefore(Key.get(interfaceType), provider, Key.get(beforeType));
        return this;
    }

    @Override
    public ListBuilder<T> add(T value) {
        Key<?> key = Key.get(value.getClass(), String.valueOf(incrementer.getAndIncrement()));
        this.findOrCreateListProvider().add(key, this.createInstanceProvider(value));
        return this;
    }

    @Override
    public ListBuilder<T> addAfter(T value, Class<? extends T> afterType) {
        Key<?> key = Key.get(value.getClass(), String.valueOf(incrementer.getAndIncrement()));
        this.findOrCreateListProvider().addAfter(key, this.createInstanceProvider(value), Key.get(afterType));
        return this;
    }

    @Override
    public ListBuilder<T> insertBefore(T value, Class<? extends T> beforeType) {
        Key<?> key = Key.get(value.getClass(), String.valueOf(incrementer.getAndIncrement()));
        this.findOrCreateListProvider().insertBefore(key, this.createInstanceProvider(value), Key.get(beforeType));
        return this;
    }

    @Override
    public ListBuilder<T> addAll(Collection<T> values) {
        this.findOrCreateListProvider().addAll(this.createProviderMap(values));
        return this;
    }

    @Override
    public ListBuilder<T> addAllAfter(Collection<T> values, Class<? extends T> afterType) {
        this.findOrCreateListProvider().addAllAfter(this.createProviderMap(values), Key.get(afterType));
        return this;
    }

    @Override
    public ListBuilder<T> insertAllBefore(Collection<T> values, Class<? extends T> beforeType) {
        this.findOrCreateListProvider().insertAllBefore(this.createProviderMap(values), Key.get(beforeType));
        return this;
    }

    private Map<Key<? extends T>, Provider<? extends T>> createProviderMap(Collection<T> objects) {
        LinkedHashMap<Key<T>, Provider<T>> keyProviderMap = new LinkedHashMap<Key<T>, Provider<T>>();
        for (T object : objects) {
            Class<?> objectType = object.getClass();
            keyProviderMap.put(Key.get(objectType, String.valueOf(incrementer.getAndIncrement())), this.createInstanceProvider(object));
        }
        return keyProviderMap;
    }

    private ListProvider<T> findOrCreateListProvider() {
        ListProvider provider;
        Binding binding = this.injector.getBinding(this.bindingKey);
        if (binding == null) {
            provider = new ListProvider();
            this.injector.putBinding(this.bindingKey, provider);
        } else {
            provider = (ListProvider)binding.getOriginal();
        }
        return provider;
    }
}

