/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.access.translator.ejbql.EJBQLJoinAppender;
import org.apache.cayenne.access.translator.ejbql.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.translator.ejbql.EJBQLTableId;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.reflect.ClassDescriptor;

public abstract class EJBQLDbPathTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    protected DbEntity currentEntity;
    private String lastPathComponent;
    protected String lastAlias;
    protected String idPath;
    protected String joinMarker;
    private String fullPath;
    private boolean usingAliases;

    public EJBQLDbPathTranslator(EJBQLTranslationContext context) {
        super(true);
        this.context = context;
        this.usingAliases = true;
    }

    protected abstract void appendMultiColumnPath(EJBQLMultiColumnOperand var1);

    @Override
    public boolean visitDbPath(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex > 0) {
            if (finishedChildIndex + 1 < expression.getChildrenCount()) {
                this.processIntermediatePathComponent();
            } else {
                this.processLastPathComponent();
            }
        }
        return true;
    }

    @Override
    public boolean visitIdentifier(EJBQLExpression expression) {
        ClassDescriptor descriptor = this.context.getEntityDescriptor(expression.getText());
        if (descriptor == null) {
            throw new EJBQLException("Invalid identification variable: " + expression.getText(), new Object[0]);
        }
        this.currentEntity = descriptor.getEntity().getDbEntity();
        this.idPath = expression.getText();
        this.joinMarker = EJBQLJoinAppender.makeJoinTailMarker(this.idPath);
        this.fullPath = this.idPath;
        return true;
    }

    @Override
    public boolean visitIdentificationVariable(EJBQLExpression expression) {
        if (this.lastPathComponent != null) {
            this.resolveJoin(true);
        }
        this.lastPathComponent = expression.getText();
        return true;
    }

    private void resolveJoin(boolean inner) {
        EJBQLJoinAppender joinAppender = this.context.getTranslatorFactory().getJoinAppender(this.context);
        String newPath = this.idPath + "." + this.lastPathComponent;
        String oldPath = joinAppender.registerReusableJoin(this.idPath, this.lastPathComponent, newPath);
        this.fullPath = this.fullPath + "." + this.lastPathComponent;
        if (oldPath != null) {
            this.idPath = oldPath;
            this.lastAlias = this.context.getTableAlias(oldPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(this.currentEntity));
        } else {
            if (inner) {
                joinAppender.appendInnerJoin(this.joinMarker, new EJBQLTableId(this.idPath), new EJBQLTableId(this.fullPath));
                this.lastAlias = this.context.getTableAlias(this.fullPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(this.currentEntity));
            } else {
                joinAppender.appendOuterJoin(this.joinMarker, new EJBQLTableId(this.idPath), new EJBQLTableId(this.fullPath));
                Object lastRelationship = this.currentEntity.getRelationship(this.lastPathComponent);
                DbEntity targetEntity = (DbEntity)((Relationship)lastRelationship).getTargetEntity();
                this.lastAlias = this.context.getTableAlias(this.fullPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(targetEntity));
            }
            this.idPath = newPath;
        }
    }

    private void processIntermediatePathComponent() {
        DbRelationship relationship = (DbRelationship)this.currentEntity.getRelationship(this.lastPathComponent);
        if (relationship == null) {
            throw new EJBQLException("Unknown relationship '" + this.lastPathComponent + "' for entity '" + this.currentEntity.getName() + "'", new Object[0]);
        }
        this.currentEntity = relationship.getTargetEntity();
    }

    private void processLastPathComponent() {
        DbAttribute attribute = (DbAttribute)this.currentEntity.getAttribute(this.lastPathComponent);
        if (attribute != null) {
            this.processTerminatingAttribute(attribute);
            return;
        }
        DbRelationship relationship = (DbRelationship)this.currentEntity.getRelationship(this.lastPathComponent);
        if (relationship != null) {
            this.processTerminatingRelationship(relationship);
            return;
        }
        throw new IllegalStateException("Invalid path component: " + this.lastPathComponent);
    }

    protected void processTerminatingAttribute(DbAttribute attribute) {
        DbEntity table = attribute.getEntity();
        if (this.isUsingAliases()) {
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
            this.context.append(' ').append(alias).append('.').append(this.context.getQuotingStrategy().quotedName(attribute));
        } else {
            this.context.append(' ').append(this.context.getQuotingStrategy().quotedName(attribute));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processTerminatingRelationship(DbRelationship relationship) {
        if (relationship.isToMany()) {
            this.resolveJoin(false);
            DbEntity table = relationship.getTargetEntity();
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
            List<DbAttribute> pks = table.getPrimaryKeys();
            if (pks.size() != 1) throw new EJBQLException("Multi-column PK to-many matches are not yet supported.", new Object[0]);
            DbAttribute pk = (DbAttribute)pks.iterator().next();
            this.context.append(' ');
            if (this.isUsingAliases()) {
                this.context.append(alias).append('.');
            }
            this.context.append(this.context.getQuotingStrategy().quotedName(pk));
            return;
        } else {
            DbEntity table = (DbEntity)relationship.getSourceEntity();
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
            List<DbJoin> joins = relationship.getJoins();
            if (joins.size() == 1) {
                DbJoin join = joins.get(0);
                this.context.append(' ');
                if (this.isUsingAliases()) {
                    this.context.append(alias).append('.');
                }
                this.context.append(this.context.getQuotingStrategy().quotedName(join.getSource()));
                return;
            } else {
                HashMap<String, String> multiColumnMatch = new HashMap<String, String>(joins.size() + 2);
                for (DbJoin join : joins) {
                    String column = this.isUsingAliases() ? alias + "." + join.getSourceName() : join.getSourceName();
                    multiColumnMatch.put(join.getTargetName(), column);
                }
                this.appendMultiColumnPath(EJBQLMultiColumnOperand.getPathOperand(this.context, multiColumnMatch));
            }
        }
    }

    public boolean isUsingAliases() {
        return this.usingAliases;
    }

    public void setUsingAliases(boolean usingAliases) {
        this.usingAliases = usingAliases;
    }

    protected void resolveJoin() {
        EJBQLJoinAppender joinAppender = this.context.getTranslatorFactory().getJoinAppender(this.context);
        String newPath = this.idPath + "." + this.lastPathComponent;
        String oldPath = joinAppender.registerReusableJoin(this.idPath, this.lastPathComponent, newPath);
        this.fullPath = this.fullPath + "." + this.lastPathComponent;
        if (oldPath != null) {
            this.idPath = oldPath;
            DbRelationship lastRelationship = (DbRelationship)this.currentEntity.getRelationship(this.lastPathComponent);
            if (lastRelationship != null) {
                DbEntity targetEntity = lastRelationship.getTargetEntity();
                this.lastAlias = this.context.getTableAlias(this.fullPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(targetEntity));
            } else {
                String tableName = this.context.getQuotingStrategy().quotedFullyQualifiedName(this.currentEntity);
                this.lastAlias = this.context.getTableAlias(oldPath, tableName);
            }
        } else {
            DbRelationship lastRelationship = (DbRelationship)this.currentEntity.getRelationship(this.lastPathComponent);
            DbEntity targetEntity = null;
            targetEntity = lastRelationship != null ? lastRelationship.getTargetEntity() : this.currentEntity;
            joinAppender.appendInnerJoin(this.joinMarker, new EJBQLTableId(this.idPath), new EJBQLTableId(this.fullPath));
            this.lastAlias = this.context.getTableAlias(this.fullPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(targetEntity));
            this.idPath = newPath;
        }
    }
}

