/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cayenne.dbsync.reverse.filters.IncludeTableFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.util.Util;

public class TableFilter {
    private final List<IncludeTableFilter> includes;
    private final List<Pattern> excludes;

    public TableFilter(List<IncludeTableFilter> includes, List<Pattern> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean isIncludeTable(String tableName) {
        PatternFilter columnFilter = this.getIncludeTableColumnFilter(tableName);
        return columnFilter != null;
    }

    public PatternFilter getIncludeTableColumnFilter(String tableName) {
        IncludeTableFilter include = this.getIncludeTableFilter(tableName);
        if (include == null) {
            return null;
        }
        return include.columnsFilter;
    }

    public PatternFilter getIncludeTableRelationshipFilter(String tableName) {
        IncludeTableFilter include = this.getIncludeTableFilter(tableName);
        if (include == null) {
            return null;
        }
        return include.relationshipFilter;
    }

    private IncludeTableFilter getIncludeTableFilter(String tableName) {
        IncludeTableFilter include = null;
        for (IncludeTableFilter includeTableFilter : this.includes) {
            if (includeTableFilter.pattern != null && !includeTableFilter.pattern.matcher(tableName).matches()) continue;
            include = includeTableFilter;
            break;
        }
        if (include == null) {
            return null;
        }
        for (Pattern pattern : this.excludes) {
            if (pattern == null || !pattern.matcher(tableName).matches()) continue;
            return null;
        }
        return include;
    }

    public List<IncludeTableFilter> getIncludes() {
        return this.includes;
    }

    public List<Pattern> getExcludes() {
        return this.excludes;
    }

    public static TableFilter include(String tablePattern) {
        ArrayList<IncludeTableFilter> includes = new ArrayList<IncludeTableFilter>();
        includes.add(new IncludeTableFilter(tablePattern == null ? null : tablePattern.replaceAll("%", ".*")));
        return new TableFilter(includes, new ArrayList<Pattern>());
    }

    public static TableFilter everything() {
        ArrayList<IncludeTableFilter> includes = new ArrayList<IncludeTableFilter>();
        includes.add(new IncludeTableFilter(null));
        return new TableFilter(includes, new ArrayList<Pattern>());
    }

    protected StringBuilder toString(StringBuilder res, String prefix) {
        res.append(prefix).append("Tables: ").append("\n");
        for (IncludeTableFilter include : this.includes) {
            include.toString(res, prefix + "  ");
        }
        if (!this.excludes.isEmpty()) {
            res.append(prefix).append("  ").append(Util.join(this.excludes, (String)" OR ")).append("\n");
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableFilter)) {
            return false;
        }
        TableFilter that = (TableFilter)o;
        boolean excludeEquals = true;
        for (int i = 0; i < this.excludes.size(); ++i) {
            Pattern pattern = this.excludes.get(i);
            Pattern thatPattern = that.excludes.get(i);
            if (pattern.pattern().equals(thatPattern.pattern())) continue;
            excludeEquals = false;
            break;
        }
        return this.includes.equals(that.includes) && excludeEquals;
    }

    public int hashCode() {
        int result = this.includes.hashCode();
        result = 31 * result + this.excludes.hashCode();
        return result;
    }
}

