/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.ToStringBuilder;

public class EntityResult {
    protected String entityName;
    protected Class<?> entityClass;
    protected Collection<FieldResult> fields;

    public EntityResult(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public EntityResult(String entityName) {
        this.entityName = entityName;
    }

    public Map<String, String> getDbFields(EntityResolver resolver) {
        if (this.fields == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> dbFields = new HashMap<String, String>();
        for (FieldResult field : this.fields) {
            if (field.isDbAttribute() || field.getAttributeName().startsWith("fetch.")) {
                dbFields.put(field.getAttributeName(), field.getColumn());
                continue;
            }
            ObjEntity entity = field.getEntityName() != null ? resolver.getObjEntity(field.getEntityName()) : this.getRootEntity(resolver);
            ObjAttribute attribute = entity.getAttribute(field.getAttributeName());
            dbFields.put(attribute.getDbAttributePath().value(), field.getColumn());
        }
        return dbFields;
    }

    private ObjEntity getRootEntity(EntityResolver resolver) {
        if (this.entityName != null) {
            return resolver.getObjEntity(this.entityName);
        }
        if (this.entityClass != null) {
            return resolver.getObjEntity(this.entityClass);
        }
        throw new IllegalStateException("Both entity name and class are null");
    }

    public void addObjectField(String attributeName, String column) {
        this.addField(new FieldResult(null, attributeName, column, false));
    }

    public void addObjectField(String entityName, String attributeName, String column) {
        this.addField(new FieldResult(entityName, attributeName, column, false));
    }

    public void addDbField(String dbAttributeName, String column) {
        this.addField(new FieldResult(null, dbAttributeName, column, true));
    }

    void addField(FieldResult field) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldResult>();
        }
        this.fields.add(field);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    class FieldResult {
        protected String entityName;
        protected String attributeName;
        protected String column;
        protected boolean dbAttribute;

        FieldResult(String entityName, String attributeName, String column, boolean dbAttribute) {
            this.entityName = entityName;
            this.attributeName = attributeName;
            this.column = column;
            this.dbAttribute = dbAttribute;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getColumn() {
            return this.column;
        }

        public boolean isDbAttribute() {
            return this.dbAttribute;
        }

        public String toString() {
            return new ToStringBuilder(this).append("attributeName", this.attributeName).append("column", this.column).append("db", this.dbAttribute).toString();
        }
    }
}

