/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.io.InputStream;
import java.net.URL;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TypesHandler {
    private static Map<URL, TypesHandler> handlerMap = new HashMap<URL, TypesHandler>();
    protected Map<Integer, String[]> typesMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypesHandler getHandler(URL typesConfig) {
        Map<URL, TypesHandler> map = handlerMap;
        synchronized (map) {
            TypesHandler handler = handlerMap.get(typesConfig);
            if (handler == null) {
                handler = new TypesHandler(typesConfig);
                handlerMap.put(typesConfig, handler);
            }
            return handler;
        }
    }

    public TypesHandler(URL typesConfig) {
        try (InputStream in = typesConfig.openStream();){
            XMLReader parser = Util.createXmlReader();
            TypesParseHandler ph = new TypesParseHandler();
            parser.setContentHandler(ph);
            parser.setErrorHandler(ph);
            parser.parse(new InputSource(in));
            this.typesMap = ph.getTypes();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error creating TypesHandler '" + typesConfig + "'.", (Throwable)ex, new Object[0]);
        }
    }

    public String[] externalTypesForJdbcType(int type) {
        return this.typesMap.get(type);
    }

    final class TypesParseHandler
    extends DefaultHandler {
        private static final String JDBC_TYPE_TAG = "jdbc-type";
        private static final String DB_TYPE_TAG = "db-type";
        private static final String NAME_ATTR = "name";
        private Map<Integer, String[]> types = new HashMap<Integer, String[]>();
        private List<String> currentTypes = new ArrayList<String>();
        private int currentType = Integer.MAX_VALUE;

        TypesParseHandler() {
        }

        public Map<Integer, String[]> getTypes() {
            return this.types;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (JDBC_TYPE_TAG.equals(localName)) {
                this.currentTypes.clear();
                String strType = atts.getValue("", NAME_ATTR);
                try {
                    this.currentType = Types.class.getDeclaredField(strType).getInt(null);
                }
                catch (Exception ex) {
                    this.currentType = Integer.MAX_VALUE;
                }
            } else if (DB_TYPE_TAG.equals(localName)) {
                this.currentTypes.add(atts.getValue("", NAME_ATTR));
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (JDBC_TYPE_TAG.equals(localName) && this.currentType != Integer.MAX_VALUE) {
                String[] typesAsArray = new String[this.currentTypes.size()];
                this.types.put(this.currentType, this.currentTypes.toArray(typesAsArray));
            }
        }
    }
}

