/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.runtime;

import javax.sql.DataSource;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategyFactory;
import org.apache.cayenne.access.jdbc.SQLTemplateProcessor;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.translator.select.SelectTranslatorFactory;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.runtime.DataNodeFactory;
import org.apache.cayenne.configuration.runtime.DataSourceFactory;
import org.apache.cayenne.configuration.runtime.DbAdapterFactory;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;

public class DefaultDataNodeFactory
implements DataNodeFactory {
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    @Inject
    protected RowReaderFactory rowReaderFactory;
    @Inject
    protected DataSourceFactory dataSourceFactory;
    @Inject
    protected BatchTranslatorFactory batchTranslatorFactory;
    @Inject
    protected SelectTranslatorFactory selectTranslatorFactory;
    @Inject
    protected DbAdapterFactory adapterFactory;
    @Inject
    protected AdhocObjectFactory objectFactory;
    @Inject
    protected SchemaUpdateStrategyFactory schemaUpdateStrategyFactory;
    @Inject
    protected SQLTemplateProcessor sqlTemplateProcessor;

    @Override
    public DataNode createDataNode(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataNode dataNode = new DataNode(nodeDescriptor.getName());
        dataNode.setJdbcEventLogger(this.jdbcEventLogger);
        dataNode.setRowReaderFactory(this.rowReaderFactory);
        dataNode.setBatchTranslatorFactory(this.batchTranslatorFactory);
        dataNode.setSelectTranslatorFactory(this.selectTranslatorFactory);
        dataNode.setSqlTemplateProcessor(this.sqlTemplateProcessor);
        DataSource dataSource = this.dataSourceFactory.getDataSource(nodeDescriptor);
        dataNode.setDataSourceFactory(nodeDescriptor.getDataSourceFactoryType());
        dataNode.setDataSource(dataSource);
        dataNode.setSchemaUpdateStrategy(this.schemaUpdateStrategyFactory.create(nodeDescriptor));
        dataNode.setAdapter(this.adapterFactory.createAdapter(nodeDescriptor, dataSource));
        return dataNode;
    }
}

