/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ProjectValidationFailure;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public abstract class ConfigurationNodeValidator<T extends ConfigurationNode> {
    protected final Supplier<ValidationConfig> configSupplier;

    public ConfigurationNodeValidator(Supplier<ValidationConfig> configSupplier) {
        this.configSupplier = configSupplier;
    }

    public abstract void validate(T var1, ValidationResult var2);

    public void addFailure(ValidationResult validationResult, T source, String messageFormat, Object ... messageParameters) {
        String message = String.format(messageFormat, messageParameters);
        validationResult.addFailure((ValidationFailure)new ProjectValidationFailure(source, message));
    }

    public void addFailure(ValidationResult validationResult, SimpleValidationFailure failure) {
        validationResult.addFailure((ValidationFailure)failure);
    }

    protected Performer<T> on(T node, ValidationResult validationResult) {
        return new Performer<T>(node, validationResult);
    }

    protected class Performer<N> {
        private final N node;
        private final ValidationResult validationResult;

        protected Performer(N node, ValidationResult validationResult) {
            this.node = node;
            this.validationResult = validationResult;
        }

        protected Performer<N> performIfEnabled(Inspection inspection, BiConsumer<N, ValidationResult> action) {
            return this.performIfEnabled(inspection, () -> action.accept(this.node, this.validationResult));
        }

        protected Performer<N> performIfEnabled(Inspection inspection, Runnable action) {
            if (ConfigurationNodeValidator.this.configSupplier.get().isEnabled(inspection)) {
                this.performAndMarkFailures(inspection, action);
            }
            return this;
        }

        private void performAndMarkFailures(Inspection inspection, Runnable action) {
            ArrayList failuresBefore = new ArrayList(this.validationResult.getFailures());
            action.run();
            this.validationResult.getFailures().stream().filter(Predicate.not(failuresBefore::contains)).forEach(failure -> ((ProjectValidationFailure)((Object)failure)).setInspection(inspection));
        }
    }
}

