/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import org.apache.cayenne.access.sqlbuilder.NodeTreeVisitor;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.StringBuilderAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;

public abstract class Node {
    protected Node parent;
    protected Node[] children;
    protected int childrenCount;
    protected final NodeType type;

    public Node(NodeType type) {
        this.type = type;
    }

    public Node() {
        this(NodeType.UNDEFINED);
    }

    public Node addChild(int index, Node node) {
        if (this.children.length <= this.childrenCount) {
            Node[] newChildren = new Node[this.children.length + 4];
            System.arraycopy(this.children, 0, newChildren, 0, index);
            System.arraycopy(this.children, index, newChildren, index + 1, this.childrenCount - index);
            this.children = newChildren;
        } else {
            System.arraycopy(this.children, index, this.children, index + 1, this.childrenCount - index);
        }
        this.children[index] = node;
        ++this.childrenCount;
        node.setParent(this);
        return this;
    }

    public Node addChild(Node node) {
        if (this.children == null) {
            this.children = new Node[4];
        } else if (this.children.length <= this.childrenCount) {
            Node[] newChildren = new Node[this.children.length + 4];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.children[this.childrenCount++] = node;
        node.setParent(this);
        return this;
    }

    public Node getChild(int idx) {
        return this.children[idx];
    }

    public int getChildrenCount() {
        return this.childrenCount;
    }

    public void replaceChild(int idx, Node node) {
        this.children[idx].setParent(null);
        this.children[idx] = node;
        node.setParent(this);
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public void visit(NodeTreeVisitor visitor) {
        if (!visitor.onNodeStart(this)) {
            return;
        }
        for (int i = 0; i < this.childrenCount; ++i) {
            boolean hasMore;
            boolean bl = hasMore = i < this.childrenCount - 1;
            if (!visitor.onChildNodeStart(this, this.children[i], i, hasMore)) {
                return;
            }
            this.children[i].visit(visitor);
            visitor.onChildNodeEnd(this, this.children[i], i, hasMore);
        }
        visitor.onNodeEnd(this);
    }

    public <T extends Node> T deepCopy() {
        Node node = this.copy();
        if (this.children != null) {
            node.children = new Node[this.childrenCount];
            node.childrenCount = this.childrenCount;
            for (int i = 0; i < this.childrenCount; ++i) {
                node.children[i] = this.children[i].deepCopy();
            }
        }
        return (T)node;
    }

    public String toString() {
        return "Node {" + this.append(new StringBuilderAppendable()).toString() + "}";
    }

    public NodeType getType() {
        return this.type;
    }

    public abstract Node copy();

    public abstract QuotingAppendable append(QuotingAppendable var1);

    public void appendChildrenSeparator(QuotingAppendable buffer, int childInd) {
    }

    public void appendChildrenStart(QuotingAppendable buffer) {
    }

    public void appendChildrenEnd(QuotingAppendable buffer) {
    }
}

