/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.filters;

import java.util.Arrays;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;

public class FiltersConfig {
    private final CatalogFilter[] catalogs;

    public FiltersConfig(CatalogFilter ... catalogs) {
        if (catalogs == null || catalogs.length == 0) {
            throw new IllegalArgumentException("catalogs(" + Arrays.toString(catalogs) + ") can't be null or empty");
        }
        this.catalogs = catalogs;
    }

    public CatalogFilter[] getCatalogs() {
        return this.catalogs;
    }

    public PatternFilter proceduresFilter(String catalog, String schema) {
        SchemaFilter schemaFilter = this.getSchemaFilter(catalog, schema);
        return schemaFilter == null ? null : schemaFilter.procedures;
    }

    public TableFilter tableFilter(String catalog, String schema) {
        SchemaFilter schemaFilter = this.getSchemaFilter(catalog, schema);
        return schemaFilter == null ? null : schemaFilter.tables;
    }

    protected SchemaFilter getSchemaFilter(String catalog, String schema) {
        CatalogFilter catalogFilter = this.getCatalog(catalog);
        if (catalogFilter == null) {
            return null;
        }
        return catalogFilter.getSchema(schema);
    }

    protected CatalogFilter getCatalog(String catalog) {
        for (CatalogFilter catalogFilter : this.catalogs) {
            if (catalogFilter.name != null && !catalogFilter.name.equals(catalog)) continue;
            return catalogFilter;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (CatalogFilter catalog : this.catalogs) {
            catalog.toString(builder, "");
        }
        return builder.toString();
    }

    public static FiltersConfig create(String catalog, String schema, TableFilter tableFilter, PatternFilter procedures) {
        return new FiltersConfig(new CatalogFilter(catalog, new SchemaFilter(schema, tableFilter, procedures)));
    }
}

