/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.StringTokenizer;

public class Version
implements Comparable<Object> {
    protected String versionString;
    protected int[] versionParts;

    public Version(String versionString) throws NumberFormatException {
        if (versionString == null) {
            throw new IllegalArgumentException("Null version.");
        }
        if (versionString.trim().length() == 0) {
            throw new IllegalArgumentException("Empty version.");
        }
        this.versionString = versionString;
        StringTokenizer toks = new StringTokenizer(versionString, ".");
        this.versionParts = new int[toks.countTokens()];
        for (int i = 0; i < this.versionParts.length; ++i) {
            this.versionParts[i] = Integer.parseInt(toks.nextToken());
        }
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof CharSequence) {
            o = new Version(o.toString());
        } else if (!(o instanceof Version)) {
            throw new IllegalArgumentException("Can only compare to Versions and Strings, got: " + o);
        }
        int[] otherVersion = ((Version)o).versionParts;
        int len = Math.min(otherVersion.length, this.versionParts.length);
        for (int i = 0; i < len; ++i) {
            int delta = this.versionParts[i] - otherVersion[i];
            if (delta == 0) continue;
            return delta;
        }
        if (this.versionParts.length < otherVersion.length) {
            return -1;
        }
        if (this.versionParts.length > otherVersion.length) {
            return 1;
        }
        return 0;
    }

    public String getVersionString() {
        return this.versionString;
    }
}

