/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.awt.Component;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.editor.cgen.GeneratorController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public abstract class CodeGeneratorControllerBase
extends CayenneController {
    public static final String SELECTED_PROPERTY = "selected";
    protected DataMap dataMap;
    protected ValidationResult validation;
    protected List<Object> classes;
    private Set<String> selectedEntities;
    private Set<String> selectedEmbeddables;
    private Set<String> isDataMapSelected;
    private Map<DataMap, Set<String>> selectedEntitiesForDataMap;
    private Map<DataMap, Set<String>> selectedEmbeddablesForDataMap;
    private Map<DataMap, Set<String>> selectedDataMaps;
    protected transient Object currentClass;
    protected ProjectController projectController;
    protected boolean initFromModel;

    public CodeGeneratorControllerBase(CayenneController parent, ProjectController projectController) {
        super(parent);
        this.projectController = projectController;
        this.classes = new ArrayList<Object>();
        this.selectedEntitiesForDataMap = new HashMap<DataMap, Set<String>>();
        this.selectedEmbeddablesForDataMap = new HashMap<DataMap, Set<String>>();
        this.selectedDataMaps = new HashMap<DataMap, Set<String>>();
        this.selectedEntities = new HashSet<String>();
        this.selectedEmbeddables = new HashSet<String>();
        this.isDataMapSelected = new HashSet<String>();
    }

    public void startup(DataMap dataMap) {
        this.initFromModel = true;
        this.dataMap = dataMap;
        this.prepareClasses(dataMap);
    }

    private void prepareClasses(DataMap dataMap) {
        this.classes.clear();
        this.classes.add(dataMap);
        this.classes.addAll(dataMap.getObjEntities());
        this.classes.addAll(dataMap.getEmbeddables());
        this.initCollectionsForSelection(dataMap);
    }

    private void initCollectionsForSelection(DataMap dataMap) {
        this.selectedEntities = this.selectedEntitiesForDataMap.compute(dataMap, (key, value) -> value == null ? new HashSet() : value);
        this.selectedEmbeddables = this.selectedEmbeddablesForDataMap.compute(dataMap, (key, value) -> value == null ? new HashSet() : value);
        this.isDataMapSelected = this.selectedDataMaps.compute(dataMap, (key, value) -> value == null ? new HashSet() : value);
    }

    public CgenConfiguration createConfiguration() {
        DataMap map = this.projectController.getCurrentDataMap();
        CgenConfiguration cgenConfiguration = this.projectController.getApplication().getMetaData().get(map, CgenConfiguration.class);
        if (cgenConfiguration != null) {
            this.addToSelectedEntities(cgenConfiguration.getEntities());
            this.addToSelectedEmbeddables(cgenConfiguration.getEmbeddables());
            cgenConfiguration.setForce(true);
            return cgenConfiguration;
        }
        cgenConfiguration = new CgenConfiguration(false);
        cgenConfiguration.setForce(true);
        cgenConfiguration.setDataMap(map);
        Path basePath = Paths.get(ModelerUtil.initOutputFolder(), new String[0]);
        if (!Files.exists(basePath, new LinkOption[0])) {
            try {
                Files.createDirectories(basePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getView(), "Can't create directory. Select a different one.");
                return null;
            }
        }
        if (!Files.isDirectory(basePath, new LinkOption[0])) {
            JOptionPane.showMessageDialog(this.getView(), basePath + " is not a valid directory.");
            return null;
        }
        cgenConfiguration.setRootPath(basePath);
        Preferences preferences = this.application.getPreferencesNode(GeneralPreferences.class, "");
        if (preferences != null) {
            cgenConfiguration.setEncoding(preferences.get("encoding", null));
        }
        this.addToSelectedEntities(map.getObjEntities().stream().map(Entity::getName).collect(Collectors.toList()));
        this.addToSelectedEmbeddables(map.getEmbeddables().stream().map(Embeddable::getClassName).collect(Collectors.toList()));
        this.getApplication().getMetaData().add(map, cgenConfiguration);
        this.projectController.setDirty(true);
        return cgenConfiguration;
    }

    public List<Object> getClasses() {
        return this.classes;
    }

    @Override
    public abstract Component getView();

    public void validate(GeneratorController validator) {
        ValidationResult validationBuffer = new ValidationResult();
        if (validator != null) {
            for (Object classObj : this.classes) {
                if (classObj instanceof ObjEntity) {
                    validator.validateEntity(validationBuffer, (ObjEntity)classObj, false);
                    continue;
                }
                if (!(classObj instanceof Embeddable)) continue;
                validator.validateEmbeddable(validationBuffer, (Embeddable)classObj);
            }
        }
        this.validation = validationBuffer;
    }

    public boolean updateSelection(Predicate<Object> predicate) {
        boolean modified = false;
        for (Object classObj : this.classes) {
            boolean select = predicate.test(classObj);
            if (classObj instanceof ObjEntity) {
                if (select) {
                    if (!this.selectedEntities.add(((ObjEntity)classObj).getName())) continue;
                    modified = true;
                    continue;
                }
                if (!this.selectedEntities.remove(((ObjEntity)classObj).getName())) continue;
                modified = true;
                continue;
            }
            if (classObj instanceof Embeddable) {
                if (select) {
                    if (!this.selectedEmbeddables.add(((Embeddable)classObj).getClassName())) continue;
                    modified = true;
                    continue;
                }
                if (!this.selectedEmbeddables.remove(((Embeddable)classObj).getClassName())) continue;
                modified = true;
                continue;
            }
            if (!(classObj instanceof DataMap)) continue;
            this.updateArtifactGenerationMode(classObj, select);
            if (select) {
                if (!this.isDataMapSelected.add(((DataMap)classObj).getName())) continue;
                modified = true;
                continue;
            }
            if (!this.isDataMapSelected.remove(((DataMap)classObj).getName())) continue;
            modified = true;
        }
        if (modified) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
        return modified;
    }

    private List<Embeddable> getSelectedEmbeddables() {
        ArrayList<Embeddable> selected = new ArrayList<Embeddable>(this.selectedEmbeddables.size());
        for (Object classObj : this.classes) {
            String name;
            if (!(classObj instanceof Embeddable) || !this.selectedEmbeddables.contains(name = ((Embeddable)classObj).getClassName())) continue;
            selected.add((Embeddable)classObj);
        }
        return selected;
    }

    private List<ObjEntity> getSelectedEntities() {
        ArrayList<ObjEntity> selected = new ArrayList<ObjEntity>(this.selectedEntities.size());
        for (Object classObj : this.classes) {
            String name;
            if (!(classObj instanceof ObjEntity) || !this.selectedEntities.contains(name = ((ObjEntity)classObj).getName())) continue;
            selected.add((ObjEntity)classObj);
        }
        return selected;
    }

    public String getProblem(Object obj) {
        String name = null;
        if (obj instanceof ObjEntity) {
            name = ((ObjEntity)obj).getName();
        } else if (obj instanceof Embeddable) {
            name = ((Embeddable)obj).getClassName();
        }
        if (this.validation == null) {
            return null;
        }
        List<ValidationFailure> failures = this.validation.getFailures(name);
        if (failures.isEmpty()) {
            return null;
        }
        return failures.get(0).getDescription();
    }

    public boolean isSelected() {
        if (this.currentClass instanceof ObjEntity) {
            return this.selectedEntities.contains(((ObjEntity)this.currentClass).getName());
        }
        if (this.currentClass instanceof Embeddable) {
            return this.selectedEmbeddables.contains(((Embeddable)this.currentClass).getClassName());
        }
        if (this.currentClass instanceof DataMap) {
            return this.isDataMapSelected.contains(((DataMap)this.currentClass).getName());
        }
        return false;
    }

    public void setSelected(boolean selectedFlag) {
        if (this.currentClass == null) {
            return;
        }
        if (this.currentClass instanceof ObjEntity) {
            if (selectedFlag) {
                if (this.selectedEntities.add(((ObjEntity)this.currentClass).getName())) {
                    this.firePropertyChange(SELECTED_PROPERTY, null, null);
                }
            } else if (this.selectedEntities.remove(((ObjEntity)this.currentClass).getName())) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        }
        if (this.currentClass instanceof Embeddable) {
            if (selectedFlag) {
                if (this.selectedEmbeddables.add(((Embeddable)this.currentClass).getClassName())) {
                    this.firePropertyChange(SELECTED_PROPERTY, null, null);
                }
            } else if (this.selectedEmbeddables.remove(((Embeddable)this.currentClass).getClassName())) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        }
        if (this.currentClass instanceof DataMap) {
            this.updateArtifactGenerationMode(this.currentClass, selectedFlag);
            if (selectedFlag) {
                if (this.isDataMapSelected.add(this.dataMap.getName())) {
                    this.firePropertyChange(SELECTED_PROPERTY, null, null);
                }
            } else if (this.isDataMapSelected.remove(((DataMap)this.currentClass).getName())) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        }
    }

    private void updateArtifactGenerationMode(Object classObj, boolean selected) {
        DataMap dataMap = (DataMap)classObj;
        CgenConfiguration cgenConfiguration = this.projectController.getApplication().getMetaData().get(dataMap, CgenConfiguration.class);
        if (selected) {
            cgenConfiguration.setArtifactsGenerationMode("all");
        } else {
            cgenConfiguration.setArtifactsGenerationMode("entity");
        }
    }

    public JLabel getItemName(Object obj) {
        Icon icon;
        String className;
        if (obj instanceof Embeddable) {
            className = ((Embeddable)obj).getClassName();
            icon = CellRenderers.iconForObject(new Embeddable());
        } else if (obj instanceof ObjEntity) {
            className = ((ObjEntity)obj).getName();
            icon = CellRenderers.iconForObject(new ObjEntity());
        } else {
            className = ((DataMap)obj).getName();
            icon = CellRenderers.iconForObject(new DataMap());
        }
        JLabel labelIcon = new JLabel();
        labelIcon.setIcon(icon);
        labelIcon.setVisible(true);
        labelIcon.setText(className);
        return labelIcon;
    }

    public void updateSelectedEntities() {
        this.updateEntities();
        this.updateEmbeddables();
    }

    CgenConfiguration getCurrentConfiguration() {
        DataMap map = this.getProjectController().getCurrentDataMap();
        return this.projectController.getApplication().getMetaData().get(map, CgenConfiguration.class);
    }

    private void updateEntities() {
        CgenConfiguration cgenConfiguration = this.getCurrentConfiguration();
        if (cgenConfiguration != null) {
            cgenConfiguration.getEntities().clear();
            for (ObjEntity entity : this.getSelectedEntities()) {
                cgenConfiguration.loadEntity(entity);
            }
        }
    }

    private void updateEmbeddables() {
        CgenConfiguration cgenConfiguration = this.getCurrentConfiguration();
        if (cgenConfiguration != null) {
            cgenConfiguration.getEmbeddables().clear();
            for (Embeddable embeddable : this.getSelectedEmbeddables()) {
                cgenConfiguration.loadEmbeddable(embeddable.getClassName());
            }
        }
    }

    private void addToSelectedEntities(Collection<String> entities) {
        this.selectedEntities.addAll(entities);
        this.updateEntities();
    }

    void addEntity(DataMap dataMap, ObjEntity objEntity) {
        this.prepareClasses(dataMap);
        this.selectedEntities.add(objEntity.getName());
        CgenConfiguration cgenConfiguration = this.getCurrentConfiguration();
        if (cgenConfiguration != null) {
            cgenConfiguration.loadEntity(objEntity);
        }
    }

    private void addToSelectedEmbeddables(Collection<String> embeddables) {
        this.selectedEmbeddables.addAll(embeddables);
        this.updateEmbeddables();
    }

    void addEmbeddable(DataMap dataMap, Embeddable embeddable) {
        this.prepareClasses(dataMap);
        this.selectedEmbeddables.add(embeddable.getClassName());
        CgenConfiguration cgenConfiguration = this.getCurrentConfiguration();
        if (cgenConfiguration != null) {
            cgenConfiguration.loadEmbeddable(embeddable.getClassName());
        }
    }

    public int getSelectedEntitiesSize() {
        return this.selectedEntities != null ? this.selectedEntities.size() : 0;
    }

    public int getSelectedEmbeddablesSize() {
        return this.selectedEmbeddables != null ? this.selectedEmbeddables.size() : 0;
    }

    public boolean isDataMapSelected() {
        return this.isDataMapSelected != null && this.isDataMapSelected.size() == 1;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public ProjectController getProjectController() {
        return this.projectController;
    }

    public Object getCurrentClass() {
        return this.currentClass;
    }

    public void setCurrentClass(Object currentClass) {
        this.currentClass = currentClass;
    }

    public boolean isInitFromModel() {
        return this.initFromModel;
    }

    public void setInitFromModel(boolean initFromModel) {
        this.initFromModel = initFromModel;
    }

    public abstract void enableGenerateButton(boolean var1);

    void removeFromSelectedEntities(ObjEntity objEntity) {
        this.initCollectionsForSelection(objEntity.getDataMap());
        this.selectedEntities.remove(objEntity.getName());
    }

    void removeFromSelectedEmbeddables(Embeddable embeddable) {
        this.initCollectionsForSelection(embeddable.getDataMap());
        this.selectedEmbeddables.remove(embeddable.getClassName());
    }
}

