/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.SQLTemplateMainTab;
import org.apache.cayenne.modeler.editor.SQLTemplatePrefetchTab;
import org.apache.cayenne.modeler.editor.SQLTemplateScriptsTab;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;

public class SQLTemplateTabbedView
extends JTabbedPane {
    protected ProjectController mediator;
    protected SQLTemplateMainTab mainTab;
    protected SQLTemplateScriptsTab scriptsTab;
    protected SQLTemplatePrefetchTab prefetchTab;
    protected int lastSelectionIndex;

    public SQLTemplateTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setTabPlacement(1);
        this.mainTab = new SQLTemplateMainTab(this.mediator);
        this.addTab("General", new JScrollPane(this.mainTab));
        this.scriptsTab = new SQLTemplateScriptsTab(this.mediator);
        this.addTab("SQL Scripts", this.scriptsTab);
        this.prefetchTab = new SQLTemplatePrefetchTab(this.mediator);
        this.addTab("Prefetches", this.prefetchTab);
    }

    private void initController() {
        this.mediator.addQueryDisplayListener(new QueryDisplayListener(){

            @Override
            public void currentQueryChanged(QueryDisplayEvent e) {
                SQLTemplateTabbedView.this.initFromModel();
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SQLTemplateTabbedView.this.lastSelectionIndex = SQLTemplateTabbedView.this.getSelectedIndex();
                SQLTemplateTabbedView.this.updateTabs();
            }
        });
    }

    void initFromModel() {
        if (!"SQLTemplate".equals(this.mediator.getCurrentQuery().getType())) {
            this.setVisible(false);
            return;
        }
        if (this.mediator.getCurrentQuery().getRoot() == null) {
            this.lastSelectionIndex = 0;
        }
        if (this.getSelectedIndex() == this.lastSelectionIndex) {
            this.updateTabs();
        } else {
            this.setSelectedIndex(this.lastSelectionIndex);
        }
        this.setVisible(true);
    }

    void updateTabs() {
        switch (this.lastSelectionIndex) {
            case 0: {
                this.mainTab.initFromModel();
                break;
            }
            case 1: {
                this.scriptsTab.initFromModel();
                break;
            }
            case 2: {
                this.prefetchTab.initFromModel();
            }
        }
    }

    public SQLTemplateScriptsTab getScriptsTab() {
        return this.scriptsTab;
    }
}

