/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.GeneratorsPanel;
import org.apache.cayenne.modeler.editor.GeneratorsTabController;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class GeneratorsTab
extends JPanel {
    protected ProjectController projectController;
    private GeneratorsTabController<?> additionalTabController;
    private TopGeneratorPanel generationPanel;

    public GeneratorsTab(ProjectController projectController, GeneratorsTabController<?> additionalTabController, String icon, String text) {
        this.projectController = projectController;
        this.additionalTabController = additionalTabController;
        this.generationPanel = new TopGeneratorPanel(icon);
        this.generationPanel.generateAll.addActionListener(action -> additionalTabController.runGenerators(additionalTabController.getSelectedDataMaps()));
        this.generationPanel.generateAll.setToolTipText(text);
        this.setLayout(new BorderLayout());
    }

    public void initView() {
        this.removeAll();
        this.additionalTabController.createPanels();
        FormLayout layout = new FormLayout("left:pref, 4dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        ConcurrentMap<DataMap, GeneratorsPanel> panels = this.additionalTabController.getGeneratorsPanels();
        if (panels.isEmpty()) {
            this.add((Component)new JLabel("There are no datamaps."), "North");
            return;
        }
        builder.append(this.generationPanel);
        builder.nextLine();
        TreeSet keys = new TreeSet(panels.keySet());
        for (DataMap dataMap : keys) {
            builder.append((Component)panels.get(dataMap));
            builder.nextLine();
        }
        this.add((Component)builder.getPanel(), "Center");
    }

    public void showEmptyMessage() {
        JOptionPane.showMessageDialog(this, "Nothing to generate");
    }

    TopGeneratorPanel getGenerationPanel() {
        return this.generationPanel;
    }

    class TopGeneratorPanel
    extends JPanel {
        private JCheckBox selectAll;
        JButton generateAll;

        TopGeneratorPanel(String icon) {
            this.setLayout(new BorderLayout());
            FormLayout layout = new FormLayout("left:pref, 4dlu, fill:70dlu, 3dlu, fill:120, 3dlu, fill:120", "");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            this.selectAll = new JCheckBox();
            this.generateAll = new JButton("Run");
            this.generateAll.setEnabled(false);
            this.generateAll.setIcon(ModelerUtil.buildIcon(icon));
            builder.append(this.selectAll, (Component)new JLabel("Select All"), (Component)this.generateAll);
            this.add((Component)builder.getPanel(), "Center");
        }

        JCheckBox getSelectAll() {
            return this.selectAll;
        }

        JButton getGenerateAll() {
            return this.generateAll;
        }
    }
}

