/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.DBWizardAction;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.DbActionOptionsDialog;
import org.apache.cayenne.modeler.dialog.db.load.DbLoadResultDialog;
import org.apache.cayenne.modeler.dialog.db.load.DbLoaderContext;
import org.apache.cayenne.modeler.dialog.db.load.LoadDataMapTask;
import org.apache.cayenne.modeler.editor.DbImportController;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.pref.DataMapDefaults;

public class ReverseEngineeringAction
extends DBWizardAction<DbActionOptionsDialog> {
    private static final String ACTION_NAME = "Reengineer Database Schema";
    private static final String ICON_NAME = "icon-dbi-runImport.png";
    private static final String DIALOG_TITLE = "Reengineer DB Schema: Connect to Database";
    private DbImportView view;
    private AtomicInteger dataMapCount;
    protected Set<DataMap> dataMaps;

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    ReverseEngineeringAction(Application application) {
        super(ReverseEngineeringAction.getActionName(), application);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public void performAction(Set<DataMap> dataMapSet) {
        this.resetParams();
        this.dataMaps.addAll(dataMapSet);
        this.dataMapCount.set(this.dataMaps.size());
        ProjectController projectController = Application.getInstance().getFrameController().getProjectController();
        for (DataMap dataMap : dataMapSet) {
            projectController.setCurrentDataMap(dataMap);
            this.startImport();
        }
    }

    private void startImport() {
        DBConnectionInfo connectionInfo;
        DbLoaderContext context = new DbLoaderContext(this.application.getMetaData());
        if (this.datamapPrefNotExist()) {
            DataSourceWizard connectWizard = this.dataSourceWizardDialog(DIALOG_TITLE);
            if (connectWizard == null) {
                return;
            }
            connectionInfo = connectWizard.getConnectionInfo();
            this.saveConnectionInfo(connectWizard);
        } else {
            connectionInfo = this.getConnectionInfoFromPreferences();
        }
        context.setProjectController(this.getProjectController());
        try {
            context.setConnection(connectionInfo.makeDataSource(this.getApplication().getClassLoadingService()).getConnection());
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(Application.getFrame(), ex.getMessage(), "Error loading schemas dialog", 0);
            return;
        }
        if (!context.buildConfig(connectionInfo, this.view, true)) {
            try {
                context.getConnection().close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            return;
        }
        DbImportController dbImportController = Application.getInstance().getFrameController().getDbImportController();
        DbLoadResultDialog dbLoadResultDialog = dbImportController.createDialog();
        this.runLoaderInThread(context, () -> {
            this.application.getUndoManager().discardAllEdits();
            try {
                context.getConnection().close();
                if (!(this.dataMapCount.decrementAndGet() > 0 || context.isInterrupted() || dbLoadResultDialog.isVisible() || dbLoadResultDialog.getTableForMap().isEmpty())) {
                    dbImportController.showDialog();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
    }

    @Override
    public void performAction(ActionEvent event) {
        this.resetParams();
        this.dataMaps.add(Application.getInstance().getFrameController().getProjectController().getCurrentDataMap());
        this.dataMapCount.set(this.dataMaps.size());
        this.startImport();
    }

    private void resetParams() {
        this.dataMapCount = new AtomicInteger();
        this.dataMaps = new HashSet<DataMap>();
    }

    private DBConnectionInfo getConnectionInfoFromPreferences() {
        DBConnectionInfo connectionInfo = new DBConnectionInfo();
        DataMapDefaults dataMapDefaults = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap());
        connectionInfo.setDbAdapter(dataMapDefaults.getCurrentPreference().get("dbAdapter", null));
        connectionInfo.setUrl(dataMapDefaults.getCurrentPreference().get("url", null));
        connectionInfo.setUserName(dataMapDefaults.getCurrentPreference().get("userName", null));
        connectionInfo.setPassword(dataMapDefaults.getCurrentPreference().get("password", null));
        connectionInfo.setJdbcDriver(dataMapDefaults.getCurrentPreference().get("jdbcDriver", null));
        return connectionInfo;
    }

    private void saveConnectionInfo(DataSourceWizard connectWizard) {
        DataMapDefaults dataMapDefaults = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap());
        String dbAdapter = connectWizard.getConnectionInfo().getDbAdapter();
        if (dbAdapter != null) {
            dataMapDefaults.getCurrentPreference().put("dbAdapter", dbAdapter);
        } else {
            dataMapDefaults.getCurrentPreference().remove("dbAdapter");
        }
        dataMapDefaults.getCurrentPreference().put("url", connectWizard.getConnectionInfo().getUrl());
        dataMapDefaults.getCurrentPreference().put("userName", connectWizard.getConnectionInfo().getUserName());
        dataMapDefaults.getCurrentPreference().put("password", connectWizard.getConnectionInfo().getPassword());
        dataMapDefaults.getCurrentPreference().put("jdbcDriver", connectWizard.getConnectionInfo().getJdbcDriver());
    }

    private boolean datamapPrefNotExist() {
        Preferences dataMapPreference = this.getProjectController().getDataMapPreferences(this.getProjectController().getCurrentDataMap()).getCurrentPreference();
        return dataMapPreference == null || dataMapPreference.get("url", null) == null;
    }

    private void runLoaderInThread(DbLoaderContext context, Runnable callback) {
        Thread th = new Thread(() -> {
            LoadDataMapTask task = new LoadDataMapTask(Application.getFrame(), "Reengineering DB", context);
            task.startAndWait();
            SwingUtilities.invokeLater(callback);
        });
        th.start();
    }

    @Override
    protected DbActionOptionsDialog createDialog(Collection<String> catalogs, Collection<String> schemas, String currentCatalog, String currentSchema, int command) {
        return null;
    }

    public void setView(DbImportView view) {
        this.view = view;
    }
}

