/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.AliasPathComponent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.AttributePathComponent;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.RelationshipPathComponent;

class PathComponentIterator
implements Iterator<PathComponent<Attribute, Relationship>> {
    private final StringTokenizer toks;
    private final String path;
    private final Map<String, String> aliasMap;
    private EmbeddedAttribute embeddedAttribute;
    private Entity currentEntity;

    PathComponentIterator(Entity root, String path, Map<String, String> aliasMap) {
        this.currentEntity = Objects.requireNonNull(root);
        this.path = Objects.requireNonNull(path);
        this.aliasMap = Objects.requireNonNull(aliasMap);
        this.toks = new StringTokenizer(path, ".");
        this.embeddedAttribute = null;
    }

    @Override
    public boolean hasNext() {
        return this.toks.hasMoreTokens();
    }

    @Override
    public PathComponent<Attribute, Relationship> next() {
        Attribute attr;
        String pathComp = this.toks.nextToken();
        JoinType relationshipJoinType = JoinType.INNER;
        if (pathComp.endsWith("+")) {
            relationshipJoinType = JoinType.LEFT_OUTER;
            pathComp = pathComp.substring(0, pathComp.length() - "+".length());
        }
        if (this.embeddedAttribute != null) {
            attr = this.embeddedAttribute.getAttribute(pathComp);
            this.embeddedAttribute = null;
        } else {
            attr = this.currentEntity.getAttribute(pathComp);
        }
        if (attr != null) {
            if (attr instanceof EmbeddedAttribute) {
                this.embeddedAttribute = (EmbeddedAttribute)attr;
            } else if (this.toks.hasMoreTokens()) {
                throw new ExpressionException("Attribute must be the last component of the path: '" + pathComp + "'.", this.path, null, new Object[0]);
            }
            return new AttributePathComponent<Attribute, Relationship>(attr);
        }
        Relationship rel = this.currentEntity.getRelationship(pathComp);
        if (rel != null) {
            this.currentEntity = rel.getTargetEntity();
            return new RelationshipPathComponent<Attribute, Relationship>(rel, relationshipJoinType, !this.hasNext());
        }
        PathComponent<Attribute, Relationship> aliasedPathComponent = this.getAliasedPathComponent(pathComp);
        if (aliasedPathComponent != null) {
            return aliasedPathComponent;
        }
        throw this.invalidPathException("Can't resolve path component", pathComp);
    }

    private PathComponent<Attribute, Relationship> getAliasedPathComponent(String pathComp) {
        String aliasedPath = this.aliasMap.get(pathComp);
        if (aliasedPath == null) {
            return null;
        }
        PathComponentIterator subpathIt = new PathComponentIterator(this.currentEntity, aliasedPath, Collections.emptyMap());
        ArrayList parsedSubpath = new ArrayList(4);
        while (subpathIt.hasNext()) {
            PathComponent subpathComponent = (PathComponent)subpathIt.next();
            Object subpathRelationship = subpathComponent.getRelationship();
            if (subpathRelationship == null) {
                throw this.invalidPathException("Expected a relationship in the aliased subpath. Alias [" + pathComp + "]", subpathComponent.getName());
            }
            this.currentEntity = ((Relationship)subpathRelationship).getTargetEntity();
            parsedSubpath.add(subpathComponent);
        }
        return new AliasPathComponent<Attribute, Relationship>(pathComp, parsedSubpath, !this.hasNext());
    }

    private ExpressionException invalidPathException(String message, String pathComponent) {
        String buffer = message + ": [" + this.currentEntity.getName() + '.' + pathComponent + "].";
        return new ExpressionException(buffer, this.path, null, new Object[0]);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("'remove' operation is not supported.");
    }
}

