/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DbKeyGeneratorHandler
extends NamespaceAwareNestedTagHandler {
    private static final String DB_KEY_GENERATOR_TAG = "db-key-generator";
    private static final String DB_GENERATOR_TYPE_TAG = "db-generator-type";
    private static final String DB_GENERATOR_NAME_TAG = "db-generator-name";
    private static final String DB_KEY_CACHE_SIZE_TAG = "db-key-cache-size";
    DbEntity entity;

    public DbKeyGeneratorHandler(NamespaceAwareNestedTagHandler parentHandler, DbEntity entity) {
        super(parentHandler);
        this.entity = entity;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "db-key-generator": {
                this.createDbKeyGenerator();
                return true;
            }
            case "db-generator-name": 
            case "db-generator-type": 
            case "db-key-cache-size": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processCharData(String localName, String data) {
        switch (localName) {
            case "db-generator-type": {
                this.setDbGeneratorType(data);
                break;
            }
            case "db-generator-name": {
                this.setDbGeneratorName(data);
                break;
            }
            case "db-key-cache-size": {
                this.setDbKeyCacheSize(data);
            }
        }
    }

    private void createDbKeyGenerator() {
        this.entity.setPrimaryKeyGenerator(new DbKeyGenerator());
    }

    private void setDbGeneratorType(String type) {
        if (this.entity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.entity.getPrimaryKeyGenerator();
        pkGenerator.setGeneratorType(type);
        if (pkGenerator.getGeneratorType() == null) {
            this.entity.setPrimaryKeyGenerator(null);
        }
    }

    private void setDbGeneratorName(String name) {
        if (this.entity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.entity.getPrimaryKeyGenerator();
        if (pkGenerator == null) {
            return;
        }
        pkGenerator.setGeneratorName(name);
    }

    private void setDbKeyCacheSize(String size) {
        if (this.entity == null) {
            return;
        }
        DbKeyGenerator pkGenerator = this.entity.getPrimaryKeyGenerator();
        if (pkGenerator == null) {
            return;
        }
        try {
            pkGenerator.setKeyCacheSize(Integer.valueOf(size.trim()));
        }
        catch (Exception ex) {
            pkGenerator.setKeyCacheSize(null);
        }
    }
}

