/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Map;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ObjAttributeValidator
extends ConfigurationNodeValidator {
    ObjAttributeValidator() {
    }

    void validate(ObjAttribute attribute, ValidationResult validationResult) {
        this.validateName(attribute, validationResult);
        if (Util.isEmptyString((CharSequence)attribute.getType())) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' has no Java type", attribute.getName());
        }
        if (attribute instanceof EmbeddedAttribute) {
            this.validateEmbeddable((EmbeddedAttribute)attribute, validationResult);
        } else {
            this.validateDbAttribute(attribute, validationResult);
        }
        this.checkForDuplicates(attribute, validationResult);
        this.checkSuperEntityAttributes(attribute, validationResult);
    }

    private void validateName(ObjAttribute attribute, ValidationResult validationResult) {
        if (Util.isEmptyString((CharSequence)attribute.getName())) {
            this.addFailure(validationResult, attribute, "Unnamed ObjAttribute", new Object[0]);
            return;
        }
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String invalidChars = helper.invalidCharsInObjPathComponent(attribute.getName());
        if (invalidChars != null) {
            this.addFailure(validationResult, attribute, "ObjAttribute name '%s' contains invalid characters: %s", attribute.getName(), invalidChars);
        } else if (helper.invalidDataObjectProperty(attribute.getName())) {
            this.addFailure(validationResult, attribute, "ObjAttribute name '%s' is invalid", attribute.getName());
        }
    }

    private void checkSuperEntityAttributes(ObjAttribute attribute, ValidationResult validationResult) {
        boolean selfAttribute = false;
        if (attribute.getEntity().getDeclaredAttribute(attribute.getName()) != null) {
            selfAttribute = true;
        }
        ObjEntity superEntity = attribute.getEntity().getSuperEntity();
        if (selfAttribute && superEntity != null && superEntity.getAttribute(attribute.getName()) != null) {
            this.addFailure(validationResult, attribute, "'%s' and super '%s' can't have attribute '%s' together ", attribute.getEntity().getName(), superEntity.getName(), attribute.getName());
        }
    }

    private void validateDbAttribute(ObjAttribute attribute, ValidationResult validationResult) {
        DbAttribute dbAttribute;
        if (attribute.getEntity().isAbstract()) {
            return;
        }
        try {
            dbAttribute = attribute.getDbAttribute();
        }
        catch (ExpressionException e) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' has invalid DB path: %s", attribute.getName(), e.getExpressionString());
            return;
        }
        if (dbAttribute == null) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' has no DbAttribute mapping", attribute.getName());
            return;
        }
        if (dbAttribute.isPrimaryKey() && dbAttribute.isGenerated()) {
            this.addFailure(validationResult, attribute, "ObjAttribute '%s' is mapped to a generated PK: %s", attribute.getName(), attribute.getDbAttributeName());
        }
    }

    private void validateEmbeddable(EmbeddedAttribute attribute, ValidationResult validationResult) {
        Embeddable embeddable = attribute.getEmbeddable();
        if (embeddable == null) {
            String msg = attribute.getType() == null ? "EmbeddedAttribute '%s' has no Embeddable" : "EmbeddedAttribute '%s' has incorrect Embeddable";
            this.addFailure(validationResult, attribute, msg, attribute.getName());
            return;
        }
        Map attrOverrides = attribute.getAttributeOverrides();
        for (EmbeddableAttribute embeddableAttribute : embeddable.getAttributes()) {
            String dbAttributeName = !attrOverrides.isEmpty() && attrOverrides.containsKey(embeddableAttribute.getName()) ? (String)attrOverrides.get(embeddableAttribute.getName()) : embeddableAttribute.getDbAttributeName();
            if (Util.isEmptyString((CharSequence)dbAttributeName)) {
                this.addFailure(validationResult, attribute, "EmbeddedAttribute '%s' has no DbAttribute mapping", attribute.getName());
                continue;
            }
            if (attribute.getEntity().getDbEntity().getAttribute(dbAttributeName) != null) continue;
            this.addFailure(validationResult, attribute, "EmbeddedAttribute '%s' has incorrect DbAttribute mapping", attribute.getName());
        }
    }

    private void checkForDuplicates(ObjAttribute attribute, ValidationResult validationResult) {
        if (attribute != null && attribute.getName() != null && !attribute.isInherited()) {
            ObjEntity entity = attribute.getEntity();
            for (ObjAttribute comparisonAttribute : entity.getAttributes()) {
                String dbAttributePath;
                if (attribute == comparisonAttribute || (dbAttributePath = attribute.getDbAttributePath()) == null || !dbAttributePath.equals(comparisonAttribute.getDbAttributePath())) continue;
                this.addFailure(validationResult, attribute, "ObjEntity '%s' contains a duplicate DbAttribute mapping ('%s' -> '%s')", entity.getName(), attribute.getName(), dbAttributePath);
                return;
            }
        }
    }
}

