/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.CayenneContextChildDiffLoader;
import org.apache.cayenne.CayenneContextGraphManager;
import org.apache.cayenne.CayenneContextMergeHandler;
import org.apache.cayenne.CayenneContextQueryAction;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.CollectionResultIterator;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.Validating;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.EventUtil;
import org.apache.cayenne.validation.ValidationException;
import org.apache.cayenne.validation.ValidationResult;

public class CayenneContext
extends BaseContext {
    CayenneContextGraphManager graphManager;
    CayenneContextMergeHandler mergeHandler;

    public CayenneContext() {
        this(null);
    }

    public CayenneContext(DataChannel channel) {
        this(channel, false, false);
    }

    public CayenneContext(DataChannel channel, boolean changeEventsEnabled, boolean lifecyleEventsEnabled) {
        this.graphManager = new CayenneContextGraphManager(this, changeEventsEnabled, lifecyleEventsEnabled);
        if (channel != null) {
            this.attachToChannel(channel);
        }
    }

    protected void attachToChannel(DataChannel channel) {
        EventManager eventManager;
        super.attachToChannel(channel);
        if (this.mergeHandler != null) {
            this.mergeHandler.active = false;
            this.mergeHandler = null;
        }
        if ((eventManager = channel.getEventManager()) != null) {
            this.mergeHandler = new CayenneContextMergeHandler(this);
            EventUtil.listenForChannelEvents((DataChannel)channel, (DataChannelListener)this.mergeHandler);
        }
    }

    public boolean isChangeEventsEnabled() {
        return this.graphManager.changeEventsEnabled;
    }

    public boolean isLifecycleEventsEnabled() {
        return this.graphManager.lifecycleEventsEnabled;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    CayenneContextGraphManager internalGraphManager() {
        return this.graphManager;
    }

    public void commitChanges() {
        this.doCommitChanges(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff doCommitChanges(boolean cascade) {
        int syncType = cascade ? 2 : 1;
        GraphDiff commitDiff = null;
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                if (this.isValidatingObjectsOnCommit()) {
                    ValidationResult result = new ValidationResult();
                    for (Persistent persistent : this.graphManager.dirtyNodes()) {
                        if (!(persistent instanceof Validating)) continue;
                        switch (persistent.getPersistenceState()) {
                            case 2: {
                                ((Validating)persistent).validateForInsert(result);
                                break;
                            }
                            case 4: {
                                ((Validating)persistent).validateForUpdate(result);
                                break;
                            }
                            case 6: {
                                ((Validating)persistent).validateForDelete(result);
                            }
                        }
                    }
                    if (result.hasFailures()) {
                        throw new ValidationException(result);
                    }
                }
                this.graphManager.graphCommitStarted();
                GraphDiff changes = this.graphManager.getDiffsSinceLastFlush();
                try {
                    commitDiff = this.channel.onSync((ObjectContext)this, changes, syncType);
                }
                catch (Throwable th) {
                    this.graphManager.graphCommitAborted();
                    if (th instanceof CayenneRuntimeException) {
                        throw (CayenneRuntimeException)th;
                    }
                    throw new CayenneRuntimeException("Commit error", th, new Object[0]);
                }
                this.graphManager.graphCommitted(commitDiff);
                this.fireDataChannelCommitted((Object)this, changes);
            }
        }
        return commitDiff;
    }

    public void commitChangesToParent() {
        this.doCommitChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                GraphDiff diff = this.graphManager.getDiffs();
                this.graphManager.graphReverted();
                this.channel.onSync((ObjectContext)this, diff, 3);
                this.fireDataChannelRolledback((Object)this, diff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChangesLocally() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                GraphDiff diff = this.graphManager.getDiffs();
                this.graphManager.graphReverted();
                this.fireDataChannelRolledback((Object)this, diff);
            }
        }
    }

    public <T> T newObject(Class<T> persistentClass) {
        if (persistentClass == null) {
            throw new NullPointerException("Persistent class can't be null.");
        }
        ObjEntity entity = this.getEntityResolver().getObjEntity(persistentClass);
        if (entity == null) {
            throw new CayenneRuntimeException("No entity mapped for class: %s", new Object[]{persistentClass});
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        Object object = descriptor.createObject();
        descriptor.injectValueHolders(object);
        this.registerNewObject((Persistent)object, entity.getName(), descriptor);
        return (T)object;
    }

    public void registerNewObject(Object object) {
        if (object == null) {
            throw new NullPointerException("An attempt to register null object.");
        }
        ObjEntity entity = this.getEntityResolver().getObjEntity(object.getClass());
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        this.registerNewObject((Persistent)object, entity.getName(), descriptor);
    }

    public List performQuery(Query query) {
        List result = this.onQuery((ObjectContext)this, query).firstList();
        return result != null ? result : new ArrayList(1);
    }

    public QueryResponse performGenericQuery(Query query) {
        return this.onQuery((ObjectContext)this, query);
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new CayenneContextQueryAction(this, context, query).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<?> uncommittedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<?> deletedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<?> modifiedObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<?> newObjects() {
        CayenneContextGraphManager cayenneContextGraphManager = this.graphManager;
        synchronized (cayenneContextGraphManager) {
            return this.graphManager.dirtyNodes(2);
        }
    }

    void registerNewObject(Persistent object, String entityName, ClassDescriptor descriptor) {
        ObjectId id = object.getObjectId();
        if (id == null) {
            id = new ObjectId(entityName);
            object.setObjectId(id);
        }
        this.injectInitialValue(object);
    }

    Persistent createFault(ObjectId id) {
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        Persistent object = (Persistent)descriptor.createObject();
        object.setPersistenceState(5);
        object.setObjectContext((ObjectContext)this);
        object.setObjectId(id);
        this.graphManager.registerNode(id, object);
        return object;
    }

    protected GraphDiff onContextFlush(ObjectContext originatingContext, GraphDiff changes, boolean cascade) {
        boolean childContext;
        boolean bl = childContext = this != originatingContext && changes != null;
        if (childContext) {
            changes.apply((GraphChangeHandler)new CayenneContextChildDiffLoader(this));
            this.fireDataChannelChanged(originatingContext, changes);
        }
        return cascade ? this.doCommitChanges(true) : new CompoundDiff();
    }

    public boolean hasChanges() {
        return this.graphManager.hasChanges();
    }

    public <T> ResultIterator<T> iterator(Select<T> query) {
        List objects = this.select(query);
        return new CollectionResultIterator((Collection)objects);
    }
}

