/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import org.apache.cayenne.DataObject;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.lifecycle.id.IdCoder;
import org.apache.cayenne.lifecycle.relationship.ObjectIdPropagatedValueFactory;
import org.apache.cayenne.lifecycle.relationship.ObjectIdRelationship;

public class ObjectIdRelationshipHandler {
    protected IdCoder referenceableHandler;

    public ObjectIdRelationshipHandler(IdCoder referenceableHandler) {
        this.referenceableHandler = referenceableHandler;
    }

    public String objectIdRelationshipName(String uuidPropertyName) {
        return "cay:related:" + uuidPropertyName;
    }

    public String objectIdPropertyName(DataObject object) {
        ObjectIdRelationship annotation = object.getClass().getAnnotation(ObjectIdRelationship.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Object class is not annotated with @UuidRelationship: " + object.getClass().getName());
        }
        return annotation.value();
    }

    public void relate(DataObject from, DataObject to) {
        if (from.getObjectContext() == null) {
            throw new IllegalArgumentException("'from' has null ObjectContext");
        }
        String property = this.objectIdPropertyName(from);
        String relationship = this.objectIdRelationshipName(property);
        if (to != null) {
            if (to.getObjectContext() == null) {
                throw new IllegalArgumentException("'to' has null ObjectContext");
            }
            if (from.getObjectContext() != to.getObjectContext()) {
                throw new IllegalArgumentException("'from' and 'to' objects are registered in different ObjectContexts");
            }
            from.writePropertyDirectly(relationship, (Object)to);
            if (to.getObjectId().isTemporary() && !to.getObjectId().isReplacementIdAttached()) {
                from.writeProperty(property, (Object)new ObjectIdPropagatedValueFactory(this.referenceableHandler, (Persistent)to));
            } else {
                String uuid = this.referenceableHandler.getStringId((Persistent)to);
                from.writeProperty(property, (Object)uuid);
            }
        } else {
            from.writeProperty(property, null);
            from.writePropertyDirectly(relationship, null);
        }
    }
}

