/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateQueryUndoableEdit
extends CayenneUndoableEdit {
    private DataChannelDescriptor domain;
    private DataMap map;
    private QueryDescriptor query;

    public CreateQueryUndoableEdit(DataChannelDescriptor domain, DataMap map, QueryDescriptor query) {
        this.domain = domain;
        this.map = map;
        this.query = query;
    }

    @Override
    public void redo() throws CannotRedoException {
        CreateQueryAction action = this.actionManager.getAction(CreateQueryAction.class);
        action.createQuery(this.domain, this.map, this.query);
    }

    @Override
    public String getPresentationName() {
        return "Create Query";
    }

    @Override
    public void undo() throws CannotUndoException {
        RemoveAction action = this.actionManager.getAction(RemoveAction.class);
        action.removeQuery(this.map, this.query);
    }
}

