/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.prefs.Preferences;
import javax.sql.DataSource;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.datasource.DriverDataSource;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.util.Util;

public class DBConnectionInfo
extends CayennePreference {
    public static final String DB_ADAPTER_PROPERTY = "dbAdapter";
    public static final String JDBC_DRIVER_PROPERTY = "jdbcDriver";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String URL_PROPERTY = "url";
    public static final String USER_NAME_PROPERTY = "userName";
    private static final String DB_CONNECTION_INFO = "dbConnectionInfo";
    public static final String ID_PK_COLUMN = "id";
    private String nodeName;
    private String dbAdapter;
    private String jdbcDriver;
    private String password;
    private String url;
    private String userName;
    private Preferences dbConnectionInfoPreferences = this.getCayennePreference().node("dbConnectionInfo");

    public DBConnectionInfo() {
        this.setCurrentPreference(this.dbConnectionInfoPreferences);
    }

    public DBConnectionInfo(String nameNode, boolean initFromPreferences) {
        this();
        this.setNodeName(nameNode);
        if (initFromPreferences) {
            this.initObjectPreference();
        }
    }

    @Override
    public Preferences getCurrentPreference() {
        if (this.getNodeName() == null) {
            return super.getCurrentPreference();
        }
        return this.dbConnectionInfoPreferences.node(this.getNodeName());
    }

    @Override
    public void setObject(CayennePreference object) {
        if (object instanceof DBConnectionInfo) {
            this.setUrl(((DBConnectionInfo)object).getUrl());
            this.setUserName(((DBConnectionInfo)object).getUserName());
            this.setPassword(((DBConnectionInfo)object).getPassword());
            this.setJdbcDriver(((DBConnectionInfo)object).getJdbcDriver());
            this.setDbAdapter(((DBConnectionInfo)object).getDbAdapter());
        }
    }

    @Override
    public void saveObjectPreference() {
        if (this.getCurrentPreference() != null) {
            if (this.getDbAdapter() != null) {
                this.getCurrentPreference().put(DB_ADAPTER_PROPERTY, this.getDbAdapter());
            }
            if (this.getUrl() != null) {
                this.getCurrentPreference().put(URL_PROPERTY, this.getUrl());
            }
            if (this.getUserName() != null) {
                this.getCurrentPreference().put(USER_NAME_PROPERTY, this.getUserName());
            }
            if (this.getPassword() != null) {
                this.getCurrentPreference().put(PASSWORD_PROPERTY, this.getPassword());
            }
            if (this.getJdbcDriver() != null) {
                this.getCurrentPreference().put(JDBC_DRIVER_PROPERTY, this.getJdbcDriver());
            }
        }
    }

    public void initObjectPreference() {
        if (this.getCurrentPreference() != null) {
            this.setDbAdapter(this.getCurrentPreference().get(DB_ADAPTER_PROPERTY, null));
            this.setUrl(this.getCurrentPreference().get(URL_PROPERTY, null));
            this.setUserName(this.getCurrentPreference().get(USER_NAME_PROPERTY, null));
            this.setPassword(this.getCurrentPreference().get(PASSWORD_PROPERTY, null));
            this.setJdbcDriver(this.getCurrentPreference().get(JDBC_DRIVER_PROPERTY, null));
            this.setNodeName(this.getCurrentPreference().name());
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getDbAdapter() {
        return this.dbAdapter;
    }

    public void setDbAdapter(String dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Preferences getDbConnectionInfoPreferences() {
        return this.dbConnectionInfoPreferences;
    }

    public void setDbConnectionInfoPreferences(Preferences dbConnectionInfoPreferences) {
        this.dbConnectionInfoPreferences = dbConnectionInfoPreferences;
    }

    public DbAdapter makeAdapter(ClassLoadingService classLoader) throws Exception {
        String adapterClassName = this.getDbAdapter();
        Application appInstance = Application.getInstance();
        if (adapterClassName == null || AutoAdapter.class.getName().equals(adapterClassName)) {
            return appInstance.getInjector().getInstance(DbAdapterFactory.class).createAdapter(null, this.makeDataSource(classLoader));
        }
        try {
            return appInstance.getInjector().getInstance(AdhocObjectFactory.class).newInstance(DbAdapter.class, adapterClassName);
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            throw new Exception("DbAdapter load error: " + th.getLocalizedMessage());
        }
    }

    public DataSource makeDataSource(ClassLoadingService classLoader) throws SQLException {
        Driver driver;
        if (this.getJdbcDriver() == null) {
            throw new SQLException("No JDBC driver set.");
        }
        if (this.getUrl() == null) {
            throw new SQLException("No DB URL set.");
        }
        try {
            driver = classLoader.loadClass(Driver.class, this.getJdbcDriver()).newInstance();
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            throw new SQLException("Driver load error: " + th.getLocalizedMessage());
        }
        return new DriverDataSource(driver, this.getUrl(), this.getUserName(), this.getPassword());
    }

    public boolean copyTo(DBConnectionInfo dataSourceInfo) {
        boolean updated = false;
        if (!Util.nullSafeEquals(dataSourceInfo.getUrl(), this.getUrl())) {
            dataSourceInfo.setUrl(this.getUrl());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getUserName(), this.getUserName())) {
            dataSourceInfo.setUserName(this.getUserName());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getPassword(), this.getPassword())) {
            dataSourceInfo.setPassword(this.getPassword());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getJdbcDriver(), this.getJdbcDriver())) {
            dataSourceInfo.setJdbcDriver(this.getJdbcDriver());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getDbAdapter(), this.getDbAdapter())) {
            dataSourceInfo.setDbAdapter(this.getDbAdapter());
            updated = true;
        }
        return updated;
    }

    public boolean copyTo(DataSourceInfo dataSourceInfo) {
        boolean updated = false;
        if (!Util.nullSafeEquals(dataSourceInfo.getDataSourceUrl(), this.getUrl())) {
            dataSourceInfo.setDataSourceUrl(this.getUrl());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getUserName(), this.getUserName())) {
            dataSourceInfo.setUserName(this.getUserName());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getPassword(), this.getPassword())) {
            dataSourceInfo.setPassword(this.getPassword());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getJdbcDriver(), this.getJdbcDriver())) {
            dataSourceInfo.setJdbcDriver(this.getJdbcDriver());
            updated = true;
        }
        return updated;
    }

    public boolean copyFrom(DataSourceInfo dataSourceInfo) {
        boolean updated = false;
        if (!Util.nullSafeEquals(dataSourceInfo.getDataSourceUrl(), this.getUrl())) {
            this.setUrl(dataSourceInfo.getDataSourceUrl());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getUserName(), this.getUserName())) {
            this.setUserName(dataSourceInfo.getUserName());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getPassword(), this.getPassword())) {
            this.setPassword(dataSourceInfo.getPassword());
            updated = true;
        }
        if (!Util.nullSafeEquals(dataSourceInfo.getJdbcDriver(), this.getJdbcDriver())) {
            this.setJdbcDriver(dataSourceInfo.getJdbcDriver());
            updated = true;
        }
        return updated;
    }
}

