/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ProcedureParameterValidator
extends ConfigurationNodeValidator {
    ProcedureParameterValidator() {
    }

    void validate(ProcedureParameter parameter, ValidationResult validationResult) {
        if (Util.isEmptyString(parameter.getName())) {
            this.addFailure(validationResult, parameter, "Unnamed ProcedureParameter", new Object[0]);
        }
        if (parameter.getType() == Integer.MAX_VALUE) {
            this.addFailure(validationResult, parameter, "ProcedureParameter '%s' has no type", parameter.getName());
        }
        if (parameter.getMaxLength() < 0 && (parameter.getType() == 12 || parameter.getType() == 1)) {
            this.addFailure(validationResult, parameter, "Character ProcedureParameter '%s' doesn't have max length", parameter.getName());
        }
        if (parameter.getDirection() <= 0) {
            this.addFailure(validationResult, parameter, "ProcedureParameter '%s' has no direction", parameter.getName());
        }
    }
}

