/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.io.Serializable;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.modeler.graph.GraphBuilder;

abstract class EntityCellMetadata
implements Serializable {
    GraphBuilder builder;
    String entityName;
    String label;

    EntityCellMetadata() {
    }

    EntityCellMetadata(GraphBuilder builder, String entityName) {
        this.builder = builder;
        this.entityName = entityName;
        this.rebuildLabel();
    }

    public abstract Entity fetchEntity();

    final void rebuildLabel() {
        this.label = this.createLabel();
    }

    public String toString() {
        if (this.label == null) {
            this.rebuildLabel();
        }
        return this.label;
    }

    String createLabel() {
        Entity entity = this.fetchEntity();
        StringBuilder label = new StringBuilder("<html><center><u><b>").append(entity.getName()).append("</b></u></center>");
        for (Attribute attribute : entity.getAttributes()) {
            if (!this.isPrimary(attribute)) continue;
            label.append("<br><i>").append(attribute.getName()).append("</i>");
        }
        for (Attribute attribute : entity.getAttributes()) {
            if (this.isPrimary(attribute)) continue;
            label.append("<br>").append(attribute.getName());
        }
        return label.toString();
    }

    protected abstract boolean isPrimary(Attribute var1);
}

