/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.ObjectQueryPropertiesPanel;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.ExpressionConvertor;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.modeler.util.ValidatorTextAdapter;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class SelectQueryMainTab
extends JPanel {
    protected ProjectController mediator;
    protected TextAdapter name;
    protected JComboBox queryRoot;
    protected TextAdapter qualifier;
    protected JCheckBox distinct;
    protected ObjectQueryPropertiesPanel properties;

    public SelectQueryMainTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            protected void updateModel(String text) {
                SelectQueryMainTab.this.setQueryName(text);
            }
        };
        this.queryRoot = Application.getWidgetFactory().createComboBox();
        AutoCompletion.enable(this.queryRoot);
        this.queryRoot.setRenderer(CellRenderers.listRendererWithIcons());
        this.qualifier = new ValidatorTextAdapter(new JTextField()){

            protected void updateModel(String text) {
                SelectQueryMainTab.this.setQueryQualifier(text);
            }

            protected void validate(String text) throws ValidationException {
                SelectQueryMainTab.this.createQualifier(text);
            }
        };
        this.distinct = new JCheckBox();
        this.properties = new ObjectQueryPropertiesPanel(this.mediator);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:200dlu", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("SelectQuery Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        builder.addLabel("Query Root:", cc.xy(1, 5));
        builder.add((Component)this.queryRoot, cc.xy(3, 5));
        builder.addLabel("Qualifier:", cc.xy(1, 7));
        builder.add((Component)this.qualifier.getComponent(), cc.xy(3, 7));
        builder.addLabel("Distinct:", cc.xy(1, 9));
        builder.add((Component)this.distinct, cc.xy(3, 9));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    private void initController() {
        RootSelectionHandler rootHandler = new RootSelectionHandler();
        this.queryRoot.addActionListener(rootHandler);
        this.queryRoot.addFocusListener(rootHandler);
        this.queryRoot.getEditor().getEditorComponent().addFocusListener(rootHandler);
        this.distinct.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectQuery query = SelectQueryMainTab.this.getQuery();
                if (query != null) {
                    query.setDistinct(SelectQueryMainTab.this.distinct.isSelected());
                    SelectQueryMainTab.this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
                }
            }
        });
    }

    void initFromModel() {
        Query query = this.mediator.getCurrentQuery();
        if (!(query instanceof SelectQuery)) {
            this.setVisible(false);
            return;
        }
        SelectQuery selectQuery = (SelectQuery)query;
        this.name.setText(query.getName());
        this.distinct.setSelected(selectQuery.isDistinct());
        this.qualifier.setText(selectQuery.getQualifier() != null ? selectQuery.getQualifier().toString() : null);
        DataMap map = this.mediator.getCurrentDataMap();
        Object[] roots = map.getObjEntities().toArray();
        if (roots.length > 1) {
            Arrays.sort(roots, Comparators.getDataMapChildrenComparator());
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(roots);
        model.setSelectedItem(selectQuery.getRoot());
        this.queryRoot.setModel(model);
        this.properties.initFromModel(selectQuery);
        this.setVisible(true);
    }

    protected SelectQuery getQuery() {
        return this.mediator.getCurrentQuery() instanceof SelectQuery ? (SelectQuery)this.mediator.getCurrentQuery() : null;
    }

    void setQueryQualifier(String text) {
        Expression qualifier;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((qualifier = this.createQualifier(text)) != null) {
            this.getQuery().setQualifier(qualifier);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.getQuery()));
        }
    }

    Expression createQualifier(String text) throws ValidationException {
        SelectQuery query = this.getQuery();
        if (query == null) {
            return null;
        }
        ExpressionConvertor convertor = new ExpressionConvertor();
        try {
            String oldQualifier = convertor.valueAsString(query.getQualifier());
            if (!Util.nullSafeEquals(oldQualifier, text)) {
                Expression exp = (Expression)convertor.stringAsValue(text);
                if (query.getRoot() instanceof Entity) {
                    SelectQueryMainTab.checkExpression((Entity)query.getRoot(), exp);
                }
                return exp;
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException(ex.getMessage(), new Object[0]);
        }
    }

    void setQueryName(String newName) {
        SelectQuery query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = this.getQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals(newName, query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("SelectQuery name is required.", new Object[0]);
        }
        DataMap map = this.mediator.getCurrentDataMap();
        Query matchingQuery = map.getQuery(newName);
        if (matchingQuery == null) {
            QueryEvent e = new QueryEvent((Object)this, (Query)query, query.getName());
            ProjectUtil.setQueryName(map, query, newName);
            this.mediator.fireQueryEvent(e);
        } else if (matchingQuery != query) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.", new Object[0]);
        }
    }

    static void checkExpression(Entity root, Expression ex) throws ValidationException {
        try {
            if (ex instanceof ASTPath) {
                Iterator<CayenneMapEntry> path = root.resolvePathComponents(ex);
                while (path.hasNext()) {
                    path.next();
                }
            }
            if (ex != null) {
                for (int i = 0; i < ex.getOperandCount(); ++i) {
                    if (!(ex.getOperand(i) instanceof Expression)) continue;
                    SelectQueryMainTab.checkExpression(root, (Expression)ex.getOperand(i));
                }
            }
        }
        catch (ExpressionException eex) {
            throw new ValidationException(eex.getUnlabeledMessage(), new Object[0]);
        }
    }

    class RootSelectionHandler
    implements FocusListener,
    ActionListener {
        String newName = null;
        boolean needChangeName;

        RootSelectionHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            Entity root;
            SelectQuery query = SelectQueryMainTab.this.getQuery();
            if (query != null && (root = (Entity)SelectQueryMainTab.this.queryRoot.getModel().getSelectedItem()) != null) {
                query.setRoot(root);
                if (this.needChangeName) {
                    String newPrefix;
                    this.newName = newPrefix = root.getName() + "Query";
                    DataMap map = SelectQueryMainTab.this.mediator.getCurrentDataMap();
                    long postfix = 1L;
                    while (map.getQuery(this.newName) != null) {
                        this.newName = newPrefix + postfix++;
                    }
                    SelectQueryMainTab.this.name.setText(this.newName);
                }
            }
        }

        public void focusGained(FocusEvent e) {
            this.newName = null;
            SelectQuery query = SelectQueryMainTab.this.getQuery();
            this.needChangeName = query != null ? this.hasDefaultName(query) : false;
        }

        public void focusLost(FocusEvent e) {
            if (this.newName != null) {
                SelectQueryMainTab.this.setQueryName(this.newName);
            }
            this.newName = null;
            this.needChangeName = false;
        }

        boolean hasDefaultName(SelectQuery query) {
            String prefix = query.getRoot() == null ? "UntitledQuery" : CellRenderers.asString(query.getRoot()) + "Query";
            return SelectQueryMainTab.this.name.getComponent().getText().startsWith(prefix);
        }
    }
}

