/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.modeler.FileClassLoadingService;
import org.apache.cayenne.modeler.dialog.pref.ClasspathPreferences;
import org.apache.cayenne.modeler.dialog.pref.DataSourceCreator;
import org.apache.cayenne.modeler.dialog.pref.DataSourceDuplicator;
import org.apache.cayenne.modeler.dialog.pref.DataSourcePreferencesView;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.CayennePreferenceEditor;
import org.apache.cayenne.pref.ChildrenMapPreference;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class DataSourcePreferences
extends CayenneController {
    protected DataSourcePreferencesView view = new DataSourcePreferencesView(this);
    protected String dataSourceKey;
    protected Map dataSources;
    protected ChildrenMapPreference dataSourcePreferences;
    protected CayennePreferenceEditor editor;

    public DataSourcePreferences(PreferenceDialog parentController) {
        super(parentController);
        PreferenceEditor editor = parentController.getEditor();
        if (editor instanceof CayennePreferenceEditor) {
            this.editor = (CayennePreferenceEditor)editor;
        }
        this.dataSourcePreferences = this.getApplication().getCayenneProjectPreferences().getDetailObject(DBConnectionInfo.class);
        this.dataSources = this.dataSourcePreferences.getChildrenPreferences();
        Object[] keys = this.dataSources.keySet().toArray();
        Arrays.sort(keys);
        DefaultComboBoxModel<Object> dataSourceModel = new DefaultComboBoxModel<Object>(keys);
        this.view.getDataSources().setModel(dataSourceModel);
        this.initBindings();
        if (keys.length > 0) {
            this.view.getDataSources().setSelectedIndex(0);
            this.editDataSourceAction();
        }
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getAddDataSource(), "newDataSourceAction()");
        builder.bindToAction(this.view.getDuplicateDataSource(), "duplicateDataSourceAction()");
        builder.bindToAction(this.view.getRemoveDataSource(), "removeDataSourceAction()");
        builder.bindToAction(this.view.getTestDataSource(), "testDataSourceAction()");
        builder.bindToComboSelection(this.view.getDataSources(), "dataSourceKey");
    }

    public Map getDataSources() {
        return this.dataSources;
    }

    public String getDataSourceKey() {
        return this.dataSourceKey;
    }

    public void setDataSourceKey(String dataSourceKey) {
        this.dataSourceKey = dataSourceKey;
        this.editDataSourceAction();
    }

    public DBConnectionInfo getConnectionInfo() {
        return (DBConnectionInfo)this.dataSourcePreferences.getObject(this.dataSourceKey);
    }

    public void newDataSourceAction() {
        DataSourceCreator creatorWizard = new DataSourceCreator(this);
        DBConnectionInfo dataSource = creatorWizard.startupAction();
        if (dataSource != null) {
            this.dataSourcePreferences.create(creatorWizard.getName(), dataSource);
            this.dataSources = this.dataSourcePreferences.getChildrenPreferences();
            Object[] keys = this.dataSources.keySet().toArray();
            Arrays.sort(keys);
            this.view.getDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
            this.view.getDataSources().setSelectedItem(creatorWizard.getName());
            this.editDataSourceAction();
        }
    }

    public void duplicateDataSourceAction() {
        DataSourceDuplicator wizard;
        DBConnectionInfo dataSource;
        Object selected = this.view.getDataSources().getSelectedItem();
        if (selected != null && (dataSource = (wizard = new DataSourceDuplicator(this, selected.toString())).startupAction()) != null) {
            this.dataSourcePreferences.create(wizard.getName(), dataSource);
            this.dataSources = this.dataSourcePreferences.getChildrenPreferences();
            Object[] keys = this.dataSources.keySet().toArray();
            Arrays.sort(keys);
            this.view.getDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
            this.view.getDataSources().setSelectedItem(wizard.getName());
            this.editDataSourceAction();
        }
    }

    public void removeDataSourceAction() {
        String key = this.getDataSourceKey();
        if (key != null) {
            this.dataSourcePreferences.remove(key);
            this.dataSources = this.dataSourcePreferences.getChildrenPreferences();
            Object[] keys = this.dataSources.keySet().toArray();
            Arrays.sort(keys);
            this.view.getDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
            this.editDataSourceAction(keys.length > 0 ? keys[0] : null);
        }
    }

    public void editDataSourceAction(Object dataSourceKey) {
        this.view.getDataSources().setSelectedItem(dataSourceKey);
        this.editDataSourceAction();
    }

    public void editDataSourceAction() {
        this.view.getDataSourceEditor().setConnectionInfo(this.getConnectionInfo());
    }

    public void testDataSourceAction() {
        DBConnectionInfo currentDataSource = this.getConnectionInfo();
        if (currentDataSource == null) {
            return;
        }
        if (currentDataSource.getJdbcDriver() == null) {
            JOptionPane.showMessageDialog(null, "No JDBC Driver specified", "Warning", 2);
            return;
        }
        if (currentDataSource.getUrl() == null) {
            JOptionPane.showMessageDialog(null, "No Database URL specified", "Warning", 2);
            return;
        }
        try {
            String key;
            Map<String, String> map;
            FileClassLoadingService classLoader = new FileClassLoadingService();
            List<File> oldPathFiles = ((FileClassLoadingService)this.getApplication().getClassLoadingService()).getPathFiles();
            ArrayList<String> details = new ArrayList<String>();
            for (int i = 0; i < oldPathFiles.size(); ++i) {
                details.add(oldPathFiles.get(i).getAbsolutePath());
            }
            Preferences classPathPreferences = this.getApplication().getPreferencesNode(ClasspathPreferences.class, "");
            if (this.editor.getChangedPreferences().containsKey(classPathPreferences)) {
                map = this.editor.getChangedPreferences().get(classPathPreferences);
                for (Map.Entry<String, String> en : map.entrySet()) {
                    key = en.getKey();
                    if (details.contains(key)) continue;
                    details.add(key);
                }
            }
            if (this.editor.getRemovedPreferences().containsKey(classPathPreferences)) {
                map = this.editor.getRemovedPreferences().get(classPathPreferences);
                for (Map.Entry<String, String> en : map.entrySet()) {
                    key = en.getKey();
                    if (!details.contains(key)) continue;
                    details.remove(key);
                }
            }
            if (details.size() > 0) {
                Transformer transformer = new Transformer(){

                    public Object transform(Object object) {
                        String pref = (String)object;
                        return new File(pref);
                    }
                };
                classLoader.setPathFiles(CollectionUtils.collect(details, transformer));
            }
            Class<Driver> driverClass = classLoader.loadClass(Driver.class, currentDataSource.getJdbcDriver());
            Driver driver = driverClass.newInstance();
            Connection c = new DriverDataSource(driver, currentDataSource.getUrl(), currentDataSource.getUserName(), currentDataSource.getPassword()).getConnection();
            try {
                c.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, "Connected Successfully", "Success", 1);
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            String message = "Error connecting to DB: " + th.getLocalizedMessage();
            StringTokenizer st = new StringTokenizer(message);
            StringBuilder sbMessage = new StringBuilder();
            int len = 0;
            while (st.hasMoreTokens()) {
                String tempString = st.nextElement().toString();
                if (len < 110) {
                    len = len + tempString.length() + 1;
                } else {
                    sbMessage.append("\n");
                    len = 0;
                }
                sbMessage.append(tempString + " ");
            }
            JOptionPane.showMessageDialog(null, sbMessage.toString(), "Warning", 2);
            return;
        }
    }
}

