/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.AboutAction;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.ConfigurePreferencesAction;
import org.apache.cayenne.modeler.action.CopyAction;
import org.apache.cayenne.modeler.action.CopyAttributeAction;
import org.apache.cayenne.modeler.action.CopyProcedureParameterAction;
import org.apache.cayenne.modeler.action.CopyRelationshipAction;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodAction;
import org.apache.cayenne.modeler.action.CreateCallbackMethodForListenerAction;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDataMapEntityListenerAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateObjEntityListenerAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateProcedureParameterAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.CutAction;
import org.apache.cayenne.modeler.action.CutAttributeAction;
import org.apache.cayenne.modeler.action.CutProcedureParameterAction;
import org.apache.cayenne.modeler.action.CutRelationshipAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.DocumentationAction;
import org.apache.cayenne.modeler.action.ExitAction;
import org.apache.cayenne.modeler.action.FindAction;
import org.apache.cayenne.modeler.action.GenerateCodeAction;
import org.apache.cayenne.modeler.action.GenerateDBAction;
import org.apache.cayenne.modeler.action.ImportDBAction;
import org.apache.cayenne.modeler.action.ImportDataMapAction;
import org.apache.cayenne.modeler.action.ImportEOModelAction;
import org.apache.cayenne.modeler.action.InferRelationshipsAction;
import org.apache.cayenne.modeler.action.MigrateAction;
import org.apache.cayenne.modeler.action.NavigateBackwardAction;
import org.apache.cayenne.modeler.action.NavigateForwardAction;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.action.RedoAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodForListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerAction;
import org.apache.cayenne.modeler.action.RemoveEntityListenerForDataMapAction;
import org.apache.cayenne.modeler.action.RemoveProcedureParameterAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.action.RevertAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.modeler.action.ShowLogConsoleAction;
import org.apache.cayenne.modeler.action.UndoAction;
import org.apache.cayenne.modeler.action.ValidateAction;
import org.apache.cayenne.modeler.graph.action.ShowGraphEntityAction;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.ConfigurationNodeParentGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActionManager
implements ActionManager {
    private Collection<String> SPECIAL_ACTIONS;
    private Collection<String> PROJECT_ACTIONS;
    private Collection<String> DOMAIN_ACTIONS;
    private Collection<String> DATA_MAP_ACTIONS;
    private Collection<String> OBJ_ENTITY_ACTIONS;
    private Collection<String> DB_ENTITY_ACTIONS;
    private Collection<String> EMBEDDABLE_ACTIONS;
    private Collection<String> PROCEDURE_ACTIONS;
    private Collection<String> MULTIPLE_OBJECTS_ACTIONS;
    protected Map<String, Action> actionMap;

    public DefaultActionManager(@Inject Application application) {
        this.initActions();
        this.actionMap = new HashMap<String, Action>(40);
        this.registerAction(new ProjectAction(application));
        this.registerAction(new NewProjectAction(application)).setAlwaysOn(true);
        this.registerAction(new OpenProjectAction(application)).setAlwaysOn(true);
        this.registerAction(new ImportDataMapAction(application));
        this.registerAction(new SaveAction(application));
        this.registerAction(new SaveAsAction(application));
        this.registerAction(new RevertAction(application));
        this.registerAction(new ValidateAction(application));
        this.registerAction(new RemoveAction(application));
        this.registerAction(new CreateNodeAction(application));
        this.registerAction(new CreateDataMapAction(application));
        this.registerAction(new GenerateCodeAction(application));
        this.registerAction(new CreateObjEntityAction(application));
        this.registerAction(new CreateDbEntityAction(application));
        this.registerAction(new CreateProcedureAction(application));
        this.registerAction(new CreateProcedureParameterAction(application));
        this.registerAction(new RemoveProcedureParameterAction(application));
        this.registerAction(new CreateQueryAction(application));
        this.registerAction(new CreateAttributeAction(application));
        this.registerAction(new RemoveAttributeAction(application));
        this.registerAction(new CreateRelationshipAction(application));
        this.registerAction(new RemoveRelationshipAction(application));
        this.registerAction(new CreateCallbackMethodAction(application)).setAlwaysOn(true);
        this.registerAction(new CreateCallbackMethodForListenerAction(application));
        this.registerAction(new RemoveCallbackMethodAction(application));
        this.registerAction(new RemoveCallbackMethodForListenerAction(application));
        this.registerAction(new CreateObjEntityListenerAction(application)).setAlwaysOn(true);
        this.registerAction(new CreateDataMapEntityListenerAction(application)).setAlwaysOn(true);
        this.registerAction(new RemoveEntityListenerAction(application));
        this.registerAction(new RemoveEntityListenerForDataMapAction(application));
        this.registerAction(new DbEntitySyncAction(application));
        this.registerAction(new ObjEntitySyncAction(application));
        this.registerAction(new ImportDBAction(application));
        this.registerAction(new InferRelationshipsAction(application));
        this.registerAction(new ImportEOModelAction(application));
        this.registerAction(new GenerateDBAction(application));
        this.registerAction(new MigrateAction(application));
        this.registerAction(new AboutAction(application)).setAlwaysOn(true);
        this.registerAction(new DocumentationAction(application)).setAlwaysOn(true);
        this.registerAction(new ConfigurePreferencesAction(application)).setAlwaysOn(true);
        this.registerAction(new ExitAction(application)).setAlwaysOn(true);
        this.registerAction(new NavigateBackwardAction(application)).setAlwaysOn(true);
        this.registerAction(new NavigateForwardAction(application)).setAlwaysOn(true);
        this.registerAction(new FindAction(application));
        this.registerAction(new ShowLogConsoleAction(application)).setAlwaysOn(true);
        this.registerAction(new CutAction(application));
        this.registerAction(new CutAttributeAction(application));
        this.registerAction(new CutRelationshipAction(application));
        this.registerAction(new CutProcedureParameterAction(application));
        this.registerAction(new CopyAction(application));
        this.registerAction(new CopyAttributeAction(application));
        this.registerAction(new CopyRelationshipAction(application));
        this.registerAction(new CopyProcedureParameterAction(application));
        this.registerAction(new PasteAction(application));
        UndoAction undoAction = new UndoAction(application);
        undoAction.setEnabled(false);
        this.registerAction(undoAction);
        RedoAction redoAction = new RedoAction(application);
        redoAction.setEnabled(false);
        this.registerAction(redoAction);
        this.registerAction(new CreateEmbeddableAction(application));
        this.registerAction(new ShowGraphEntityAction(application));
    }

    private void initActions() {
        this.SPECIAL_ACTIONS = new HashSet<String>();
        this.SPECIAL_ACTIONS.addAll(Arrays.asList(SaveAction.class.getName(), UndoAction.class.getName(), RedoAction.class.getName()));
        this.PROJECT_ACTIONS = new HashSet<String>();
        this.PROJECT_ACTIONS.addAll(Arrays.asList(RevertAction.class.getName(), ProjectAction.class.getName(), ValidateAction.class.getName(), SaveAsAction.class.getName(), FindAction.class.getName()));
        this.DOMAIN_ACTIONS = new HashSet<String>(this.PROJECT_ACTIONS);
        this.DOMAIN_ACTIONS.addAll(Arrays.asList(ImportDataMapAction.class.getName(), CreateDataMapAction.class.getName(), RemoveAction.class.getName(), CreateNodeAction.class.getName(), ImportDBAction.class.getName(), ImportEOModelAction.class.getName(), PasteAction.class.getName()));
        this.DATA_MAP_ACTIONS = new HashSet<String>(this.DOMAIN_ACTIONS);
        this.DATA_MAP_ACTIONS.addAll(Arrays.asList(GenerateCodeAction.class.getName(), CreateEmbeddableAction.class.getName(), CreateObjEntityAction.class.getName(), CreateDbEntityAction.class.getName(), CreateQueryAction.class.getName(), CreateProcedureAction.class.getName(), GenerateDBAction.class.getName(), MigrateAction.class.getName(), InferRelationshipsAction.class.getName(), CutAction.class.getName(), CopyAction.class.getName()));
        this.OBJ_ENTITY_ACTIONS = new HashSet<String>(this.DATA_MAP_ACTIONS);
        this.OBJ_ENTITY_ACTIONS.addAll(Arrays.asList(ObjEntitySyncAction.class.getName(), CreateAttributeAction.class.getName(), CreateRelationshipAction.class.getName(), ShowGraphEntityAction.class.getName()));
        this.DB_ENTITY_ACTIONS = new HashSet<String>(this.DATA_MAP_ACTIONS);
        this.DB_ENTITY_ACTIONS.addAll(Arrays.asList(CreateAttributeAction.class.getName(), CreateRelationshipAction.class.getName(), DbEntitySyncAction.class.getName(), ShowGraphEntityAction.class.getName()));
        this.EMBEDDABLE_ACTIONS = new HashSet<String>(this.DATA_MAP_ACTIONS);
        this.EMBEDDABLE_ACTIONS.addAll(Arrays.asList(CreateAttributeAction.class.getName()));
        this.PROCEDURE_ACTIONS = new HashSet<String>(this.DATA_MAP_ACTIONS);
        this.PROCEDURE_ACTIONS.addAll(Arrays.asList(CreateProcedureParameterAction.class.getName()));
        this.MULTIPLE_OBJECTS_ACTIONS = new HashSet<String>(this.PROJECT_ACTIONS);
        this.MULTIPLE_OBJECTS_ACTIONS.addAll(Arrays.asList(RemoveAction.class.getName(), CutAction.class.getName(), CopyAction.class.getName(), PasteAction.class.getName()));
    }

    protected CayenneAction registerAction(CayenneAction action) {
        Action oldAction = this.actionMap.put(action.getClass().getName(), action);
        if (oldAction != null && oldAction != action) {
            this.actionMap.put(action.getClass().getName(), oldAction);
            throw new IllegalArgumentException("There is already an action of type " + action.getClass().getName() + ", attempt to register a second instance.");
        }
        return action;
    }

    public void addProjectAction(String actionName) {
        if (!this.PROJECT_ACTIONS.contains(actionName)) {
            this.PROJECT_ACTIONS.add(actionName);
        }
    }

    public void removeProjectaction(String actionName) {
        if (this.PROJECT_ACTIONS.contains(actionName)) {
            this.PROJECT_ACTIONS.remove(actionName);
        }
    }

    @Override
    public <T extends Action> T getAction(Class<T> actionClass) {
        return (T)this.actionMap.get(actionClass.getName());
    }

    @Override
    public void projectOpened() {
        this.processActionsState(this.PROJECT_ACTIONS);
        this.updateActions("");
    }

    @Override
    public void projectClosed() {
        this.processActionsState(Collections.<String>emptySet());
        this.updateActions("");
    }

    @Override
    public void domainSelected() {
        this.processActionsState(this.DOMAIN_ACTIONS);
        this.updateActions("DataDomain");
    }

    @Override
    public void dataNodeSelected() {
        this.processActionsState(this.DOMAIN_ACTIONS);
        this.updateActions("DataNode");
    }

    @Override
    public void dataMapSelected() {
        this.processActionsState(this.DATA_MAP_ACTIONS);
        this.updateActions("DataMap");
    }

    @Override
    public void objEntitySelected() {
        this.processActionsState(this.OBJ_ENTITY_ACTIONS);
        this.updateActions("ObjEntity");
    }

    @Override
    public void dbEntitySelected() {
        this.processActionsState(this.DB_ENTITY_ACTIONS);
        this.updateActions("DbEntity");
    }

    @Override
    public void procedureSelected() {
        this.processActionsState(this.PROCEDURE_ACTIONS);
        this.updateActions("Procedure");
    }

    @Override
    public void querySelected() {
        this.processActionsState(this.DATA_MAP_ACTIONS);
        this.updateActions("Query");
    }

    @Override
    public void embeddableSelected() {
        this.processActionsState(this.EMBEDDABLE_ACTIONS);
        this.updateActions("Embeddable");
    }

    @Override
    public void multipleObjectsSelected(ConfigurationNode[] objects, Application application) {
        this.processActionsState(this.MULTIPLE_OBJECTS_ACTIONS);
        this.updateActions("Selected Objects");
        CayenneAction cutAction = this.getAction(CutAction.class);
        boolean canCopy = true;
        if (!cutAction.enableForPath(objects[0])) {
            canCopy = false;
        } else {
            ConfigurationNodeParentGetter parentGetter = application.getInjector().getInstance(ConfigurationNodeParentGetter.class);
            ConfigurationNode parent = parentGetter.getParent(objects[0]);
            for (int i = 1; i < objects.length; ++i) {
                if (parentGetter.getParent(objects[i]) == parent && cutAction.enableForPath(objects[i])) continue;
                canCopy = false;
                break;
            }
        }
        cutAction.setEnabled(canCopy);
        this.getAction(CopyAction.class).setEnabled(canCopy);
    }

    private void updateActions(String postfix) {
        if (postfix.length() > 0) {
            postfix = " " + postfix;
        }
        this.getAction(RemoveAction.class).setName("Remove" + postfix);
        this.getAction(CutAction.class).setName("Cut" + postfix);
        this.getAction(CopyAction.class).setName("Copy" + postfix);
        this.getAction(PasteAction.class).updateState();
    }

    protected void processActionsState(Collection<String> namesOfEnabled) {
        for (Map.Entry<String, Action> entry : this.actionMap.entrySet()) {
            if (this.SPECIAL_ACTIONS.contains(entry.getKey())) continue;
            entry.getValue().setEnabled(namesOfEnabled.contains(entry.getKey()));
        }
    }

    @Override
    public void setupCutCopyPaste(JComponent comp, Class<? extends Action> cutActionType, Class<? extends Action> copyActionType) {
        ActionMap map = comp.getActionMap();
        map.put(TransferHandler.getCutAction().getValue("Name"), this.getAction(cutActionType));
        map.put(TransferHandler.getCopyAction().getValue("Name"), this.getAction(copyActionType));
        map.put(TransferHandler.getPasteAction().getValue("Name"), this.getAction(PasteAction.class));
    }
}

