/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationstatus;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Objects;
import org.apache.camel.v1.integrationstatus.Catalog;

public class CatalogFluent<A extends CatalogFluent<A>>
extends BaseFluent<A> {
    private String provider;
    private String version;

    public CatalogFluent() {
    }

    public CatalogFluent(Catalog instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Catalog instance) {
        Catalog catalog = instance = instance != null ? instance : new Catalog();
        if (instance != null) {
            this.withProvider(instance.getProvider());
            this.withVersion(instance.getVersion());
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public A withProvider(String provider) {
        this.provider = provider;
        return (A)((Object)this);
    }

    public boolean hasProvider() {
        return this.provider != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogFluent that = (CatalogFluent)((Object)o);
        if (!Objects.equals(this.provider, that.provider)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.provider != null) {
            sb.append("provider:");
            sb.append(this.provider + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }
}

